/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTestMethodAnnotationsCheck
extends BaseJavaTermCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        if (!javaTerm.isPublic() || !fileName.endsWith("Test.java")) {
            return javaTerm.getContent();
        }
        JavaClass parentJavaClass = javaTerm.getParentJavaClass();
        if (parentJavaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        this._checkAnnotationForMethod(fileName, javaTerm, "^tearDown(?!Class)", false, "After", "AfterEach");
        this._checkAnnotationForMethod(fileName, javaTerm, "^tearDownClass", true, "AfterAll", "AfterClass");
        this._checkAnnotationForMethod(fileName, javaTerm, "^setUp(?!Class)", false, "Before", "BeforeEach");
        this._checkAnnotationForMethod(fileName, javaTerm, "^setUpClass", true, "BeforeAll", "BeforeClass");
        this._checkAnnotationForMethod(fileName, javaTerm, "^test", false, "Test");
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private void _checkAnnotationForMethod(String fileName, JavaTerm javaTerm, String requiredMethodNameRegex, boolean staticRequired, String ... annotations) {
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        boolean hasAnnotation = false;
        for (String annotation : annotations) {
            if (!javaTerm.hasAnnotation(annotation)) continue;
            hasAnnotation = true;
            break;
        }
        if (hasAnnotation) {
            if (!matcher.find()) {
                this.addMessage(fileName, "Incorrect method name '" + methodName + "'", javaTerm.getLineNumber());
            } else if (javaTerm.isStatic() != staticRequired) {
                this.addMessage(fileName, "Incorrect method type for '" + methodName + "'", javaTerm.getLineNumber());
            }
            return;
        }
        if (!matcher.find()) {
            return;
        }
        JavaSignature signature = javaTerm.getSignature();
        List<JavaParameter> parameters = signature.getParameters();
        if (!parameters.isEmpty()) {
            return;
        }
        JavaClass javaClass = javaTerm.getParentJavaClass();
        if (javaClass.isAnonymous()) {
            return;
        }
        JavaClass parentJavaClass = javaClass.getParentJavaClass();
        if (parentJavaClass == null) {
            StringBundler sb = new StringBundler();
            for (String annotation : annotations) {
                sb.append("@");
                sb.append(annotation);
                sb.append(" or ");
            }
            sb.setIndex(sb.index() - 1);
            this.addMessage(fileName, StringBundler.concat("Annotation ", sb.toString(), " required for '", methodName, "'"), javaTerm.getLineNumber());
        }
    }
}

