/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import aQute.bnd.version.Version;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class BNDSchemaVersionCheck
extends BaseFileCheck {
    private static final Log _log = LogFactoryUtil.getLog(BNDSchemaVersionCheck.class);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException, ParseException {
        String schemaVersion = BNDSourceUtil.getDefinitionValue(content, "Liferay-Require-SchemaVersion");
        if (GetterUtil.getBoolean(BNDSourceUtil.getDefinitionValue(content, "Liferay-Service"))) {
            if (schemaVersion != null) {
                return this._fixSchemaVersion(absolutePath, content, schemaVersion);
            }
            int pos = absolutePath.lastIndexOf(47);
            File serviceXMLfile = new File(absolutePath.substring(0, pos + 1) + "service.xml");
            if (serviceXMLfile.exists()) {
                this.addMessage(fileName, "Missing 'Liferay-Require-SchemaVersion'");
            }
        } else if (schemaVersion != null) {
            this.addMessage(fileName, "The header 'Liferay-Require-SchemaVersion' can only be used when the header 'Liferay-Service' has value 'true'");
        }
        if (fileName.endsWith("-web/bnd.bnd") && Objects.equals(schemaVersion, "1.0.0")) {
            this.addMessage(fileName, "Do not include the header Liferay-Require-SchemaVersion in web modules");
        }
        return content;
    }

    private String _fixSchemaVersion(String absolutePath, String content, String schemaVersion) throws IOException, ParseException {
        int x = absolutePath.lastIndexOf(47);
        absolutePath.substring(0, x + 1);
        List<String> upgradeFileNames = SourceFormatterUtil.scanForFiles(absolutePath.substring(0, x + 1), new String[0], new String[]{"**/upgrade/*.java", "**/upgrade/**/*.java"}, new SourceFormatterExcludes(), false);
        String expectedSchemaVersion = this._getExpectedSchemaVersion(upgradeFileNames);
        if (expectedSchemaVersion == null || schemaVersion.equals(expectedSchemaVersion)) {
            return content;
        }
        return StringUtil.replace(content, "Liferay-Require-SchemaVersion: " + schemaVersion, "Liferay-Require-SchemaVersion: " + expectedSchemaVersion);
    }

    private String _getExpectedSchemaVersion(List<String> fileNames) throws IOException, ParseException {
        Version expectedSchemaVersion = null;
        for (String fileName : fileNames) {
            List<String> parameterList;
            File file;
            String content;
            JavaClass javaClass = JavaClassParser.parseJavaClass(fileName = StringUtil.replace(fileName, '\\', '/'), content = FileUtil.read(file = new File(fileName)));
            List<String> implementedClassNames = javaClass.getImplementedClassNames();
            if (!implementedClassNames.contains("UpgradeStepRegistrator")) continue;
            int x = -1;
            block3: while ((x = content.indexOf(".register(", x + 1)) != -1 && (parameterList = JavaSourceUtil.getParameterList(content.substring(x - 1))).size() >= 3) {
                for (int i = parameterList.size() - 2; i > 0; --i) {
                    Version schemaVersion = null;
                    try {
                        schemaVersion = new Version(StringUtil.removeChar(parameterList.get(i), '\"'));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!_log.isDebugEnabled()) continue;
                        _log.debug(illegalArgumentException, illegalArgumentException);
                        continue;
                    }
                    if (expectedSchemaVersion != null && expectedSchemaVersion.compareTo(schemaVersion) >= 0) continue block3;
                    expectedSchemaVersion = schemaVersion;
                    continue block3;
                }
            }
        }
        if (expectedSchemaVersion != null) {
            return expectedSchemaVersion.toString();
        }
        return null;
    }
}

