/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.script.PoshiScriptParserUtil;
import com.liferay.poshi.core.util.OSDetector;
import com.liferay.poshi.core.util.PropsUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class PoshiValidation {
    protected static final String[] UTIL_PACKAGE_NAMES = new String[]{"com.liferay.poshi.core.util", "com.liferay.poshi.runner.util"};
    private static final Set<Exception> _exceptions = new HashSet<Exception>();
    private static final Pattern _invalidMethodParameterPattern = Pattern.compile("(?<invalidSyntax>(?:locator|value)[1-3]?[\\s]*=)");
    private static final Pattern _pattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private static final Pattern _seleniumGetterMethodPattern = Pattern.compile("^selenium#(?<methodName>get[A-z]+)(?:\\((?<methodParameters>.*|)\\))?$");

    public static void clearExceptions() {
        _exceptions.clear();
    }

    public static Set<Exception> getExceptions() {
        return _exceptions;
    }

    public static void main(String[] args) throws Exception {
        PoshiContext.readFiles();
        PoshiValidation.validate();
    }

    public static void validate() throws Exception {
        System.out.println("Start poshi validation.");
        long start = System.currentTimeMillis();
        for (String filePath : PoshiContext.getFilePaths()) {
            Element element;
            if (OSDetector.isWindows()) {
                filePath = StringUtil.replace(filePath, "/", "\\");
            }
            String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
            String classType = PoshiGetterUtil.getClassTypeFromFilePath(filePath);
            String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
            if (classType.equals("function")) {
                element = PoshiContext.getFunctionRootElement(className, namespace);
                PoshiValidation.validateFunctionFile(element, filePath);
                continue;
            }
            if (classType.equals("macro")) {
                element = PoshiContext.getMacroRootElement(className, namespace);
                PoshiValidation.validateMacroFile(element, filePath);
                continue;
            }
            if (classType.equals("path")) {
                element = PoshiContext.getPathRootElement(className, namespace);
                PoshiValidation.validatePathFile(element, filePath);
                continue;
            }
            if (!classType.equals("test-case")) continue;
            element = PoshiContext.getTestCaseRootElement(className, namespace);
            PoshiValidation.validateTestCaseFile(element, filePath);
        }
        if (!_exceptions.isEmpty()) {
            PoshiValidation._throwExceptions();
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Completed poshi validation in " + duration + "ms.");
    }

    public static void validate(String testName) throws Exception {
        PoshiValidation.validateTestName(testName);
        PoshiValidation.validate();
    }

    protected static String getPrimaryAttributeName(Element element, List<String> multiplePrimaryAttributeNames, List<String> primaryAttributeNames, String filePath) {
        PoshiValidation.validateHasPrimaryAttributeName(element, multiplePrimaryAttributeNames, primaryAttributeNames, filePath);
        for (String primaryAttributeName : primaryAttributeNames) {
            if (!Validator.isNotNull(element.attributeValue(primaryAttributeName))) continue;
            return primaryAttributeName;
        }
        return null;
    }

    protected static String getPrimaryAttributeName(Element element, List<String> primaryAttributeNames, String filePath) {
        return PoshiValidation.getPrimaryAttributeName(element, null, primaryAttributeNames, filePath);
    }

    protected static void parseElements(Element element, String filePath) {
        List childElements = element.elements();
        List<String> possibleElementNames = Arrays.asList("description", "echo", "execute", "fail", "for", "if", "property", "return", "take-screenshot", "task", "var", "while");
        if (Validator.isNotNull(filePath) && filePath.endsWith(".function")) {
            possibleElementNames = Arrays.asList("execute", "if", "var");
        }
        for (Element childElement : childElements) {
            String elementName = childElement.getName();
            if (!possibleElementNames.contains(elementName)) {
                _exceptions.add(new ValidationException(childElement, "Invalid ", elementName, " element\n", filePath));
            }
            if (elementName.equals("description") || elementName.equals("echo") || elementName.equals("fail")) {
                PoshiValidation.validateMessageElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("execute")) {
                PoshiValidation.validateExecuteElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("for")) {
                PoshiValidation.validateForElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("if")) {
                PoshiValidation.validateIfElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("property")) {
                PoshiValidation.validatePropertyElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("return")) {
                PoshiValidation.validateCommandReturnElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("take-screenshot")) {
                PoshiValidation.validateTakeScreenshotElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("task")) {
                PoshiValidation.validateTaskElement(childElement, filePath);
                continue;
            }
            if (elementName.equals("var")) {
                PoshiValidation.validateVarElement(childElement, filePath);
                continue;
            }
            if (!elementName.equals("while")) continue;
            PoshiValidation.validateWhileElement(childElement, filePath);
        }
    }

    protected static void validateArgElement(Element element, String filePath) {
        List<String> attributes = Arrays.asList("line-number", "value");
        PoshiValidation.validatePossibleAttributeNames(element, attributes, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, attributes, filePath);
    }

    protected static void validateCommandElement(Element element, String filePath) {
        List<String> possibleAttributeNames = Arrays.asList("line-number", "name", "prose", "return", "summary", "summary-ignore");
        PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, Arrays.asList("name"), filePath);
        List<Element> returnElements = PoshiGetterUtil.getAllChildElements(element, "return");
        ArrayList<Element> commandReturnElements = new ArrayList<Element>();
        for (Element returnElement : returnElements) {
            Element parentElement = returnElement.getParent();
            if (Objects.equals(parentElement.getName(), "execute")) continue;
            commandReturnElements.add(returnElement);
        }
        String returnName = element.attributeValue("return");
        if (Validator.isNull(returnName)) {
            for (Element commandReturnElement : commandReturnElements) {
                String returnVariableName = commandReturnElement.attributeValue("name");
                String returnVariableValue = commandReturnElement.attributeValue("value");
                if (!Validator.isNotNull(returnVariableName) || !Validator.isNotNull(returnVariableValue)) continue;
                _exceptions.add(new ValidationException(commandReturnElement, "No return variables were stated in command ", "declaration, but found return name-value ", "mapping\n", filePath));
            }
        } else if (commandReturnElements.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Return variable was stated, but no returns were ", "found\n", filePath));
        } else {
            for (Element commandReturnElement : commandReturnElements) {
                String returnVariableName = commandReturnElement.attributeValue("name");
                if (Validator.isNull(returnVariableName)) {
                    _exceptions.add(new ValidationException(commandReturnElement, "Return variable was stated as '", returnName, "', but no 'name' attribute was found\n", filePath));
                    continue;
                }
                if (returnName.equals(returnVariableName)) continue;
                _exceptions.add(new ValidationException(commandReturnElement, "'", returnVariableName, "' not listed as a return variable\n"));
            }
        }
    }

    protected static void validateCommandReturnElement(Element element, String filePath) {
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, Arrays.asList("line-number", "name", "value"), filePath);
        PoshiValidation.validateRequiredAttributeNames(element, Arrays.asList("line-number", "value"), filePath);
    }

    protected static void validateConditionElement(Element element, String filePath) {
        String elementName = element.getName();
        if (elementName.equals("and") || elementName.equals("or")) {
            PoshiValidation.validateHasChildElements(element, filePath);
            PoshiValidation.validateHasNoAttributes(element, filePath);
            List childElements = element.elements();
            if (childElements.size() < 2) {
                _exceptions.add(new ValidationException(element, "Too few child elements\n", filePath));
            }
            for (Element childElement : childElements) {
                PoshiValidation.validateConditionElement(childElement, filePath);
            }
        } else if (elementName.equals("condition")) {
            List<String> possibleAttributeNames;
            List<String> primaryAttributeNames = Arrays.asList("function", "selenium");
            String primaryAttributeName = PoshiValidation.getPrimaryAttributeName(element, primaryAttributeNames, filePath);
            if (Validator.isNull(primaryAttributeName)) {
                return;
            }
            if (primaryAttributeName.equals("function")) {
                PoshiValidation.validateRequiredAttributeNames(element, Arrays.asList("locator1"), filePath);
                possibleAttributeNames = Arrays.asList("function", "line-number", "locator1", "value1");
                PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            } else if (primaryAttributeName.equals("selenium")) {
                possibleAttributeNames = Arrays.asList("argument1", "argument2", "line-number", "selenium");
                PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            }
            List varElements = element.elements("var");
            for (Element varElement : varElements) {
                PoshiValidation.validateVarElement(varElement, filePath);
            }
        } else if (elementName.equals("contains")) {
            List<String> attributeNames = Arrays.asList("line-number", "string", "substring");
            PoshiValidation.validateHasNoChildElements(element, filePath);
            PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
            PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
        } else if (elementName.equals("equals")) {
            List<String> attributeNames = Arrays.asList("arg1", "arg2", "line-number");
            PoshiValidation.validateHasNoChildElements(element, filePath);
            PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
            PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
        } else if (elementName.equals("isset")) {
            List<String> attributeNames = Arrays.asList("line-number", "var");
            PoshiValidation.validateHasNoChildElements(element, filePath);
            PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
            PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
        } else if (elementName.equals("not")) {
            PoshiValidation.validateHasChildElements(element, filePath);
            PoshiValidation.validateHasNoAttributes(element, filePath);
            PoshiValidation.validateNumberOfChildElements(element, 1, filePath);
            List childElements = element.elements();
            PoshiValidation.validateConditionElement((Element)childElements.get(0), filePath);
        }
    }

    protected static void validateDefinitionElement(Element element, String filePath) {
        String classType;
        String elementName = element.getName();
        if (!Objects.equals(elementName, "definition")) {
            _exceptions.add(new ValidationException(element, "Root element name must be definition\n", filePath));
        }
        if ((classType = PoshiGetterUtil.getClassTypeFromFilePath(filePath)).equals("function")) {
            List<String> possibleAttributeNames = Arrays.asList("default", "line-number", "override", "summary", "summary-ignore");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            PoshiValidation.validateRequiredAttributeNames(element, Arrays.asList("default"), filePath);
        } else if (classType.equals("macro")) {
            PoshiValidation.validateHasNoAttributes(element, filePath);
        } else if (classType.equals("testcase")) {
            List<String> possibleAttributeNames = Arrays.asList("extends", "ignore", "ignore-command-names", "line-number");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        }
    }

    protected static void validateElementName(Element element, List<String> possibleElementNames, String filePath) {
        if (!possibleElementNames.contains(element.getName())) {
            _exceptions.add(new ValidationException(element, "Missing ", possibleElementNames, " element\n", filePath));
        }
    }

    protected static void validateElseElement(Element element, String filePath) {
        List elseElements = element.elements("else");
        if (elseElements.size() > 1) {
            _exceptions.add(new ValidationException(element, "Too many else elements\n", filePath));
        }
        if (!elseElements.isEmpty()) {
            Element elseElement = (Element)elseElements.get(0);
            PoshiValidation.parseElements(elseElement, filePath);
        }
    }

    protected static void validateElseIfElement(Element element, String filePath) {
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateHasNoAttributes(element, filePath);
        PoshiValidation.validateNumberOfChildElements(element, 2, filePath);
        PoshiValidation.validateThenElement(element, filePath);
        List childElements = element.elements();
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        Element conditionElement = (Element)childElements.get(0);
        String conditionElementName = conditionElement.getName();
        if (conditionTags.contains(conditionElementName)) {
            PoshiValidation.validateConditionElement(conditionElement, filePath);
        } else {
            _exceptions.add(new ValidationException(element, "Invalid ", conditionElementName, " element\n", filePath));
        }
        Element thenElement = element.element("then");
        PoshiValidation.validateHasChildElements(thenElement, filePath);
        PoshiValidation.validateHasNoAttributes(thenElement, filePath);
        PoshiValidation.parseElements(thenElement, filePath);
    }

    protected static void validateExecuteElement(Element element, String filePath) {
        List<String> possibleAttributeNames;
        List<String> primaryAttributeNames = Arrays.asList("function", "macro", "method", "selenium", "test-case");
        if (filePath.endsWith(".function")) {
            primaryAttributeNames = Arrays.asList("function", "selenium");
        } else if (filePath.endsWith(".macro")) {
            primaryAttributeNames = Arrays.asList("function", "macro", "method");
        } else if (filePath.endsWith(".testcase")) {
            primaryAttributeNames = Arrays.asList("function", "macro", "method", "test-case");
        }
        String primaryAttributeName = PoshiValidation.getPrimaryAttributeName(element, primaryAttributeNames, filePath);
        if (primaryAttributeName == null) {
            return;
        }
        if (primaryAttributeName.equals("function")) {
            possibleAttributeNames = Arrays.asList("function", "line-number", "locator1", "locator2", "value1", "value2", "value3");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            PoshiValidation.validateFunctionContext(element, filePath);
        } else if (primaryAttributeName.equals("macro")) {
            possibleAttributeNames = Arrays.asList("line-number", "macro");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            PoshiValidation.validateMacroContext(element, "macro", filePath);
        } else if (primaryAttributeName.equals("method")) {
            PoshiValidation.validateMethodExecuteElement(element, filePath);
        } else if (primaryAttributeName.equals("selenium")) {
            possibleAttributeNames = Arrays.asList("argument1", "argument2", "argument3", "line-number", "selenium");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        } else if (primaryAttributeName.equals("test-case")) {
            possibleAttributeNames = Arrays.asList("line-number", "test-case");
            PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
            PoshiValidation.validateTestCaseContext(element, filePath);
        }
        List childElements = element.elements();
        if (!childElements.isEmpty()) {
            Element returnElement;
            primaryAttributeNames = Arrays.asList("function", "macro", "method", "selenium", "test-case");
            PoshiValidation.validateHasPrimaryAttributeName(element, primaryAttributeNames, filePath);
            List<String> possibleChildElementNames = Arrays.asList("arg", "prose", "return", "var");
            for (Object childElement : childElements) {
                String childElementName = childElement.getName();
                if (possibleChildElementNames.contains(childElementName)) continue;
                _exceptions.add(new ValidationException((Element)childElement, "Invalid child element\n", filePath));
            }
            List argElements = element.elements("arg");
            for (Element argElement : argElements) {
                PoshiValidation.validateArgElement(argElement, filePath);
            }
            List returnElements = element.elements("return");
            if (returnElements.size() > 1 && primaryAttributeName.equals("macro")) {
                _exceptions.add(new ValidationException(element, "Only 1 child element 'return' is allowed\n", filePath));
            }
            if ((returnElement = element.element("return")) != null) {
                if (primaryAttributeName.equals("macro")) {
                    PoshiValidation.validateExecuteReturnMacroElement(returnElement, filePath);
                } else if (primaryAttributeName.equals("method")) {
                    PoshiValidation.validateExecuteReturnMethodElement(returnElement, filePath);
                }
            }
            List varElements = element.elements("var");
            ArrayList<String> varNames = new ArrayList<String>();
            for (Element varElement : varElements) {
                PoshiValidation.validateVarElement(varElement, filePath);
                String varName = varElement.attributeValue("name");
                if (varNames.contains(varName)) {
                    _exceptions.add(new ValidationException(element, "Duplicate variable name: " + varName + "\n", filePath));
                }
                varNames.add(varName);
            }
        }
    }

    protected static void validateExecuteReturnMacroElement(Element element, String filePath) {
        List<String> attributeNames = Arrays.asList("line-number", "name");
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
    }

    protected static void validateExecuteReturnMethodElement(Element element, String filePath) {
        List<String> attributeNames = Arrays.asList("line-number", "name");
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
    }

    protected static void validateForElement(Element element, String filePath) {
        PoshiValidation.validateHasChildElements(element, filePath);
        List<String> possibleAttributeNames = Arrays.asList("line-number", "list", "param", "table");
        PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        List<String> requiredAttributeNames = Arrays.asList("line-number", "param");
        PoshiValidation.validateRequiredAttributeNames(element, requiredAttributeNames, filePath);
        PoshiValidation.parseElements(element, filePath);
    }

    protected static void validateFunctionContext(Element element, String filePath) {
        String function = element.attributeValue("function");
        PoshiValidation.validateNamespacedClassCommandName(element, function, "function", filePath);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(function);
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        int locatorCount = PoshiContext.getFunctionLocatorCount(className, namespace);
        for (int i = 0; i < locatorCount; ++i) {
            String locator = element.attributeValue("locator" + (i + 1));
            if (locator == null) continue;
            Matcher matcher = _pattern.matcher(locator);
            if (locator.startsWith("css=") || !locator.contains("#") || matcher.find()) continue;
            String pathName = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(locator);
            String defaultNamespace = PoshiContext.getDefaultNamespace();
            if (!PoshiContext.isRootElement("path", pathName, namespace) && !PoshiContext.isRootElement("path", pathName, defaultNamespace)) {
                _exceptions.add(new ValidationException(element, "Invalid path name ", pathName, "\n", filePath));
                continue;
            }
            if (PoshiContext.isPathLocator(locator, namespace) || PoshiContext.isPathLocator(locator, defaultNamespace)) continue;
            _exceptions.add(new ValidationException(element, "Invalid path locator ", locator, "\n", filePath));
        }
    }

    protected static void validateFunctionFile(Element element, String filePath) {
        PoshiValidation.validateDefinitionElement(element, filePath);
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateRequiredChildElementNames(element, Arrays.asList("command"), filePath);
        List childElements = element.elements();
        for (Element childElement : childElements) {
            PoshiValidation.validateCommandElement(childElement, filePath);
            PoshiValidation.validateHasChildElements(childElement, filePath);
            PoshiValidation.parseElements(childElement, filePath);
        }
    }

    protected static void validateHasChildElements(Element element, String filePath) {
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Missing child elements\n", filePath));
        }
    }

    protected static void validateHasMultiplePrimaryAttributeNames(Element element, List<String> attributeNames, List<String> multiplePrimaryAttributeNames, String filePath) {
        if (!multiplePrimaryAttributeNames.equals(attributeNames)) {
            _exceptions.add(new ValidationException(element, "Too many attributes\n", filePath));
        }
    }

    protected static void validateHasNoAttributes(Element element, String filePath) {
        List attributes = element.attributes();
        if (!attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                String attributeName = attribute.getName();
                if (attributeName.equals("line-number")) continue;
                _exceptions.add(new ValidationException(element, "Invalid ", attributeName, " attribute\n", filePath));
            }
        }
    }

    protected static void validateHasNoChildElements(Element element, String filePath) {
        List childElements = element.elements();
        if (!childElements.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Invalid child elements\n", filePath));
        }
    }

    protected static void validateHasPrimaryAttributeName(Element element, List<String> multiplePrimaryAttributeNames, List<String> primaryAttributeNames, String filePath) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (String primaryAttributeName : primaryAttributeNames) {
            if (!Validator.isNotNull(element.attributeValue(primaryAttributeName))) continue;
            attributeNames.add(primaryAttributeName);
        }
        if (attributeNames.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Invalid or missing attribute\n", filePath));
        } else if (attributeNames.size() > 1) {
            if (multiplePrimaryAttributeNames == null) {
                _exceptions.add(new ValidationException(element, "Too many attributes\n", filePath));
            } else {
                PoshiValidation.validateHasMultiplePrimaryAttributeNames(element, attributeNames, multiplePrimaryAttributeNames, filePath);
            }
        }
    }

    protected static void validateHasPrimaryAttributeName(Element element, List<String> primaryAttributeNames, String filePath) {
        PoshiValidation.validateHasPrimaryAttributeName(element, null, primaryAttributeNames, filePath);
    }

    protected static void validateHasRequiredPropertyElements(Element element, String filePath) {
        ArrayList<String> requiredPropertyNames = new ArrayList<String>(PoshiContext.getRequiredPoshiPropertyNames());
        List propertyElements = element.elements("property");
        for (Element propertyElement : propertyElements) {
            PoshiValidation.validatePropertyElement(propertyElement, filePath);
            String propertyName = propertyElement.attributeValue("name");
            if (!requiredPropertyNames.contains(propertyName)) continue;
            requiredPropertyNames.remove(propertyName);
        }
        if (requiredPropertyNames.isEmpty()) {
            return;
        }
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
        String commandName = element.attributeValue("name");
        String namespacedClassCommandName = namespace + "." + className + "#" + commandName;
        Properties properties = PoshiContext.getNamespacedClassCommandNameProperties(namespacedClassCommandName);
        for (String requiredPropertyName : requiredPropertyNames) {
            if (properties.containsKey(requiredPropertyName)) continue;
            _exceptions.add(new ValidationException(className + "#" + commandName + " is missing required properties ", ((Object)requiredPropertyNames).toString(), "\n", filePath));
        }
    }

    protected static void validateIfElement(Element element, String filePath) {
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateHasNoAttributes(element, filePath);
        String fileName = filePath.substring(filePath.lastIndexOf(".") + 1);
        List childElements = element.elements();
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        if (fileName.equals("function")) {
            conditionTags = Arrays.asList("and", "condition", "contains", "not", "or");
        }
        PoshiValidation.validateElseElement(element, filePath);
        PoshiValidation.validateThenElement(element, filePath);
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = (Element)childElements.get(i);
            String childElementName = childElement.getName();
            if (i == 0) {
                if (conditionTags.contains(childElementName)) {
                    PoshiValidation.validateConditionElement(childElement, filePath);
                    continue;
                }
                _exceptions.add(new ValidationException(element, "Missing or invalid if condition element\n", filePath));
                continue;
            }
            if (childElementName.equals("else")) {
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasNoAttributes(childElement, filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            if (childElementName.equals("elseif")) {
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasNoAttributes(childElement, filePath);
                PoshiValidation.validateElseIfElement(childElement, filePath);
                continue;
            }
            if (childElementName.equals("then")) {
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasNoAttributes(childElement, filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            _exceptions.add(new ValidationException(childElement, "Invalid ", childElementName, " element\n", filePath));
        }
    }

    protected static void validateMacroCommandName(Element element, String filePath) {
        String attributeName = element.attributeValue("name");
        if (attributeName.contains("Url")) {
            _exceptions.add(new ValidationException(element, "Invalid macro command name: ", attributeName, ". Use 'URL' instead of 'Url'.\n", filePath));
        }
    }

    protected static void validateMacroContext(Element element, String macroType, String filePath) {
        PoshiValidation.validateNamespacedClassCommandName(element, element.attributeValue(macroType), "macro", filePath);
    }

    protected static void validateMacroFile(Element element, String filePath) {
        PoshiValidation.validateDefinitionElement(element, filePath);
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateRequiredChildElementName(element, "command", filePath);
        List childElements = element.elements();
        List<String> possibleTagElementNames = Arrays.asList("command", "var");
        for (Element childElement : childElements) {
            String childElementName = childElement.getName();
            if (!possibleTagElementNames.contains(childElementName)) {
                _exceptions.add(new ValidationException(childElement, "Invalid ", childElementName, " element\n", filePath));
            }
            if (childElementName.equals("command")) {
                PoshiValidation.validateCommandElement(childElement, filePath);
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateMacroCommandName(childElement, filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            if (!childElementName.equals("var")) continue;
            PoshiValidation.validateVarElement(childElement, filePath);
        }
    }

    protected static void validateMessageElement(Element element, String filePath) {
        List<String> possibleAttributeNames = Arrays.asList("line-number", "message");
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        if (element.attributeValue("message") == null && Validator.isNull(element.getText())) {
            _exceptions.add(new ValidationException(element, "Missing message attribute\n", filePath));
        }
    }

    protected static void validateMethodExecuteElement(Element element, String filePath) {
        String className = element.attributeValue("class");
        Class<?> clazz = null;
        String fullClassName = null;
        if (className.matches("[\\w]*")) {
            for (String packageName : UTIL_PACKAGE_NAMES) {
                try {
                    clazz = Class.forName(packageName + "." + className);
                    fullClassName = packageName + "." + className;
                    break;
                }
                catch (Exception exception) {
                }
            }
        } else {
            try {
                clazz = Class.forName(className);
                fullClassName = className;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fullClassName == null) {
            _exceptions.add(new ValidationException(element, "Unable to find class ", className, "\n", filePath));
            return;
        }
        try {
            PoshiValidation.validateUtilityClassName(element, filePath, fullClassName);
        }
        catch (Exception exception) {
            _exceptions.add(exception);
            return;
        }
        String methodName = element.attributeValue("method");
        ArrayList<Method> possibleMethods = new ArrayList<Method>();
        List<Method> completeMethods = Arrays.asList(clazz.getMethods());
        for (Method possibleMethod : completeMethods) {
            String possibleMethodName = possibleMethod.getName();
            if (!methodName.equals(possibleMethodName)) continue;
            possibleMethods.add(possibleMethod);
        }
        if (possibleMethods.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Unable to find method ", fullClassName, "#", methodName, "\n", filePath));
        }
    }

    protected static void validateNamespacedClassCommandName(Element element, String namespacedClassCommandName, String classType, String filePath) {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String defaultNamespace = PoshiContext.getDefaultNamespace();
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (namespace.equals(defaultNamespace)) {
            namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        }
        if (!PoshiContext.isRootElement(classType, className, namespace) && !PoshiContext.isRootElement(classType, className, defaultNamespace)) {
            _exceptions.add(new ValidationException(element, "Invalid ", classType, " class ", className, "\n", filePath));
        }
        if (!PoshiContext.isCommandElement(classType, classCommandName, namespace) && !PoshiContext.isCommandElement(classType, classCommandName, defaultNamespace)) {
            _exceptions.add(new ValidationException(element, "Invalid ", classType, " command ", namespacedClassCommandName, "\n", filePath));
        }
    }

    protected static void validateNumberOfChildElements(Element element, int number, String filePath) {
        List childElements = element.elements();
        if (childElements.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Missing child elements\n", filePath));
        } else if (childElements.size() > number) {
            _exceptions.add(new ValidationException(element, "Too many child elements\n", filePath));
        } else if (childElements.size() < number) {
            _exceptions.add(new ValidationException(element, "Too few child elements\n", filePath));
        }
    }

    protected static void validateOffElement(Element element, String filePath) {
        List offElements = element.elements("off");
        if (offElements.size() > 1) {
            _exceptions.add(new ValidationException(element, "Too many off elements\n", filePath));
        }
        if (!offElements.isEmpty()) {
            Element offElement = (Element)offElements.get(0);
            PoshiValidation.validateHasChildElements(offElement, filePath);
            PoshiValidation.validateHasNoAttributes(offElement, filePath);
            PoshiValidation.parseElements(offElement, filePath);
        }
    }

    protected static void validateOnElement(Element element, String filePath) {
        List onElements = element.elements("on");
        if (onElements.size() > 1) {
            _exceptions.add(new ValidationException(element, "Too many on elements\n", filePath));
        }
        if (!onElements.isEmpty()) {
            Element onElement = (Element)onElements.get(0);
            PoshiValidation.validateHasChildElements(onElement, filePath);
            PoshiValidation.validateHasNoAttributes(onElement, filePath);
            PoshiValidation.parseElements(onElement, filePath);
        }
    }

    protected static void validatePathFile(Element element, String filePath) {
        Element trElement2;
        String className = PoshiGetterUtil.getClassNameFromFilePath(filePath);
        String rootElementName = element.getName();
        if (!Objects.equals(rootElementName, "html")) {
            _exceptions.add(new ValidationException(element, "Invalid ", rootElementName, " element\n", filePath));
        }
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validateNumberOfChildElements(element, 2, filePath);
        PoshiValidation.validateRequiredChildElementNames(element, Arrays.asList("body", "head"), filePath);
        Element bodyElement = element.element("body");
        PoshiValidation.validateHasChildElements(bodyElement, filePath);
        PoshiValidation.validateNumberOfChildElements(bodyElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(bodyElement, "table", filePath);
        Element tableElement = bodyElement.element("table");
        List<String> requiredTableAttributeNames = Arrays.asList("border", "cellpadding", "cellspacing", "line-number");
        PoshiValidation.validateHasChildElements(tableElement, filePath);
        PoshiValidation.validateNumberOfChildElements(tableElement, 2, filePath);
        PoshiValidation.validateRequiredAttributeNames(tableElement, requiredTableAttributeNames, filePath);
        PoshiValidation.validateRequiredChildElementNames(tableElement, Arrays.asList("tbody", "thead"), filePath);
        Element tBodyElement = tableElement.element("tbody");
        List trElements = tBodyElement.elements();
        if (trElements != null) {
            for (Element trElement2 : trElements) {
                String namespace;
                Element pathRootElement;
                PoshiValidation.validateHasChildElements(trElement2, filePath);
                PoshiValidation.validateNumberOfChildElements(trElement2, 3, filePath);
                PoshiValidation.validateRequiredChildElementName(trElement2, "td", filePath);
                List tdElements = trElement2.elements();
                Element locatorElement = (Element)tdElements.get(1);
                String locator = locatorElement.getText();
                Element locatorKeyElement = (Element)tdElements.get(0);
                String locatorKey = locatorKeyElement.getText();
                if (Validator.isNull(locator) != Validator.isNull(locatorKey)) {
                    _exceptions.add(new ValidationException(trElement2, "Missing locator\n", filePath));
                }
                if (!locatorKey.equals("EXTEND_ACTION_PATH") || (pathRootElement = PoshiContext.getPathRootElement(locator, namespace = PoshiContext.getNamespaceFromFilePath(filePath))) != null) continue;
                _exceptions.add(new ValidationException(trElement2, "Nonexistent parent path file\n", filePath));
            }
        }
        Element theadElement = tableElement.element("thead");
        PoshiValidation.validateHasChildElements(theadElement, filePath);
        PoshiValidation.validateNumberOfChildElements(theadElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(theadElement, "tr", filePath);
        trElement2 = theadElement.element("tr");
        PoshiValidation.validateHasChildElements(trElement2, filePath);
        PoshiValidation.validateNumberOfChildElements(trElement2, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(trElement2, "td", filePath);
        Element tdElement = trElement2.element("td");
        PoshiValidation.validateRequiredAttributeNames(tdElement, Arrays.asList("colspan", "rowspan"), filePath);
        String theadClassName = tdElement.getText();
        if (Validator.isNull(theadClassName)) {
            _exceptions.add(new ValidationException(trElement2, "Missing thead class name\n", filePath));
        } else if (!Objects.equals(theadClassName, className)) {
            _exceptions.add(new ValidationException(trElement2, "Thead class name does not match file name\n", filePath));
        }
        Element headElement = element.element("head");
        PoshiValidation.validateHasChildElements(headElement, filePath);
        PoshiValidation.validateNumberOfChildElements(headElement, 1, filePath);
        PoshiValidation.validateRequiredChildElementName(headElement, "title", filePath);
        Element titleElement = headElement.element("title");
        if (!Objects.equals(titleElement.getText(), className)) {
            _exceptions.add(new ValidationException(titleElement, "File name and title are different\n", filePath));
        }
    }

    protected static void validatePossibleAttributeNames(Element element, List<String> possibleAttributeNames, String filePath) {
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (possibleAttributeNames.contains(attributeName)) continue;
            _exceptions.add(new ValidationException(element, "Invalid ", attributeName, " attribute\n", filePath));
        }
    }

    protected static void validatePossiblePropertyValues(Element propertyElement, String filePath) {
        String propertyName = propertyElement.attributeValue("name");
        String testCaseAvailablePropertyValues = PropsUtil.get("test.case.available.property.values[" + propertyName + "]");
        if (Validator.isNotNull(testCaseAvailablePropertyValues)) {
            List<String> possiblePropertyValues = Arrays.asList(StringUtil.split(testCaseAvailablePropertyValues));
            List<String> propertyValues = Arrays.asList(StringUtil.split(propertyElement.attributeValue("value")));
            for (String propertyValue : propertyValues) {
                if (possiblePropertyValues.contains(propertyValue.trim())) continue;
                _exceptions.add(new ValidationException(propertyElement, "Invalid property value '", propertyValue.trim(), "' for property name '", propertyName.trim(), "'\n", filePath));
            }
        }
    }

    protected static void validatePropertyElement(Element element, String filePath) {
        List<String> attributeNames = Arrays.asList("line-number", "name", "value");
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, attributeNames, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, attributeNames, filePath);
        PoshiValidation.validatePossiblePropertyValues(element, filePath);
    }

    protected static void validateRequiredAttributeNames(Element element, List<String> requiredAttributeNames, String filePath) {
        for (String requiredAttributeName : requiredAttributeNames) {
            if (requiredAttributeName.equals("line-number") && element instanceof PoshiElement || element.attributeValue(requiredAttributeName) != null) continue;
            _exceptions.add(new ValidationException(element, "Missing ", requiredAttributeName, " attribute\n", filePath));
        }
    }

    protected static void validateRequiredChildElementName(Element element, String requiredElementName, String filePath) {
        boolean found = false;
        List childElements = element.elements();
        for (Element childElement : childElements) {
            if (!Objects.equals(childElement.getName(), requiredElementName)) continue;
            found = true;
            break;
        }
        if (!found) {
            _exceptions.add(new ValidationException(element, "Missing required ", requiredElementName, " child element\n", filePath));
        }
    }

    protected static void validateRequiredChildElementNames(Element element, List<String> requiredElementNames, String filePath) {
        for (String requiredElementName : requiredElementNames) {
            PoshiValidation.validateRequiredChildElementName(element, requiredElementName, filePath);
        }
    }

    protected static void validateSeleniumMethodAttributeValue(Element element, String methodAttributeValue, String filePath) {
        Matcher seleniumGetterMethodMatcher = _seleniumGetterMethodPattern.matcher(methodAttributeValue);
        seleniumGetterMethodMatcher.find();
        String seleniumMethodName = seleniumGetterMethodMatcher.group("methodName");
        if (seleniumMethodName.equals("getCurrentUrl")) {
            return;
        }
        int seleniumParameterCount = PoshiContext.getSeleniumParameterCount(seleniumMethodName);
        List<String> methodParameterValues = PoshiScriptParserUtil.getMethodParameterValues(seleniumGetterMethodMatcher.group("methodParameters"));
        if (methodParameterValues.size() != seleniumParameterCount) {
            _exceptions.add(new ValidationException(element, "Expected ", seleniumParameterCount, " parameter(s) for method \"", seleniumMethodName, "\" but found ", seleniumParameterCount, "\n", filePath));
        }
        for (String methodParameterValue : methodParameterValues) {
            Matcher invalidMethodParameterMatcher = _invalidMethodParameterPattern.matcher(methodParameterValue);
            if (!invalidMethodParameterMatcher.find()) continue;
            String invalidSyntax = invalidMethodParameterMatcher.group("invalidSyntax");
            _exceptions.add(new ValidationException(element, "Invalid parameter syntax \"", invalidSyntax, "\"\n", filePath));
        }
    }

    protected static void validateTakeScreenshotElement(Element element, String filePath) {
        PoshiValidation.validateHasNoAttributes(element, filePath);
        PoshiValidation.validateHasNoChildElements(element, filePath);
    }

    protected static void validateTaskElement(Element element, String filePath) {
        List<String> possibleAttributeNames = Arrays.asList("line-number", "macro-summary", "summary");
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        List<String> primaryAttributeNames = Arrays.asList("macro-summary", "summary");
        PoshiValidation.validateHasPrimaryAttributeName(element, primaryAttributeNames, filePath);
        PoshiValidation.parseElements(element, filePath);
    }

    protected static void validateTestCaseContext(Element element, String filePath) {
        String namespace = PoshiContext.getNamespaceFromFilePath(filePath);
        String testName = element.attributeValue("test-case");
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(testName);
        if (className.equals("super")) {
            className = PoshiGetterUtil.getExtendedTestCaseName(filePath);
        }
        String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(testName);
        PoshiValidation.validateTestName(namespace + "." + className + "#" + commandName, filePath + ":" + PoshiGetterUtil.getLineNumber(element));
    }

    protected static void validateTestCaseFile(Element element, String filePath) {
        PoshiValidation.validateDefinitionElement(element, filePath);
        List childElements = element.elements();
        if (Validator.isNull(element.attributeValue("extends"))) {
            PoshiValidation.validateHasChildElements(element, filePath);
            PoshiValidation.validateRequiredChildElementName(element, "command", filePath);
        }
        List<String> possibleTagElementNames = Arrays.asList("command", "property", "set-up", "tear-down", "var");
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Element childElement : childElements) {
            String childElementName = childElement.getName();
            if (!possibleTagElementNames.contains(childElementName)) {
                _exceptions.add(new ValidationException(childElement, "Invalid ", childElementName, " element\n", filePath));
            }
            if (childElementName.equals("command")) {
                List<String> possibleAttributeNames = Arrays.asList("annotations", "description", "ignore", "known-issues", "line-number", "name", "priority");
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasRequiredPropertyElements(childElement, filePath);
                PoshiValidation.validatePossibleAttributeNames(childElement, possibleAttributeNames, filePath);
                PoshiValidation.validateRequiredAttributeNames(childElement, Arrays.asList("name"), filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            if (childElementName.equals("property")) {
                PoshiValidation.validatePropertyElement(childElement, filePath);
                String propertyName = childElement.attributeValue("name");
                if (!propertyNames.contains(propertyName)) {
                    propertyNames.add(propertyName);
                    continue;
                }
                _exceptions.add(new ValidationException(childElement, "Duplicate property name ", propertyName, "\n", filePath));
                continue;
            }
            if (childElementName.equals("set-up") || childElementName.equals("tear-down")) {
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasNoAttributes(childElement, filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            if (!childElementName.equals("var")) continue;
            PoshiValidation.validateVarElement(childElement, filePath);
        }
    }

    protected static void validateTestName(String testName) {
        PoshiValidation.validateTestName(testName, "");
    }

    protected static void validateTestName(String testName, String filePathLineNumber) {
        String classCommandName;
        String namespace;
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(testName);
        if (!PoshiContext.isRootElement("test-case", className, namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(testName))) {
            _exceptions.add(new ValidationException(new String[]{"Invalid test case class " + namespace + "." + className + "\n" + filePathLineNumber}));
        } else if (testName.contains("#") && !PoshiContext.isCommandElement("test-case", classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(testName), namespace)) {
            String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(testName);
            _exceptions.add(new ValidationException(new String[]{"Invalid test case command " + commandName + "\n" + filePathLineNumber}));
        }
    }

    protected static void validateThenElement(Element element, String filePath) {
        List thenElements = element.elements("then");
        if (thenElements.isEmpty()) {
            _exceptions.add(new ValidationException(element, "Missing then element\n", filePath));
        } else if (thenElements.size() > 1) {
            _exceptions.add(new ValidationException(element, "Too many then elements\n", filePath));
        }
    }

    protected static void validateUtilityClassName(Element element, String filePath, String className) throws Exception {
        if (!className.startsWith("selenium")) {
            if (!className.contains(".")) {
                try {
                    className = PoshiGetterUtil.getUtilityClassName(className);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ValidationException(element, illegalArgumentException.getMessage(), "\n", filePath);
                }
            }
            if (!PoshiGetterUtil.isValidUtilityClass(className)) {
                throw new ValidationException(element, className, " is an invalid utility class\n", filePath);
            }
        }
    }

    protected static void validateVarElement(Element element, String filePath) {
        Element parentElement;
        PoshiValidation.validateHasNoChildElements(element, filePath);
        PoshiValidation.validateRequiredAttributeNames(element, Arrays.asList("name"), filePath);
        List attributes = element.attributes();
        int minimumAttributeSize = 2;
        if (element instanceof PoshiElement) {
            minimumAttributeSize = 1;
        }
        if (attributes.size() <= minimumAttributeSize && Validator.isNull(element.getText())) {
            _exceptions.add(new ValidationException(element, "Missing value attribute\n", filePath));
        }
        ArrayList<String> possibleAttributeNames = new ArrayList<String>();
        Collections.addAll(possibleAttributeNames, "from", "hash", "index", "line-number", "method", "name", "type", "value");
        if (filePath.contains(".macro")) {
            possibleAttributeNames.add("static");
        }
        if ((parentElement = element.getParent()) != null) {
            String parentElementName = parentElement.getName();
            if (filePath.contains(".testcase") && parentElementName.equals("definition")) {
                possibleAttributeNames.add("static");
            }
        }
        PoshiValidation.validatePossibleAttributeNames(element, possibleAttributeNames, filePath);
        if (Validator.isNotNull(element.attributeValue("method"))) {
            int x;
            String methodAttributeValue = element.attributeValue("method");
            String className = methodAttributeValue.substring(0, x = methodAttributeValue.indexOf("#"));
            if (className.equals("selenium")) {
                PoshiValidation.validateSeleniumMethodAttributeValue(element, methodAttributeValue, filePath);
            }
            try {
                PoshiValidation.validateUtilityClassName(element, filePath, className);
            }
            catch (Exception exception) {
                _exceptions.add(exception);
            }
            int expectedAttributeCount = 1;
            if (element instanceof PoshiElement) {
                expectedAttributeCount = 0;
            }
            if (Validator.isNotNull(element.attributeValue("name"))) {
                ++expectedAttributeCount;
            }
            if (PoshiGetterUtil.getLineNumber(element) != -1) {
                ++expectedAttributeCount;
            }
            if (Validator.isNotNull(element.attributeValue("static"))) {
                ++expectedAttributeCount;
            }
            if (attributes.size() < expectedAttributeCount) {
                _exceptions.add(new ValidationException(element, "Too few attributes\n", filePath));
            }
            if (attributes.size() > expectedAttributeCount) {
                _exceptions.add(new ValidationException(element, "Too many attributes\n", filePath));
            }
        }
    }

    protected static void validateWhileElement(Element element, String filePath) {
        PoshiValidation.validateHasChildElements(element, filePath);
        PoshiValidation.validatePossibleAttributeNames(element, Arrays.asList("line-number", "max-iterations"), filePath);
        PoshiValidation.validateThenElement(element, filePath);
        List<String> conditionTags = Arrays.asList("and", "condition", "contains", "equals", "isset", "not", "or");
        List childElements = element.elements();
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = (Element)childElements.get(i);
            String childElementName = childElement.getName();
            if (i == 0) {
                if (conditionTags.contains(childElementName)) {
                    PoshiValidation.validateConditionElement(childElement, filePath);
                    continue;
                }
                _exceptions.add(new ValidationException(element, "Missing while condition element\n", filePath));
                continue;
            }
            if (childElementName.equals("then")) {
                PoshiValidation.validateHasChildElements(childElement, filePath);
                PoshiValidation.validateHasNoAttributes(childElement, filePath);
                PoshiValidation.parseElements(childElement, filePath);
                continue;
            }
            _exceptions.add(new ValidationException(childElement, "Invalid ", childElementName, " element\n", filePath));
        }
    }

    private static void _throwExceptions() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n");
        sb.append(_exceptions.size());
        sb.append(" errors in POSHI\n\n");
        for (Exception exception : _exceptions) {
            sb.append(exception.getMessage());
            sb.append("\n\n");
        }
        System.out.println(sb.toString());
        throw new Exception();
    }

    private static class ValidationException
    extends Exception {
        public ValidationException(Element element, Object ... messageParts) {
            super(ValidationException._join(ValidationException._join(messageParts), ":", PoshiGetterUtil.getLineNumber(element)));
        }

        public ValidationException(String ... messageParts) {
            super(ValidationException._join(messageParts));
        }

        private static String _join(Object ... objects) {
            StringBuilder sb = new StringBuilder();
            for (Object object : objects) {
                sb.append(object.toString());
            }
            return sb.toString();
        }
    }
}

