/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaUpgradeAlterCheck
extends BaseFileCheck {
    private static final String[] _STRING_TYPES = new String[]{"STRING", "TEXT", "VARCHAR"};
    private static final String[] _VALID_TYPES = new String[]{"BLOB", "SBLOB", "BOOLEAN", "DATE", "DOUBLE", "INTEGER", "LONG", "STRING", "TEXT", "VARCHAR"};
    private static final Pattern _alterColumnTypePattern = Pattern.compile("AlterColumnType\\(\\s*\"(\\w+)\",\\s*\"((\\w+).*)\"\\)");
    private static final Pattern _alterObjectPattern = Pattern.compile("new (Alter\\w+)\\(");
    private static final Pattern _alterPattern = Pattern.compile("alter\\(\\s*");
    private static final Pattern _alterTableClassPattern = Pattern.compile("(\\w+)Table\\.class");
    private static final Pattern _stringPattern = Pattern.compile("\"(\\w+)\"");
    private final Map<String, Set<String>> _columnNamesByTables = new HashMap<String, Set<String>>();

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!absolutePath.contains("/upgrade/") || !content.contains("alter(")) {
            return content;
        }
        this._columnNamesByTables.clear();
        Matcher matcher1 = _alterPattern.matcher(content);
        while (matcher1.find()) {
            List<String> parameterList = JavaSourceUtil.getParameterList(this._getMethodCall(content, matcher1.start()));
            String tableName = null;
            Matcher matcher2 = _alterTableClassPattern.matcher(parameterList.get(0));
            if (matcher2.find() && !this._columnNamesByTables.containsKey(tableName = matcher2.group(1))) {
                this._readColumnNamesFromTableClass(tableName, absolutePath);
            }
            this._checkAlterObjects(tableName, fileName, content, parameterList.subList(1, parameterList.size()));
        }
        return content;
    }

    private void _checkAlterColumnType(int start, String tableName, String fileName, String content, String alterObject) {
        String dataType;
        String message;
        Set<String> columnNames;
        Matcher matcher = _alterColumnTypePattern.matcher(alterObject);
        if (!matcher.find()) {
            return;
        }
        String columnName = matcher.group(1);
        if (tableName != null && this._columnNamesByTables.containsKey(tableName) && !(columnNames = this._columnNamesByTables.get(tableName)).contains(columnName)) {
            message = String.format("The column \"%s\" does not exist in table \"%s\"", columnName, tableName);
            this.addMessage(fileName, message, this.getLineNumber(content, start + matcher.start(1)));
        }
        if (!ArrayUtil.contains(_VALID_TYPES, dataType = matcher.group(3))) {
            message = String.format("Only the following data types are valid: %s", Arrays.toString(_VALID_TYPES));
            this.addMessage(fileName, message, this.getLineNumber(content, start + matcher.start(3)));
            return;
        }
        if (!ArrayUtil.contains(_STRING_TYPES, dataType)) {
            return;
        }
        String newType = matcher.group(2);
        if (!newType.contains("null") && !newType.contains("not null")) {
            String message2 = String.format("Specify whether the new type for \"%s\" is nullable", columnName);
            this.addMessage(fileName, message2, this.getLineNumber(content, start + matcher.start(2)));
        }
    }

    private void _checkAlterObjects(String tableName, String fileName, String content, List<String> alterObjects) {
        for (String alterObject : alterObjects) {
            Matcher matcher = _alterObjectPattern.matcher(alterObject);
            while (matcher.find()) {
                String alterType = matcher.group(1);
                int pos = content.indexOf(alterObject, matcher.start());
                if (!Objects.equals(alterType, "AlterColumnType")) continue;
                this._checkAlterColumnType(pos, tableName, fileName, content, alterObject);
            }
        }
    }

    private String _getMethodCall(String content, int start) {
        String methodCall;
        int x = start;
        while (ToolsUtil.isInsideQuotes(content, (x = content.indexOf(")", x + 1)) + 1) || this.getLevel(methodCall = content.substring(start, x + 1)) != 0) {
        }
        return methodCall;
    }

    private void _readColumnNamesFromTableClass(String tableName, String absolutePath) throws Exception {
        int x = absolutePath.lastIndexOf("/");
        if (x == -1) {
            return;
        }
        String fileName = StringBundler.concat(absolutePath.substring(0, x), "/util/", tableName, "Table.java");
        if (!FileUtil.exists(fileName)) {
            return;
        }
        String fileContent = FileUtil.read(new File(fileName));
        if (!fileContent.contains("@generated")) {
            return;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, fileContent);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!javaTerm.isJavaVariable() || !Objects.equals(javaTerm.getName(), "TABLE_COLUMNS")) continue;
            HashSet<String> columnNames = new HashSet<String>();
            Matcher matcher = _stringPattern.matcher(javaTerm.getContent());
            while (matcher.find()) {
                columnNames.add(matcher.group(1));
            }
            this._columnNamesByTables.put(tableName, columnNames);
            break;
        }
    }
}

