/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;

public class JavaModuleComponentCheck
extends BaseJavaTermCheck {
    private static final String _ALLOWED_CLASS_NAMES_KEY = "allowedClassNames";

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        block5: {
            block4: {
                if (javaTerm.getParentJavaClass() != null) {
                    return javaTerm.getContent();
                }
                String packageName = JavaSourceUtil.getPackageName(fileContent);
                List<String> allowedClassNames = this.getAttributeValues(_ALLOWED_CLASS_NAMES_KEY, absolutePath);
                if (allowedClassNames.contains(packageName + "." + javaTerm.getName())) {
                    return javaTerm.getContent();
                }
                if (!javaTerm.hasAnnotation("Component")) break block4;
                if (!absolutePath.contains("-api/") && !absolutePath.contains("-spi/")) break block5;
                this.addMessage(fileName, "Do not use @Component in '-api' or '-spi' module");
                break block5;
            }
            if (!javaTerm.isAbstract()) {
                JavaClass javaClass = (JavaClass)javaTerm;
                for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
                    if (!childJavaTerm.hasAnnotation("Reference")) continue;
                    this.addMessage(fileName, "@Reference should not be used in a class without @Component");
                    break;
                }
            }
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }
}

