/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checks.util.XMLSourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.pom", "**/*.project", "**/*.properties", "**/*.svg", "**/*.testcase", "**/*.toggle", "**/*.wsdl", "**/*.xml", "**/definitions/liferay-*.xsd", "**/*.xml.tpl"};

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[]{"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**", "**/javadocs-*.xml", "**/logs/**", "**/modules/**/.project", "**/portal-impl/**/*.action", "**/portal-impl/**/*.function", "**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase", "**/src/test/**", "**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**", "**/tools/node**"}, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        if ((fileName.endsWith(".function") || fileName.endsWith(".macro") || fileName.endsWith(".project") || fileName.endsWith(".properties") || fileName.endsWith(".testcase")) && !SourceUtil.isXML(content)) {
            return file;
        }
        return super.format(file, fileName, absolutePath, content);
    }

    @Override
    protected boolean hasGeneratedTag(String content) {
        return this._hasGeneratedTag(content, "@generated", "<!-- Generated");
    }

    private boolean _hasGeneratedTag(String content, String ... tags) {
        for (String tag : tags) {
            if (!content.contains(tag)) continue;
            int pos = -1;
            while ((pos = content.indexOf(tag, pos + 1)) != -1) {
                if (XMLSourceUtil.isInsideCDATAMarkup(content, pos)) continue;
                return true;
            }
        }
        return false;
    }
}

