/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class JSONStylingCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (Validator.isNull(content)) {
            return "";
        }
        try {
            if (StringUtil.startsWith(StringUtil.trim(content), "[")) {
                return JSONUtil.toString(new JSONArrayImpl(content));
            }
            if (content.endsWith("\n") && fileName.endsWith("/package.json")) {
                return JSONUtil.toString(new JSONObjectImpl(content)) + "\n";
            }
            return JSONUtil.toString(new JSONObjectImpl(content));
        }
        catch (JSONException jsonException) {
            return content;
        }
    }
}

