/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseAPICheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeprecatedAPICheck
extends BaseAPICheck {
    private static final String _MSG_DEPRECATED_CONSTRUCTOR_CALL = "constructor.call.deprecated";
    private static final String _MSG_DEPRECATED_FIELD_CALL = "field.call.deprecated";
    private static final String _MSG_DEPRECATED_METHOD_CALL = "method.call.deprecated";
    private static final String _MSG_DEPRECATED_TYPE_CALL = "type.call.deprecated";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        try {
            JSONObject javaClassesJSONObject = this.getJavaClassesJSONObject(this.getBaseDirName());
            List<String> deprecatedImportNames = this.getDeprecatedImportNames(detailAST, javaClassesJSONObject);
            for (String deprecatedImportName : deprecatedImportNames) {
                if (!this.hasUndeprecatedReference(detailAST, deprecatedImportName)) continue;
                this.log(this.getImportLineNumber(detailAST, deprecatedImportName), _MSG_DEPRECATED_TYPE_CALL, new Object[]{deprecatedImportName});
            }
            this._checkDeprecatedConstructors(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedMethods(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedTypes(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedVariables(detailAST, deprecatedImportNames, javaClassesJSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected List<BaseAPICheck.ConstructorCall> getDeprecatedConstructorCalls(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        ArrayList<BaseAPICheck.ConstructorCall> deprecatedConstructorCalls = new ArrayList<BaseAPICheck.ConstructorCall>();
        List<BaseAPICheck.ConstructorCall> constructorCalls = this.getConstructorCalls(detailAST, deprecatedImportNames, true);
        block0: for (BaseAPICheck.ConstructorCall constructorCall : constructorCalls) {
            List<JSONObject> constructorJSONObjects = this.getConstructorJSONObjects(constructorCall, javaClassesJSONObject);
            if (constructorJSONObjects.isEmpty()) continue;
            for (JSONObject constructorJSONObject : constructorJSONObjects) {
                if (constructorJSONObject.has("deprecated")) continue;
                continue block0;
            }
            deprecatedConstructorCalls.add(constructorCall);
        }
        return deprecatedConstructorCalls;
    }

    protected List<String> getDeprecatedImportNames(DetailAST detailAST, JSONObject javaClassesJSONObject) {
        ArrayList<String> deprecatedImportNames = new ArrayList<String>();
        List<String> importNames = this.getImportNames(detailAST);
        for (String importName : importNames) {
            JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(importName);
            if (classJSONObject == null || !classJSONObject.has("deprecated")) continue;
            deprecatedImportNames.add(importName);
        }
        return deprecatedImportNames;
    }

    protected List<BaseAPICheck.MethodCall> getDeprecatedMethodCalls(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        ArrayList<BaseAPICheck.MethodCall> deprecatedMethodCalls = new ArrayList<BaseAPICheck.MethodCall>();
        List<BaseAPICheck.MethodCall> methodCalls = this.getMethodCalls(detailAST, deprecatedImportNames, true);
        block0: for (BaseAPICheck.MethodCall methodCall : methodCalls) {
            List<JSONObject> methodJSONObjects = this.getMethodJSONObjects(methodCall, javaClassesJSONObject);
            if (methodJSONObjects.isEmpty()) continue;
            for (JSONObject methodJSONObject : methodJSONObjects) {
                if (methodJSONObject.has("deprecated")) continue;
                continue block0;
            }
            deprecatedMethodCalls.add(methodCall);
        }
        return deprecatedMethodCalls;
    }

    protected Map<String, Set<Integer>> getDeprecatedTypeNamesMap(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        Map<String, Set<Integer>> deprecatedTypeNamesMap = new HashMap<String, Set<Integer>>();
        Map<String, Set<Integer>> typeNamesMap = this.getTypeNamesMap(detailAST, deprecatedImportNames, true);
        for (Map.Entry<String, Set<Integer>> entry : typeNamesMap.entrySet()) {
            String typeName = entry.getKey();
            JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(typeName);
            if (classJSONObject == null || !classJSONObject.has("deprecated")) continue;
            Set<Integer> lineNumbers = entry.getValue();
            for (int lineNumber : lineNumbers) {
                deprecatedTypeNamesMap = this.addTypeName(deprecatedTypeNamesMap, typeName, lineNumber);
            }
        }
        return deprecatedTypeNamesMap;
    }

    protected List<BaseAPICheck.VariableCall> getDeprecatedVariableCalls(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        ArrayList<BaseAPICheck.VariableCall> deprecatedVariableCalls = new ArrayList<BaseAPICheck.VariableCall>();
        List<BaseAPICheck.VariableCall> variableCalls = this.getVariableCalls(detailAST, deprecatedImportNames, true);
        for (BaseAPICheck.VariableCall variableCall : variableCalls) {
            JSONObject variableJSONObject = this.getVariableJSONObject(variableCall, javaClassesJSONObject);
            if (variableJSONObject == null || !variableJSONObject.has("deprecated")) continue;
            deprecatedVariableCalls.add(variableCall);
        }
        return deprecatedVariableCalls;
    }

    protected int getImportLineNumber(DetailAST detailAST, String importName) {
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        String content = (String)fileText.getFullText();
        int x = content.indexOf(StringBundler.concat("import ", importName, ";"));
        if (x != -1) {
            return SourceUtil.getLineNumber(content, x);
        }
        return detailAST.getLineNo();
    }

    protected boolean hasUndeprecatedReference(DetailAST detailAST, String importName) {
        int x = importName.lastIndexOf(".");
        String className = importName.substring(x + 1);
        List<DetailAST> identDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!className.equals(identDetailAST.getText()) || this.hasDeprecatedParent(identDetailAST) || this.hasSuppressDeprecationWarningsAnnotation(identDetailAST)) continue;
            return true;
        }
        return false;
    }

    private void _checkDeprecatedConstructors(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.ConstructorCall> deprecatedConstructorCalls = this.getDeprecatedConstructorCalls(detailAST, deprecatedImportNames, javaClassesJSONObject);
        for (BaseAPICheck.ConstructorCall deprecatedConstructorCall : deprecatedConstructorCalls) {
            this.log(deprecatedConstructorCall.getLineNumber(), _MSG_DEPRECATED_CONSTRUCTOR_CALL, new Object[]{deprecatedConstructorCall.getTypeName()});
        }
    }

    private void _checkDeprecatedMethods(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.MethodCall> deprecatedMethodCalls = this.getDeprecatedMethodCalls(detailAST, deprecatedImportNames, javaClassesJSONObject);
        for (BaseAPICheck.MethodCall deprecatedMethodCall : deprecatedMethodCalls) {
            this.log(deprecatedMethodCall.getLineNumber(), _MSG_DEPRECATED_METHOD_CALL, new Object[]{deprecatedMethodCall.getName()});
        }
    }

    private void _checkDeprecatedTypes(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        Map<String, Set<Integer>> deprecatedTypeNamesMap = this.getDeprecatedTypeNamesMap(detailAST, deprecatedImportNames, javaClassesJSONObject);
        for (Map.Entry<String, Set<Integer>> entry : deprecatedTypeNamesMap.entrySet()) {
            String typeName = entry.getKey();
            Set<Integer> lineNumbers = entry.getValue();
            for (int lineNumber : lineNumbers) {
                this.log(lineNumber, _MSG_DEPRECATED_TYPE_CALL, new Object[]{typeName});
            }
        }
    }

    private void _checkDeprecatedVariables(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.VariableCall> deprecatedVariableCalls = this.getDeprecatedVariableCalls(detailAST, deprecatedImportNames, javaClassesJSONObject);
        for (BaseAPICheck.VariableCall deprecatedVariableCall : deprecatedVariableCalls) {
            this.log(deprecatedVariableCall.getLineNumber(), _MSG_DEPRECATED_FIELD_CALL, new Object[]{deprecatedVariableCall.getName()});
        }
    }
}

