/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.PythonImportsFormatter;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonImportsCheck
extends BaseFileCheck {
    private static final Pattern _importsPattern1 = Pattern.compile("\n+[ \t]*import (.*)");
    private static final Pattern _importsPattern2 = Pattern.compile("(^[ \t]*from (.*) import (.+(\\\\\n[\\s\\S]+?)*)(?<!\\\\)(\n|\\Z)+)+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._formatModuleImports(content);
        content = this._formatPackageImports(content);
        if ((content = content.replaceAll("(?m)^(([ \t]*)from [\\s\\S]+?)\n+^(\\2(?!from )[^\t\n])", "$1\n\n$3")).endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String _formatModuleImports(String content) {
        Matcher matcher = _importsPattern1.matcher(content);
        ArrayList<String> importNames = new ArrayList<String>();
        int startPosition = -1;
        while (matcher.find()) {
            importNames.add(matcher.group(1));
            if (startPosition == -1) {
                startPosition = matcher.start();
            }
            content = content.replaceFirst(matcher.group(), "");
        }
        if (ListUtil.isEmpty(importNames)) {
            return content;
        }
        Collections.sort(importNames);
        StringBundler sb = new StringBundler(importNames.size() * 3 + 1);
        sb.append("\n");
        for (String importName : importNames) {
            sb.append("\n");
            sb.append("import ");
            sb.append(importName);
        }
        return StringUtil.insert(content, sb.toString(), startPosition);
    }

    private String _formatPackageImports(String content) throws IOException {
        PythonImportsFormatter importsFormatter = new PythonImportsFormatter();
        return importsFormatter.format(content, _importsPattern2);
    }
}

