/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPVariableOrderCheck
extends BaseFileCheck {
    private static final Pattern _variableDefinitionPattern = Pattern.compile("<%\n(\t*[\\w<>\\[\\],\\? ]+ \\w+ = .*\n){2,}\t*%>(\n|\\Z)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Matcher matcher = _variableDefinitionPattern.matcher(content);
        while (matcher.find()) {
            int endLineNumber = this.getLineNumber(content, matcher.end(1) - 1);
            int startLineNumber = this.getLineNumber(content, matcher.start() + 3);
            String previousLine = null;
            String previousVariableName = null;
            for (int i = startLineNumber; i <= endLineNumber; ++i) {
                String line = this.getLine(content, i);
                int x = line.indexOf(" =");
                int y = line.lastIndexOf(" ", x - 1);
                String variableName = line.substring(y, x);
                if (previousVariableName != null && variableName.compareToIgnoreCase(previousVariableName) < 0) {
                    content = StringUtil.replaceFirst(content, line, previousLine, matcher.start());
                    content = StringUtil.replaceFirst(content, previousLine, line, matcher.start());
                    return content;
                }
                previousLine = line;
                previousVariableName = variableName;
            }
        }
        return content;
    }
}

