/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.reflect.ReflectionUtil;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class ProxyUtil {
    private static final Class<?>[] _ARGUMENTS_CLASS = new Class[]{InvocationHandler.class};
    private static final ConcurrentMap<ClassLoader, ConcurrentMap<LookupKey, Class<?>>> _classReferences = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final ConcurrentMap<Class<?>, ConstructorReference> _constructorReferences = new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final Field _invocationHandlerField;

    public static <T extends InvocationHandler> T fetchInvocationHandler(Object proxy, Class<T> clazz) {
        if (!ProxyUtil.isProxyClass(proxy.getClass())) {
            return null;
        }
        try {
            InvocationHandler invocationHandler = (InvocationHandler)_invocationHandlerField.get(proxy);
            if (clazz.isInstance(invocationHandler)) {
                return (T)((InvocationHandler)clazz.cast(invocationHandler));
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    public static InvocationHandler getInvocationHandler(Object proxy) {
        if (!ProxyUtil.isProxyClass(proxy.getClass())) {
            throw new IllegalArgumentException("Not a proxy instance");
        }
        try {
            return (InvocationHandler)_invocationHandlerField.get(proxy);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getProxyClass(ClassLoader classLoader, Class<?> ... interfaceClasses) {
        LookupKey lookupKey;
        Class<?> clazz;
        ConcurrentMap oldClassReferences;
        ConcurrentMap classReferences = (ConcurrentMap)_classReferences.get(classLoader);
        if (classReferences == null && (oldClassReferences = _classReferences.putIfAbsent(classLoader, classReferences = new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY))) != null) {
            classReferences = oldClassReferences;
        }
        if ((clazz = (Class<?>)classReferences.get(lookupKey = new LookupKey(interfaceClasses))) == null) {
            ConcurrentMap concurrentMap = classReferences;
            synchronized (concurrentMap) {
                clazz = (Class)classReferences.get(lookupKey);
                if (clazz == null) {
                    clazz = Proxy.getProxyClass(classLoader, interfaceClasses);
                    classReferences.put(lookupKey, clazz);
                }
            }
        }
        _constructorReferences.putIfAbsent(clazz, new ConstructorReference());
        return clazz;
    }

    public static <T> Function<InvocationHandler, T> getProxyProviderFunction(Class<?> ... interfaceClasses) {
        ClassLoader classLoader = interfaceClasses[0].getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Class<?> proxyClass = ProxyUtil.getProxyClass(classLoader, interfaceClasses);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(_ARGUMENTS_CLASS);
            return invocationHandler -> {
                try {
                    return constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new InternalError(reflectiveOperationException);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException);
        }
    }

    public static boolean isProxyClass(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return _constructorReferences.containsKey(clazz);
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class<?>[] interfaces, InvocationHandler invocationHandler) {
        Class<?> proxyClass = ProxyUtil.getProxyClass(classLoader, interfaces);
        ConstructorReference constructorHolder = (ConstructorReference)_constructorReferences.get(proxyClass);
        return constructorHolder.newInstance(proxyClass, invocationHandler);
    }

    static {
        try {
            _invocationHandlerField = ReflectionUtil.getDeclaredField(Proxy.class, "h");
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private static class LookupKey {
        private final int _hashCode;
        private final Reference<?>[] _references;

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            LookupKey lookupKey = (LookupKey)object;
            Reference<?>[] references = lookupKey._references;
            if (this._references.length != references.length) {
                return false;
            }
            for (int i = 0; i < this._references.length; ++i) {
                Reference<?> reference = this._references[i];
                Reference<?> otherReference = references[i];
                if (reference.get() == otherReference.get()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private LookupKey(Class<?>[] interfaces) {
            int hashCode = 0;
            this._references = new Reference[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> clazz = interfaces[i];
                hashCode = HashUtil.hash((int)hashCode, (Object)clazz.getName());
                this._references[i] = new WeakReference(clazz);
            }
            this._hashCode = hashCode;
        }
    }

    private static class ConstructorReference {
        private volatile Reference<Constructor<?>> _reference;

        private ConstructorReference() {
        }

        public Object newInstance(Class<?> proxyClass, InvocationHandler invocationHandler) {
            Constructor<?> constructor = null;
            Reference<Constructor<?>> reference = this._reference;
            try {
                if (reference == null || (constructor = reference.get()) == null) {
                    constructor = proxyClass.getConstructor(_ARGUMENTS_CLASS);
                    constructor.setAccessible(true);
                    this._reference = new WeakReference(constructor);
                }
                return constructor.newInstance(invocationHandler);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
        }
    }
}

