/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class FullyQualifiedNameCheck
extends BaseCheck {
    private static final String _MSG_USE_IMPORT_STATEMENT = "import.statement.use";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null) {
            return;
        }
        List<DetailAST> nameDetailASTList = this.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameDetailAST : nameDetailASTList) {
            String name;
            String fullyQualifiedName = this._getFullyQualifiedName(nameDetailAST, name = nameDetailAST.getText());
            if (fullyQualifiedName == null || fullyQualifiedName.matches(".*\\.upgrade\\.v[0-9_]+\\.\\w+") || this._isFullyQualifiedNameRequired(detailAST, fullyQualifiedName, name, nameDetailASTList)) continue;
            this.log(nameDetailAST, _MSG_USE_IMPORT_STATEMENT, new Object[]{fullyQualifiedName});
        }
    }

    private boolean _containsImport(DetailAST rootDetailAST, String className) {
        DetailAST siblingDetailAST = rootDetailAST;
        while (true) {
            DetailAST dotDetailAST;
            if ((siblingDetailAST = siblingDetailAST.getPreviousSibling()) == null) {
                return false;
            }
            if (siblingDetailAST.getType() != 30 && siblingDetailAST.getType() != 152 || (dotDetailAST = siblingDetailAST.findFirstToken(59)) == null) continue;
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotDetailAST);
            String importName = fullIdent.getText();
            if (siblingDetailAST.getType() == 30 && importName.endsWith("." + className) || siblingDetailAST.getType() == 152 && importName.contains("." + className + ".")) break;
        }
        return true;
    }

    private String _getFullyQualifiedName(DetailAST nameDetailAST, String name) {
        if (!name.matches("[A-Z][A-Za-z0-9]+")) {
            return null;
        }
        DetailAST parentDetailAST = nameDetailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return null;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)parentDetailAST);
        String fullyQualifiedName = fullIdent.getText();
        if (fullyQualifiedName.matches("([a-z]\\w*\\.){2,}[A-Z]\\w*")) {
            return fullyQualifiedName;
        }
        return null;
    }

    private boolean _isFullyQualifiedNameRequired(DetailAST rootDetailAST, String fullyQualifiedName, String className, List<DetailAST> nameDetailASTList) {
        if (this._containsImport(rootDetailAST, className)) {
            return true;
        }
        for (DetailAST nameDetailAST : nameDetailASTList) {
            String curFullyQualifiedName;
            String name = nameDetailAST.getText();
            if (!name.equals(className) || (curFullyQualifiedName = this._getFullyQualifiedName(nameDetailAST, name)) != null && curFullyQualifiedName.equals(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }
}

