/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.HTMLSourceProcessor;
import com.liferay.source.formatter.checks.BaseTagAttributesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLTagAttributesCheck
extends BaseTagAttributesCheck {
    private static final String[] _MULTI_LINE_TAG_NAMES = new String[]{"arquillian", "beans", "chmod", "copy", "dirset", "ehcache", "fileset", "get", "globmapper", "instance-wrapper", "jar", "java", "javac", "loadfile", "mapper", "math", "mirrors-get", "move", "patternset", "propertyregex", "replace", "replacefilter", "replaceregexp", "resourcecontains", "taskdef", "unjar", "untar", "unzip", "uptodate", "war", "workflow-definition", "zip", "zipfileset"};
    private static final String[] _SINGLE_LINE_TAG_NAMES = new String[]{"action", "ant", "antcall", "antelope:repeat", "antelope:replace", "antelope:stringutil", "antelope:substring", "appender", "appender-ref", "archetype-descriptor", "arg", "attach", "attribute", "available", "band", "baseDir", "basename", "bean", "bottomPen", "category", "check", "class", "column", "command", "component", "condition", "constructor-arg", "contains", "content", "contribution-limit", "copyField", "definition", "delete", "description", "dirname", "div", "dtd", "dynamic-element", "dynamicField", "echo", "element", "entity", "entry", "env", "equals", "exclude", "exec", "execute", "fail", "field", "fieldType", "fileSet", "filter", "finder", "finder-column", "font", "for", "format", "forward", "generator", "gradle-execute", "hibernate-mapping", "hint-collection", "http", "id", "ignored-parameter", "ignore-error", "import", "include", "isset", "istrue", "jvmarg", "layout", "layout-template", "leftPen", "link", "list", "loadproperties", "local", "log4j:configuration", "logger", "lst", "macrodef", "matches", "media:thumbnail", "message", "meta-data", "mkdir", "model", "module", "order", "order-column", "os", "param", "parser", "path", "pathconvert", "pathelement", "portlet", "portlet-app", "poshi-execute", "present", "priority", "project", "property", "propertycopy", "propertyfile", "propertyref", "propertyresource", "put", "record", "ref", "reference", "remake-dir", "replaceregex", "replacestring", "reportElement", "requestHandler", "requiredProperty", "resourcecount", "resource-root", "return", "rightPen", "role", "rollingPolicy", "root", "service-builder", "sleep", "socket", "source-folder", "source-processor", "sql", "suppress", "sysproperty", "target", "task", "textElement", "textField", "tokenizer", "topPen", "trycatch", "util:constant", "validator", "var", "version", "waitfor", "web-app", "xs:attribute", "xs:choice", "xs:complexType", "xs:element", "xs:enumeration", "xs:extension", "xs:group", "xs:restriction", "xs:simpleType"};
    private static final Pattern _htmlTagPattern = Pattern.compile("\t<\\w+");

    @Override
    protected BaseTagAttributesCheck.Tag doFormatLineBreaks(BaseTagAttributesCheck.Tag tag, String absolutePath) {
        if (absolutePath.endsWith("/pom.xml") || absolutePath.endsWith(".pom")) {
            return tag;
        }
        if (ArrayUtil.contains(_SINGLE_LINE_TAG_NAMES, tag.getFullName())) {
            tag.setMultiLine(false);
        } else if (ArrayUtil.contains(_MULTI_LINE_TAG_NAMES, tag.getFullName())) {
            tag.setMultiLine(true);
        }
        return tag;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (this.getSourceProcessor() instanceof HTMLSourceProcessor) {
            content = this._formatHTMLIncorrectLineBreaks(content);
        }
        content = this.formatIncorrectLineBreak(fileName, content);
        content = this._formatTagAttributes(absolutePath, content);
        content = this.formatMultiLinesTagAttributes(absolutePath, content, true);
        return content;
    }

    @Override
    protected BaseTagAttributesCheck.Tag sortHTMLTagAttributes(BaseTagAttributesCheck.Tag tag) {
        if (this.getSourceProcessor() instanceof HTMLSourceProcessor) {
            return super.sortHTMLTagAttributes(tag);
        }
        return tag;
    }

    private String _formatHTMLIncorrectLineBreaks(String content) {
        Matcher matcher = _htmlTagPattern.matcher(content);
        while (matcher.find()) {
            String tag;
            int x = matcher.start();
            do {
                if ((x = content.indexOf(">", x + 1)) == -1) {
                    return content;
                }
                tag = content.substring(matcher.start(), x + 1);
            } while (ToolsUtil.isInsideQuotes(content, x) || this.getLevel(tag, "<", ">") != 0);
            if (!tag.contains("\n")) continue;
            String replacement = StringUtil.replace(tag, new String[]{"\t", "\n>", "\n"}, new String[]{"", ">", " "});
            return StringUtil.replaceFirst(content, tag, replacement, matcher.start());
        }
        return content.replaceAll("(</\\w+)\\s+(>)", "$1$2");
    }

    private String _formatTagAttributes(String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            boolean sortAttributes = true;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String trimmedLine = StringUtil.trimLeading(line);
                if (sortAttributes) {
                    if (!(!trimmedLine.startsWith("<") || !trimmedLine.endsWith(">") || trimmedLine.startsWith("<?") || trimmedLine.startsWith("<%") || trimmedLine.startsWith("<!") || line.contains("<![CDATA[") && line.contains("]]>"))) {
                        line = this.formatTagAttributes(absolutePath, line, true, false);
                    } else if (trimmedLine.startsWith("<![CDATA[") && !trimmedLine.endsWith("]]>")) {
                        sortAttributes = false;
                    }
                } else if (trimmedLine.endsWith("]]>")) {
                    sortAttributes = true;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

