/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLLongNamesCheck
extends BaseFileCheck {
    private static final int _MAX_NAME_LENGTH = 30;
    private static final Pattern _columnPattern = Pattern.compile("\n\t*(\\w+) ");
    private static final Pattern _createTablePattern = Pattern.compile("create table (\\w+) \\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkTables(fileName, content);
        return content;
    }

    private void _checkColumns(String fileName, String tableContent, int startLineNumber) {
        Matcher matcher = _columnPattern.matcher(tableContent);
        while (matcher.find()) {
            String columnName = matcher.group(1);
            if (columnName.length() <= 30) continue;
            this.addMessage(fileName, StringBundler.concat("Column name '", columnName, "' should not exceed ", 30, " characters"), startLineNumber + this.getLineNumber(tableContent, matcher.start()));
        }
    }

    private void _checkTables(String fileName, String content) {
        Matcher matcher = _createTablePattern.matcher(content);
        while (matcher.find()) {
            String tableContent;
            String tableName = matcher.group(1);
            if (tableName.length() > 30) {
                this.addMessage(fileName, StringBundler.concat("Table name '", tableName, "' should not exceed ", 30, " characters"), this.getLineNumber(content, matcher.start()));
            }
            int x = matcher.end();
            do {
                if ((x = content.indexOf(")", x + 1)) != -1) continue;
                return;
            } while (this.getLevel(tableContent = content.substring(matcher.end(), x)) != 0);
            this._checkColumns(fileName, tableContent, this.getLineNumber(content, matcher.end()));
        }
    }
}

