/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.PropertiesSourceProcessor;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class PropertiesPortalFileCheck
extends BaseFileCheck {
    private static final String _ALLOWED_SINGLE_LINE_PROPERTY_KEYS = "allowedSingleLinePropertyKeys";
    private String _portalPortalPropertiesContent;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if ((this.isPortalSource() || this.isSubrepository()) && fileName.matches(".*/portal(-[^-/]+)*\\.properties") || !this.isPortalSource() && !this.isSubrepository() && fileName.endsWith("portal.properties")) {
            content = this._sortPortalProperties(absolutePath, content);
            content = this._formatPortalProperties(absolutePath, content);
        }
        return content;
    }

    private String _formatPortalProperties(String absolutePath, String content) throws IOException {
        List<String> allowedSingleLinePropertyKeys = this.getAttributeValues(_ALLOWED_SINGLE_LINE_PROPERTY_KEYS, absolutePath);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String propertyKey;
                if (line.matches("    [^# ]+?=[^,]+(,[^ ][^,]+)+") && !(propertyKey = StringUtil.extractFirst(StringUtil.trimLeading(line), "=")).contains("regex") && !allowedSingleLinePropertyKeys.contains(propertyKey)) {
                    line = line.replaceFirst("=", "=\\\\\n        ");
                    line = line.replaceAll(",", ",\\\\\n        ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private synchronized String _getPortalPortalPropertiesContent(String absolutePath) throws IOException {
        if (this._portalPortalPropertiesContent != null) {
            return this._portalPortalPropertiesContent;
        }
        if (this.isPortalSource() || this.isSubrepository()) {
            this._portalPortalPropertiesContent = this.getPortalContent("portal-impl/src/portal.properties", absolutePath);
            if (this._portalPortalPropertiesContent == null) {
                this._portalPortalPropertiesContent = "";
            }
            return this._portalPortalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        this._portalPortalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        return this._portalPortalPropertiesContent;
    }

    private String _getPropertyCluster(String content, int lineNumber) {
        StringBundler sb = new StringBundler();
        while (true) {
            String line;
            if (Validator.isNull(line = this.getLine(content, lineNumber))) {
                sb.setIndex(sb.index() - 1);
                return sb.toString();
            }
            sb.append(line);
            sb.append("\n");
            ++lineNumber;
        }
    }

    private String _sortPortalProperties(String content, int lineNumber, Collection<Integer> positions, Map<Integer, Collection<Integer>> propertyClusterPositionsMap) {
        if (propertyClusterPositionsMap.isEmpty()) {
            return content;
        }
        block0: for (Map.Entry<Integer, Collection<Integer>> entry : propertyClusterPositionsMap.entrySet()) {
            Iterator<Integer> iterator = entry.getValue().iterator();
            if (!iterator.hasNext()) continue;
            int curPosition = iterator.next();
            for (int position : positions) {
                if (curPosition > position) continue;
                continue block0;
            }
            int previousLineNumber = entry.getKey();
            String previousPropertyCluster = this._getPropertyCluster(content, previousLineNumber);
            String propertyCluster = this._getPropertyCluster(content, lineNumber);
            content = StringUtil.replaceFirst(content, propertyCluster, previousPropertyCluster, this.getLineStartPos(content, lineNumber) - 1);
            content = StringUtil.replaceFirst(content, previousPropertyCluster, propertyCluster, this.getLineStartPos(content, previousLineNumber) - 1);
            return content;
        }
        return content;
    }

    private String _sortPortalProperties(String content, int lineNumber, int pos, Map<Integer, Integer> propertyPositionsMap) {
        for (Map.Entry<Integer, Integer> entry : propertyPositionsMap.entrySet()) {
            int curPos = entry.getValue();
            if (curPos <= pos) continue;
            int curLineNumber = entry.getKey();
            String curProperty = this.getLine(content, curLineNumber);
            String property = this.getLine(content, lineNumber);
            content = StringUtil.replaceFirst(content, property, curProperty, this.getLineStartPos(content, lineNumber) - 1);
            content = StringUtil.replaceFirst(content, curProperty, property, this.getLineStartPos(content, curLineNumber) - 1);
            return content;
        }
        return content;
    }

    private String _sortPortalProperties(String absolutePath, String content) throws IOException {
        if (absolutePath.endsWith("/portal-impl/src/portal.properties")) {
            return content;
        }
        String portalPortalPropertiesContent = this._getPortalPortalPropertiesContent(absolutePath);
        HashMap<Integer, Integer> propertyPositionsMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Collection<Integer>> propertyClusterPositionsMap = new HashMap<Integer, Collection<Integer>>();
        int startLineNumber = 1;
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                int pos;
                ++lineNumber;
                if (Validator.isNull(line)) {
                    if (!propertyPositionsMap.isEmpty()) {
                        Collection<Integer> positions = propertyPositionsMap.values();
                        String newContent = this._sortPortalProperties(content, startLineNumber, positions, propertyClusterPositionsMap);
                        if (!newContent.equals(content)) {
                            String string = newContent;
                            return string;
                        }
                        propertyClusterPositionsMap.put(startLineNumber, positions);
                        propertyPositionsMap = new HashMap();
                    }
                    startLineNumber = lineNumber + 1;
                    continue;
                }
                if (line.matches(" *#.*") || (pos = line.indexOf(61)) == -1) continue;
                String property = StringUtil.trim(line.substring(0, pos + 1));
                pos = portalPortalPropertiesContent.indexOf("    " + property);
                if (pos == -1) continue;
                String newContent = this._sortPortalProperties(content, lineNumber, pos, propertyPositionsMap);
                if (!newContent.equals(content)) {
                    String string = newContent;
                    return string;
                }
                propertyPositionsMap.put(lineNumber, pos);
            }
        }
        if (!propertyPositionsMap.isEmpty()) {
            return this._sortPortalProperties(content, startLineNumber, propertyPositionsMap.values(), propertyClusterPositionsMap);
        }
        return content;
    }
}

