/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaDuplicateVariableCheck
extends BaseJavaTermCheck {
    private static final Log _log = LogFactoryUtil.getLog(JavaDuplicateVariableCheck.class);
    private Map<String, String> _bundleSymbolicNamesMap;
    private final Map<String, Map<String, List<JavaVariable>>> _javaVariablesMap = new HashMap<String, Map<String, List<JavaVariable>>>();
    private String _rootDirName;

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws IOException {
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.isAnonymous() || javaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        List<String> extendedClassNames = javaClass.getExtendedClassNames(true);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!(childJavaTerm instanceof JavaVariable) || childJavaTerm.isFinal() || childJavaTerm.hasAnnotation("Deprecated") || !childJavaTerm.isPublic() && !childJavaTerm.isProtected()) continue;
            this._checkDuplicateVariable(fileName, absolutePath, extendedClassNames, (JavaVariable)childJavaTerm, javaClass.getPackageName());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkDuplicateVariable(String fileName, String absolutePath, List<String> extendedClassNames, JavaVariable javaVariable, String packageName) throws IOException {
        String variableName = javaVariable.getName();
        for (String extendedClassName : extendedClassNames) {
            Map<String, List<JavaVariable>> extendedJavaVariablesMap = this._getJavaVariablesMap(absolutePath, extendedClassName);
            for (Map.Entry<String, List<JavaVariable>> entry : extendedJavaVariablesMap.entrySet()) {
                List<JavaVariable> javaVariables = entry.getValue();
                for (JavaVariable curJavaVariable : javaVariables) {
                    if (!variableName.equals(curJavaVariable.getName())) continue;
                    String fullyQualifiedClassName = entry.getKey();
                    int pos = fullyQualifiedClassName.lastIndexOf(46);
                    String variablePackageName = fullyQualifiedClassName.substring(0, pos);
                    if (!curJavaVariable.isPublic() && (!curJavaVariable.isProtected() || !packageName.equals(variablePackageName))) continue;
                    String variableClassName = fullyQualifiedClassName.substring(pos + 1);
                    this.addMessage(fileName, StringBundler.concat(javaVariable.getAccessModifier(), " variable '", variableName, "' already exists in extended class '", variableClassName, "'"), javaVariable.getLineNumber());
                }
            }
        }
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        if (this._bundleSymbolicNamesMap != null) {
            return this._bundleSymbolicNamesMap;
        }
        this._bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        return this._bundleSymbolicNamesMap;
    }

    private Map<String, List<JavaVariable>> _getJavaVariablesMap(String absolutePath, String fullyQualifiedClassName) throws IOException {
        HashMap<String, List<JavaVariable>> javaVariablesMap;
        block4: {
            if (this._javaVariablesMap.containsKey(fullyQualifiedClassName)) {
                return this._javaVariablesMap.get(fullyQualifiedClassName);
            }
            javaVariablesMap = new HashMap<String, List<JavaVariable>>();
            File file = JavaSourceUtil.getJavaFile(fullyQualifiedClassName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath));
            if (file != null) {
                try {
                    JavaClass javaClass = JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(file), FileUtil.read(file));
                    javaVariablesMap.putAll(this._getJavaVariablesMap(absolutePath, fullyQualifiedClassName, javaClass));
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug(exception, exception);
                }
            }
        }
        this._javaVariablesMap.put(fullyQualifiedClassName, javaVariablesMap);
        return javaVariablesMap;
    }

    private Map<String, List<JavaVariable>> _getJavaVariablesMap(String absolutePath, String fullyQualifiedName, JavaClass javaClass) throws IOException {
        HashMap javaVariablesMap = HashMapBuilder.put(fullyQualifiedName, () -> {
            ArrayList<JavaVariable> javaVariables = new ArrayList<JavaVariable>();
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                if (!(javaTerm instanceof JavaVariable) || !javaTerm.isProtected() && !javaTerm.isPublic()) continue;
                javaVariables.add((JavaVariable)javaTerm);
            }
            return javaVariables;
        }).build();
        List<String> extendedClassNames = javaClass.getExtendedClassNames(true);
        for (String extendedClassName : extendedClassNames) {
            javaVariablesMap.putAll(this._getJavaVariablesMap(absolutePath, extendedClassName));
        }
        return javaVariablesMap;
    }

    private synchronized String _getRootDirName(String absolutePath) {
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        this._rootDirName = SourceUtil.getRootDirName(absolutePath);
        return this._rootDirName;
    }
}

