/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.Map;

public class GradlePropertiesCheck
extends BaseFileCheck {
    private static final Map<String, String> _keysRegexMap = MapUtil.fromArray("sourceCompatibility", "[0-9]+\\.[0-9]+", "targetCompatibility", "[0-9]+\\.[0-9]+");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                sb.append(this._fixValue(line));
                sb.append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private final String _fixValue(String line) {
        String[] array = line.split("=", 2);
        if (array.length != 2) {
            return line;
        }
        String regex = _keysRegexMap.get(StringUtil.trim(array[0]));
        if (regex == null) {
            return line;
        }
        String value = StringUtil.trim(array[1]);
        String strippedValue = StringUtil.removeChars(value, '\'', '\"');
        if (strippedValue.matches(regex)) {
            return StringUtil.replaceLast(line, value, "\"" + strippedValue + "\"");
        }
        return line;
    }
}

