/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

public abstract class BaseStringConcatenationCheck
extends BaseCheck {
    protected static final String MSG_COMBINE_LITERAL_STRINGS = "literal.string.combine";
    protected static final String MSG_INCORRECT_PLUS = "plus.incorrect";
    protected static final String MSG_MOVE_LITERAL_STRING = "literal.string.move";
    private static final String _MSG_COMBINE_STRING = "string.combine";
    private static final String _MSG_INVALID_END_CHARACTER = "end.character.invalid";
    private static final String _MSG_INVALID_START_CHARACTER = "start.character.invalid";

    protected void checkCombineOperand(DetailAST literalStringDetailAST, DetailAST operandDetailAST) {
        if (operandDetailAST.getType() != 59) {
            return;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)operandDetailAST);
        String text = fullIdent.getText();
        if (!(!text.startsWith("CharPool.") && !text.startsWith("StringPool.") || text.endsWith(".DEFAULT_CHARSET_NAME") || text.endsWith(".DELETE") || text.endsWith(".NEW_LINE") || text.endsWith(".NO_BREAK_SPACE") || text.endsWith(".TAB"))) {
            this.log(literalStringDetailAST, _MSG_COMBINE_STRING, new Object[]{this.getStringValue(literalStringDetailAST), text});
        }
    }

    protected void checkLiteralStringBreaks(DetailAST rightHandOperandDetailAST, String line1, String line2, String value1, String value2) {
        String s;
        int lineLength2;
        if (!value1.matches("^(.*([ /\\.,]))?(\\w+)$") || !value2.matches("^(\\w+)(([ /\\.,]).*)?$")) {
            return;
        }
        int lineLength1 = CommonUtil.lengthExpandedTabs((String)line1, (int)line1.length(), (int)this.getTabWidth());
        int x = this._getStringBreakPos(value2, this.getMaxLineLength() - lineLength1);
        if (x != -1) {
            this.log(rightHandOperandDetailAST, MSG_MOVE_LITERAL_STRING, new Object[]{value2.substring(0, x + 1), "previous"});
            return;
        }
        x = this._getLastStringBreakPos(value1);
        if (x != -1 && (lineLength2 = CommonUtil.lengthExpandedTabs((String)line2, (int)line2.length(), (int)this.getTabWidth())) + (s = value1.substring(x)).length() <= this.getMaxLineLength()) {
            this.log(rightHandOperandDetailAST, MSG_MOVE_LITERAL_STRING, new Object[]{s, "next"});
        }
    }

    protected void checkLiteralStringStartAndEndCharacter(String literalString1, String literalString2, int lineNumber) {
        if (literalString1.endsWith("/")) {
            this.log(lineNumber, _MSG_INVALID_END_CHARACTER, new Object[]{Character.valueOf(literalString1.charAt(literalString1.length() - 1))});
        }
        if (literalString1.endsWith("\n") && literalString2.startsWith(" ") || !literalString1.endsWith(" ") && literalString2.matches("^[-:;.].*")) {
            this.log(lineNumber + 1, _MSG_INVALID_START_CHARACTER, new Object[]{Character.valueOf(literalString2.charAt(0))});
        }
    }

    protected int getMaxLineLength() {
        return GetterUtil.getInteger(this.getAttributeValue("maxLineLength"));
    }

    protected int getStringBreakPos(String s1, String s2, int i) {
        if (s2.startsWith("/")) {
            int pos = s2.lastIndexOf("/", i);
            if (pos > 0) {
                return pos - 1;
            }
            return -1;
        }
        if (s1.endsWith("-")) {
            return Math.max(s2.lastIndexOf("-", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(".")) {
            return Math.max(s2.lastIndexOf(".", i - 1), s2.lastIndexOf(" ", i - 1));
        }
        if (s1.endsWith(" ")) {
            return s2.lastIndexOf(" ", i - 1);
        }
        return -1;
    }

    protected String getStringValue(DetailAST stringLiteralDetailAST) {
        String stringValue = stringLiteralDetailAST.getText();
        return stringValue.substring(1, stringValue.length() - 1);
    }

    private int _getLastStringBreakPos(String s) {
        int x = Math.max(s.lastIndexOf("-"), Math.max(s.lastIndexOf("."), s.lastIndexOf(" ")));
        if (x == -1) {
            return s.lastIndexOf("/");
        }
        return Math.max(x + 1, s.lastIndexOf("/"));
    }

    private int _getStringBreakPos(String s, int i) {
        int x = Math.max(s.lastIndexOf("-", i - 1), Math.max(s.lastIndexOf(".", i - 1), s.lastIndexOf(" ", i - 1)));
        int y = s.lastIndexOf("/", i);
        if (y > 0) {
            return Math.max(x, y - 1);
        }
        return x;
    }
}

