/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiDependenciesFileLocationCheck
extends BaseFileCheck {
    private static final String _GLOBAL_DEPENDENCIES_DIRECTORY = "portal-web/test/functional/com/liferay/portalweb/dependencies";
    private static final String[] _SKIP_DIR_NAMES = new String[]{".git", ".gradle", ".idea", ".m2", ".releng", ".settings", "bin", "build", "classes", "node_modules", "node_modules_cache", "poshi", "private", "source-formatter"};
    private static final String[] _TEST_FILE_LOCATIONS = new String[]{"modules", "portal-web/test/functional/com/liferay/portalweb/tests"};
    private static final Map<String, Set<String>> _dependenciesFileLocationsMap = new HashMap<String, Set<String>>();
    private static boolean _dependenciesFileLocationsMapIsReady;
    private static final Map<String, Set<String>> _dependenciesGlobalFileLocationsMap;
    private static boolean _dependenciesGlobalFileLocationsMapIsReady;
    private static final List<String> _testCaseFileNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith(".testcase")) {
            return content;
        }
        this._getTestCaseFileNames();
        this._checkDependenciesFileReferences(absolutePath, fileName);
        this._checkGlobalDependenciesFileReferences(absolutePath, fileName);
        return content;
    }

    private synchronized void _checkDependenciesFileReferences(String absolutePath, String fileName) throws IOException {
        this._getTestCaseDependenciesFileLocations();
        if (!_dependenciesFileLocationsMapIsReady) {
            for (String string : _testCaseFileNames) {
                File testCaseFile = new File(string);
                String testCaseFileContent = FileUtil.read(testCaseFile);
                for (Map.Entry<String, Set<String>> entry : _dependenciesFileLocationsMap.entrySet()) {
                    String dependenciesFileLocation = entry.getKey();
                    String dependenciesFileName = dependenciesFileLocation.replaceFirst(".*/(.+)", "$1");
                    String s = Pattern.quote(dependenciesFileName);
                    Pattern dependenciesFileNamePattern = Pattern.compile("[\",]" + s + "[\",]");
                    Matcher matcher = dependenciesFileNamePattern.matcher(testCaseFileContent);
                    while (matcher.find()) {
                        Set<String> referencesFiles = entry.getValue();
                        referencesFiles.add(string);
                        _dependenciesFileLocationsMap.put(dependenciesFileLocation, referencesFiles);
                    }
                }
            }
        }
        block3: for (Map.Entry entry : _dependenciesFileLocationsMap.entrySet()) {
            Set referencesFiles = (Set)entry.getValue();
            HashSet<String> removedDuplicatedFilePaths = new HashSet<String>();
            for (String referencesFile : referencesFiles) {
                String referencesFilePath = referencesFile.substring(0, referencesFile.lastIndexOf("/"));
                removedDuplicatedFilePaths.add(referencesFilePath);
            }
            if (removedDuplicatedFilePaths.size() <= 1 || referencesFiles.size() <= 1) continue;
            for (String referencesFile : referencesFiles) {
                if (!referencesFile.equals(absolutePath)) continue;
                this.addMessage(fileName, StringBundler.concat("Test dependencies file '", (String)entry.getKey(), "' is referenced by multiple modules, move it ", "to global dependencies directory"));
                continue block3;
            }
        }
        _dependenciesFileLocationsMapIsReady = true;
    }

    private synchronized void _checkGlobalDependenciesFileReferences(String absolutePath, String fileName) throws IOException {
        this._getTestCaseGlobalDependenciesFileLocations();
        if (!_dependenciesGlobalFileLocationsMapIsReady) {
            for (String string : _testCaseFileNames) {
                File testCaseFile = new File(string);
                String testCaseFileContent = FileUtil.read(testCaseFile);
                for (Map.Entry<String, Set<String>> entry : _dependenciesGlobalFileLocationsMap.entrySet()) {
                    String dependenciesFileLocation = entry.getKey();
                    String dependenciesFileName = dependenciesFileLocation.replaceFirst(".*/(.+)", "$1");
                    String s = Pattern.quote(dependenciesFileName);
                    Pattern dependenciesFileNamePattern = Pattern.compile("[\",]" + s + "[\",]");
                    Matcher matcher = dependenciesFileNamePattern.matcher(testCaseFileContent);
                    while (matcher.find()) {
                        Set<String> referencesFiles = entry.getValue();
                        referencesFiles.add(string);
                        _dependenciesGlobalFileLocationsMap.put(dependenciesFileLocation, referencesFiles);
                    }
                }
            }
        }
        block3: for (Map.Entry entry : _dependenciesGlobalFileLocationsMap.entrySet()) {
            Set referencesFiles = (Set)entry.getValue();
            if (referencesFiles.size() != 1) continue;
            for (String referencesFile : referencesFiles) {
                if (!referencesFile.equals(absolutePath)) continue;
                this.addMessage(fileName, StringBundler.concat("Test dependencies file '", (String)entry.getKey(), "' is only referenced by one module, move it ", "to module dependencies directory"));
                continue block3;
            }
        }
        _dependenciesGlobalFileLocationsMapIsReady = true;
    }

    private synchronized void _getTestCaseDependenciesFileLocations() throws IOException {
        if (!_dependenciesFileLocationsMap.isEmpty()) {
            return;
        }
        for (String dependenciesFileLocation : _TEST_FILE_LOCATIONS) {
            File directory = new File(this.getPortalDir(), dependenciesFileLocation);
            Path dirPath = directory.toPath();
            Files.walkFileTree(dirPath, EnumSet.noneOf(FileVisitOption.class), 25, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (ArrayUtil.contains(_SKIP_DIR_NAMES, String.valueOf(dirPath.getFileName()))) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    String absolutePath = SourceUtil.getAbsolutePath(dirPath);
                    if (absolutePath.contains("/test/") || absolutePath.contains("/tests/")) {
                        if (absolutePath.endsWith("/dependencies")) {
                            File[] dependenciesFiles;
                            File dirFile = dirPath.toFile();
                            for (File dependenciesFile : dependenciesFiles = dirFile.listFiles(new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    return file.isFile();
                                }
                            })) {
                                _dependenciesFileLocationsMap.put(SourceUtil.getAbsolutePath(dependenciesFile.getPath()), new TreeSet());
                            }
                        }
                        if (absolutePath.matches(".+/dependencies/.+\\..+")) {
                            _dependenciesFileLocationsMap.put(SourceUtil.getAbsolutePath(absolutePath), new TreeSet());
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private synchronized void _getTestCaseFileNames() throws IOException {
        if (!_testCaseFileNames.isEmpty()) {
            return;
        }
        for (String testCaseFileLocation : _TEST_FILE_LOCATIONS) {
            File directory = new File(this.getPortalDir(), testCaseFileLocation);
            Path dirPath = directory.toPath();
            Files.walkFileTree(dirPath, EnumSet.noneOf(FileVisitOption.class), 25, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                    File[] testcaseFiles;
                    if (ArrayUtil.contains(_SKIP_DIR_NAMES, String.valueOf(dirPath.getFileName()))) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    String absolutePath = SourceUtil.getAbsolutePath(dirPath);
                    if (!absolutePath.contains("portal-web") && !absolutePath.matches(".+/modules/.+-test/src/testFunctional(/.*)?")) {
                        return FileVisitResult.CONTINUE;
                    }
                    File dirFile = dirPath.toFile();
                    for (File testcaseFile : testcaseFiles = dirFile.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            if (!file.isFile()) {
                                return false;
                            }
                            String fileName = file.getName();
                            return fileName.endsWith(".testcase");
                        }
                    })) {
                        _testCaseFileNames.add(SourceUtil.getAbsolutePath(testcaseFile.getPath()));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private synchronized void _getTestCaseGlobalDependenciesFileLocations() throws IOException {
        if (!_dependenciesGlobalFileLocationsMap.isEmpty()) {
            return;
        }
        File directory = new File(this.getPortalDir(), _GLOBAL_DEPENDENCIES_DIRECTORY);
        Path dirPath = directory.toPath();
        Files.walkFileTree(dirPath, EnumSet.noneOf(FileVisitOption.class), 25, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                File[] dependenciesFiles;
                if (ArrayUtil.contains(_SKIP_DIR_NAMES, String.valueOf(dirPath.getFileName()))) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String absolutePath = SourceUtil.getAbsolutePath(dirPath);
                if (absolutePath.matches(".+/dependencies/.+\\..+")) {
                    _dependenciesGlobalFileLocationsMap.put(SourceUtil.getAbsolutePath(absolutePath), new TreeSet());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                File dirFile = dirPath.toFile();
                for (File dependenciesFile : dependenciesFiles = dirFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile();
                    }
                })) {
                    _dependenciesGlobalFileLocationsMap.put(SourceUtil.getAbsolutePath(dependenciesFile.getPath()), new TreeSet());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static {
        _dependenciesGlobalFileLocationsMap = new HashMap<String, Set<String>>();
        _testCaseFileNames = new ArrayList<String>();
    }
}

