/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassType {
    private static final Pattern _fullyQualifiedNamePattern = Pattern.compile("^([a-z]\\w*\\.){2,}([A-Z].*)");
    private int _arrayDimension;
    private JavaClassType _extendedClassType;
    private final List<JavaClassType> _genericClassTypes = new ArrayList<JavaClassType>();
    private String _name;
    private String _packageName;
    private JavaClassType _superClassType;
    private boolean _varargs;

    public JavaClassType(String type, String classPackageName, List<String> importNames) {
        this._parseJavaClassType(type, classPackageName, importNames);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean fullyQualifiedName) {
        StringBundler sb = new StringBundler();
        if (fullyQualifiedName && Validator.isNotNull(this._packageName)) {
            sb.append(this._packageName);
            sb.append(".");
        }
        sb.append(this._name);
        if (this._extendedClassType != null) {
            sb.append(" extends ");
            sb.append(this._extendedClassType.toString(fullyQualifiedName));
            return sb.toString();
        }
        if (this._superClassType != null) {
            sb.append(" super ");
            sb.append(this._superClassType.toString(fullyQualifiedName));
            return sb.toString();
        }
        if (!this._genericClassTypes.isEmpty()) {
            sb.append("<");
            for (JavaClassType genericClassType : this._genericClassTypes) {
                sb.append(genericClassType.toString(fullyQualifiedName));
                sb.append(", ");
            }
            sb.setIndex(sb.index() - 1);
            sb.append(">");
        }
        for (int i = 0; i < this._arrayDimension; ++i) {
            sb.append("[]");
        }
        if (this._varargs) {
            sb.append("...");
        }
        return sb.toString();
    }

    private void _parseGenericClassTypes(String genericTypesString, String classPackageName, List<String> importNames) {
        int x = -1;
        while (true) {
            if ((x = genericTypesString.indexOf(",", x + 1)) == -1) {
                this._genericClassTypes.add(new JavaClassType(genericTypesString, classPackageName, importNames));
                return;
            }
            String genericType = genericTypesString.substring(0, x);
            if (ToolsUtil.getLevel(genericType, "<", ">") != 0) continue;
            this._genericClassTypes.add(new JavaClassType(genericType, classPackageName, importNames));
            genericTypesString = genericTypesString.substring(x + 1);
            x = -1;
        }
    }

    private void _parseJavaClassType(String type, String classPackageName, List<String> importNames) {
        int x;
        type = StringUtil.trim(type);
        type = type.replaceAll("\\.\n", ".");
        type = type.replaceAll("\n", " ");
        if ((type = type.replaceAll("\t+ *", "")).startsWith("? extends ")) {
            this._name = "?";
            this._extendedClassType = new JavaClassType(type.substring(10), classPackageName, importNames);
            return;
        }
        if (type.startsWith("? super ")) {
            this._name = "?";
            this._superClassType = new JavaClassType(type.substring(8), classPackageName, importNames);
            return;
        }
        Matcher matcher = _fullyQualifiedNamePattern.matcher(type);
        if (matcher.find()) {
            this._packageName = type.substring(0, matcher.end(1) - 1);
            type = StringUtil.trim(matcher.group(2));
        }
        if ((x = type.indexOf("<")) != -1) {
            int y = type.lastIndexOf(">");
            if (y == -1) {
                return;
            }
            this._parseGenericClassTypes(type.substring(x + 1, y), classPackageName, importNames);
            type = type.substring(0, x) + type.substring(y + 1);
        }
        if (type.endsWith("...")) {
            this._varargs = true;
            type = StringUtil.trim(type.substring(0, type.length() - 3));
        }
        while (type.endsWith("[]")) {
            ++this._arrayDimension;
            type = StringUtil.trim(type.substring(0, type.length() - 2));
        }
        this._name = type;
        if (this._packageName == null) {
            this._packageName = JavaSourceUtil.getPackageName(this._name, classPackageName, importNames);
        }
    }
}

