/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class JavaMissingOverrideCheck
extends BaseJavaTermCheck {
    private JSONObject _javaClassesJSONObject;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        JavaClass javaClass = (JavaClass)javaTerm;
        if (javaClass.hasAnnotation("Deprecated") || javaClass.getParentJavaClass() != null) {
            return javaClass.getContent();
        }
        TreeSet<JavaTerm> javaMethods = new TreeSet<JavaTerm>(new Comparator<JavaTerm>(){

            @Override
            public int compare(JavaTerm javaTerm1, JavaTerm javaTerm2) {
                return javaTerm2.getLineNumber() - javaTerm1.getLineNumber();
            }
        });
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod() || childJavaTerm.isStatic() || childJavaTerm.hasAnnotation("Deprecated", "Override") || Objects.equals(childJavaTerm.getName(), "main") || !this._hasSuperMethod((JavaMethod)childJavaTerm, javaClass.getName(true), false)) continue;
            javaMethods.add((JavaMethod)childJavaTerm);
        }
        return this._fixMissingOverrideAnnotations(javaClass, javaMethods);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private boolean _equals(JavaMethod javaMethod, JSONObject methodJSONObject) {
        if (!Objects.equals(javaMethod.getAccessModifier(), methodJSONObject.getString("accessModifier")) || !Objects.equals(javaMethod.getName(), methodJSONObject.getString("name"))) {
            return false;
        }
        JavaSignature javaSignature = javaMethod.getSignature();
        if (!Objects.equals(javaSignature.getReturnType(true), methodJSONObject.getString("returnType"))) {
            return false;
        }
        List<JavaParameter> javaParameters = javaSignature.getParameters();
        JSONArray parametersJSONArray = methodJSONObject.getJSONArray("parameters");
        if (parametersJSONArray == null) {
            return javaParameters.isEmpty();
        }
        if (javaParameters.size() != parametersJSONArray.length()) {
            return false;
        }
        Iterator iterator = parametersJSONArray.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            JavaParameter javaParameter;
            if (Objects.equals((javaParameter = javaParameters.get(i++)).getParameterType(true), iterator.next())) continue;
            return false;
        }
        return true;
    }

    private String _fixMissingOverrideAnnotations(JavaClass javaClass, Set<JavaMethod> javaMethods) {
        String content = javaClass.getContent();
        block0: for (JavaMethod javaMethod : javaMethods) {
            int lineNumber = javaMethod.getLineNumber() - javaClass.getLineNumber();
            int i = lineNumber + 1;
            String line;
            while ((line = StringUtil.trim(this.getLine(content, i))) != null) {
                if (line.startsWith(javaMethod.getAccessModifier())) {
                    content = StringUtil.replaceFirst(content, line, "@Override\n" + line, this.getLineStartPos(content, lineNumber));
                    continue block0;
                }
                ++i;
            }
            return content;
        }
        return content;
    }

    private synchronized JSONObject _getJavaClassesJSONObject() throws Exception {
        if (this._javaClassesJSONObject != null) {
            return this._javaClassesJSONObject;
        }
        JSONObject portalJSONObject = SourceFormatterUtil.getPortalJSONObject(this.getBaseDirName(), this.getSourceFormatterExcludes(), this.getMaxLineLength());
        this._javaClassesJSONObject = portalJSONObject.getJSONObject("javaClasses");
        return this._javaClassesJSONObject;
    }

    private boolean _hasMethod(JSONObject classJSONObject, JavaMethod javaMethod) {
        JSONArray methodsJSONArray = classJSONObject.getJSONArray("methods");
        if (methodsJSONArray == null) {
            return false;
        }
        Iterator iterator = methodsJSONArray.iterator();
        while (iterator.hasNext()) {
            if (!this._equals(javaMethod, (JSONObject)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean _hasSuperMethod(JavaMethod javaMethod, JSONArray classNamesJSONArray) throws Exception {
        if (classNamesJSONArray == null) {
            return false;
        }
        Iterator iterator = classNamesJSONArray.iterator();
        while (iterator.hasNext()) {
            if (!this._hasSuperMethod(javaMethod, (String)iterator.next(), true)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasSuperMethod(JavaMethod javaMethod, String className, boolean superClass) throws Exception {
        JSONObject javaClassesJSONObject = this._getJavaClassesJSONObject();
        JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(className);
        if (classJSONObject == null) {
            return false;
        }
        return superClass && this._hasMethod(classJSONObject, javaMethod) || this._hasSuperMethod(javaMethod, classJSONObject.getJSONArray("extendedClassNames")) || this._hasSuperMethod(javaMethod, classJSONObject.getJSONArray("implementedClassNames"));
    }
}

