/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final char[] _RANDOM_STRING_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public static String add(String s, String add) {
        return StringUtil.add(s, add, ",");
    }

    public static String add(String s, String add, String delimiter) {
        return StringUtil.add(s, add, delimiter, false);
    }

    public static String add(String s, String add, String delimiter, boolean allowDuplicates) {
        if (add == null || delimiter == null) {
            return null;
        }
        if (s == null) {
            s = "";
        }
        if (allowDuplicates || !StringUtil.contains(s, add, delimiter)) {
            StringBuilder sb = new StringBuilder(4);
            sb.append(s);
            if (Validator.isNull(s) || s.endsWith(delimiter)) {
                sb.append(add);
                sb.append(delimiter);
            } else {
                sb.append(delimiter);
                sb.append(add);
                sb.append(delimiter);
            }
            s = sb.toString();
        }
        return s;
    }

    public static String combine(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static boolean contains(String s, String text) {
        return StringUtil.contains(s, text, ",");
    }

    public static boolean contains(String s, String text, String delimiter) {
        String dtd;
        int pos;
        if (s == null || text == null || delimiter == null) {
            return false;
        }
        if (!s.endsWith(delimiter)) {
            s = s.concat(delimiter);
        }
        if ((pos = s.indexOf(dtd = StringUtil.combine(delimiter, text, delimiter))) == -1) {
            String td = text.concat(delimiter);
            return s.startsWith(td);
        }
        return true;
    }

    public static int count(String s, String text) {
        return StringUtil.count(s, text, s.length());
    }

    public static int count(String s, String text, int index) {
        if (s == null || s.length() == 0 || text == null || text.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = s.indexOf(text);
        while (pos != -1 && pos < index) {
            pos = s.indexOf(text, pos + text.length());
            ++count;
        }
        return count;
    }

    public static int countStartingNewLines(String s) {
        String[] snippets = s.split("\n\\h*", -1);
        if (snippets.length == 1) {
            return 0;
        }
        for (int i = 0; i < snippets.length; ++i) {
            String snippet = snippets[i];
            if (snippet.isEmpty()) continue;
            return i;
        }
        return snippets.length - 1;
    }

    public static boolean endsWith(String s, String end) {
        if (s == null || end == null || end.length() > s.length()) {
            return false;
        }
        String temp = s.substring(s.length() - end.length());
        return StringUtil.equalsIgnoreCase(temp, end);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        for (int i = 0; i < s1.length(); ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            if (c1 > '\u007f' || c2 > '\u007f') {
                if (Character.toLowerCase(c1) == Character.toLowerCase(c2) || Character.toUpperCase(c1) == Character.toUpperCase(c2)) continue;
                return false;
            }
            int delta = c1 - c2;
            if (delta == 32 || delta == -32) continue;
            return false;
        }
        return true;
    }

    public static String extractChars(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String extractFirst(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(0, index);
    }

    public static String extractLast(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(delimiter);
        if (index < 0) {
            return null;
        }
        return s.substring(index + delimiter.length());
    }

    public static String extractLeadingDigits(String s) {
        char[] chars;
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (char c : chars = s.toCharArray()) {
            if (!Validator.isDigit(c)) {
                return sb.toString();
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isLowerCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'A' && c <= 'Z' : Character.isLetter(c) && Character.isUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!(c <= '\u007f' ? c >= 'a' && c <= 'z' : Character.isLetter(c) && Character.isLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public static String join(String[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        boolean start = true;
        for (String string : array) {
            if (!start) {
                sb.append(delimiter);
            }
            sb.append(string);
            start = false;
        }
        return sb.toString();
    }

    public static int length(String s) {
        return s.length();
    }

    public static String lowerCase(String s) {
        return StringUtil.toLowerCase(s);
    }

    public static void lowerCase(String ... array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                array[i] = StringUtil.toLowerCase(array[i]);
            }
        }
    }

    public static String lowerCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'A' && chars[0] <= 'Z') {
            chars[0] = (char)(chars[0] + 32);
        }
        return new String(chars);
    }

    public static boolean matches(String s, String pattern) {
        return s.matches(pattern);
    }

    public static List<String> partition(String s, String[] delimiters) {
        ArrayList<Integer> delimiterIndexes = new ArrayList<Integer>();
        for (String delimiter : delimiters) {
            int index = s.indexOf(delimiter);
            while (index >= 0) {
                delimiterIndexes.add(index);
                index = s.indexOf(delimiter, index + 1);
            }
        }
        if (!delimiterIndexes.contains(0)) {
            delimiterIndexes.add(0);
        }
        if (!delimiterIndexes.contains(s.length())) {
            delimiterIndexes.add(s.length());
        }
        Collections.sort(delimiterIndexes);
        ArrayList<String> substrings = new ArrayList<String>();
        for (int i = 0; i < delimiterIndexes.size(); ++i) {
            if (i + 1 == delimiterIndexes.size()) continue;
            String substring = s.substring((Integer)delimiterIndexes.get(i), (Integer)delimiterIndexes.get(i + 1));
            substrings.add(substring);
        }
        return substrings;
    }

    public static String quote(String s, String quote) {
        if (s == null) {
            return null;
        }
        return StringUtil.combine(quote, s, quote);
    }

    public static String randomString(String lengthString) {
        int length = GetterUtil.getInteger(lengthString);
        Random random = new Random();
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(_RANDOM_STRING_CHAR_TABLE.length);
            chars[i] = _RANDOM_STRING_CHAR_TABLE[index];
        }
        return new String(chars);
    }

    public static String regexReplaceAll(String s, String regex, String replacement) {
        return s.replaceAll(regex, replacement);
    }

    public static String regexReplaceFirst(String s, String regex, String replacement) {
        return s.replaceFirst(regex, replacement);
    }

    public static String removeSpaces(String s) {
        return s.replaceAll(" ", "");
    }

    public static String replace(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return s.replace(oldSub, newSub);
    }

    public static String replace(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        int index = s.indexOf(oldSub);
        if (index == -1) {
            return s;
        }
        int previousIndex = index;
        StringBuilder sb = new StringBuilder();
        if (previousIndex != 0) {
            sb.append(s.substring(0, previousIndex));
        }
        sb.append(newSub);
        while ((index = s.indexOf(oldSub, previousIndex + 1)) != -1) {
            sb.append(s.substring(previousIndex + 1, index));
            sb.append(newSub);
            previousIndex = index;
        }
        index = previousIndex + 1;
        if (index < s.length()) {
            sb.append(s.substring(index));
        }
        return sb.toString();
    }

    public static String replace(String s, char[] oldSubs, char[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        sb.append(s);
        boolean modified = false;
        block0: for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            for (int j = 0; j < oldSubs.length; ++j) {
                if (c != oldSubs[j]) continue;
                sb.setCharAt(i, newSubs[j]);
                modified = true;
                continue block0;
            }
        }
        if (modified) {
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, char[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        block0: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            for (int j = 0; j < oldSubs.length; ++j) {
                if (c != oldSubs[j]) continue;
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (i > lastReplacementIndex) {
                    sb.append(s.substring(lastReplacementIndex, i));
                }
                sb.append(newSubs[j]);
                lastReplacementIndex = i + 1;
                continue block0;
            }
        }
        if (sb == null) {
            return s;
        }
        if (lastReplacementIndex < s.length()) {
            sb.append(s.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    public static String replace(String s, String oldSub, String newSub) {
        return StringUtil.replace(s, oldSub, newSub, 0);
    }

    public static String replace(String s, String oldSub, String newSub, int fromIndex) {
        int y;
        if (s == null) {
            return null;
        }
        if (oldSub == null || oldSub.equals("")) {
            return s;
        }
        if (newSub == null) {
            newSub = "";
        }
        if ((y = s.indexOf(oldSub, fromIndex)) >= 0) {
            StringBuilder sb = new StringBuilder();
            int length = oldSub.length();
            int x = 0;
            while (x <= y) {
                sb.append(s.substring(x, y));
                sb.append(newSub);
                x = y + length;
                y = s.indexOf(oldSub, x);
            }
            sb.append(s.substring(x));
            return sb.toString();
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replace(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String replace(String s, String[] oldSubs, String[] newSubs, boolean exactMatch) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        if (!exactMatch) {
            return StringUtil.replace(s, oldSubs, newSubs);
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = s.replaceAll("\\b" + oldSubs[i] + "\\b", newSubs[i]);
        }
        return s;
    }

    public static String replaceFirst(String s, char oldSub, char newSub) {
        if (s == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), String.valueOf(newSub));
    }

    public static String replaceFirst(String s, char oldSub, String newSub) {
        if (s == null || newSub == null) {
            return null;
        }
        return StringUtil.replaceFirst(s, String.valueOf(oldSub), newSub);
    }

    public static String replaceFirst(String s, String oldSub, String newSub) {
        return StringUtil.replaceFirst(s, oldSub, newSub, 0);
    }

    public static String replaceFirst(String s, String oldSub, String newSub, int fromIndex) {
        if (s == null || oldSub == null || newSub == null) {
            return null;
        }
        if (oldSub.equals(newSub)) {
            return s;
        }
        int y = s.indexOf(oldSub, fromIndex);
        if (y >= 0) {
            return StringUtil.combine(s.substring(0, y), newSub, s.substring(y + oldSub.length()));
        }
        return s;
    }

    public static String replaceFirst(String s, String[] oldSubs, String[] newSubs) {
        if (s == null || oldSubs == null || newSubs == null) {
            return null;
        }
        if (oldSubs.length != newSubs.length) {
            return s;
        }
        for (int i = 0; i < oldSubs.length; ++i) {
            s = StringUtil.replaceFirst(s, oldSubs[i], newSubs[i]);
        }
        return s;
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        char[] chars = s.toCharArray();
        char[] reverse = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            reverse[i] = chars[chars.length - i - 1];
        }
        return new String(reverse);
    }

    public static String[] split(String s) {
        return StringUtil.split(s, ",");
    }

    public static String[] split(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        return s.split(delimiter);
    }

    public static List<String> split(String s, String[] delimiters) {
        HashSet<Integer> splitIndexSet = new HashSet<Integer>();
        splitIndexSet.add(0);
        splitIndexSet.add(s.length());
        List<String> delimiterList = Arrays.asList(StringUtil._removeDuplicates(delimiters));
        for (String delimiter : delimiterList) {
            int index = s.indexOf(delimiter);
            while (index >= 0) {
                splitIndexSet.add(index);
                index = s.indexOf(delimiter, index + 1);
            }
        }
        Object[] splitIndexArray = splitIndexSet.toArray(new Integer[0]);
        Arrays.sort(splitIndexArray);
        ArrayList<String> substrings = new ArrayList<String>();
        for (int i = 0; i < splitIndexArray.length; ++i) {
            if (i + 1 == splitIndexArray.length) continue;
            String substring = s.substring((Integer)splitIndexArray[i], (Integer)splitIndexArray[i + 1]);
            if (delimiterList.contains(substring = substring.trim())) continue;
            substrings.add(substring);
        }
        return substrings;
    }

    public static boolean startsWith(String s, String start) {
        if (s == null || start == null || start.length() > s.length()) {
            return false;
        }
        String temp = s.substring(0, start.length());
        return StringUtil.equalsIgnoreCase(temp, start);
    }

    public static String stripBetween(String s, String begin, String end) {
        if (Validator.isBlank(s) || Validator.isBlank(begin) || Validator.isBlank(end)) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int pos = 0;
        while (true) {
            int x = s.indexOf(begin, pos);
            int y = s.indexOf(end, x + begin.length());
            if (x == -1 || y == -1) break;
            sb.append(s.substring(pos, x));
            pos = y + end.length();
        }
        sb.append(s.substring(pos));
        return sb.toString();
    }

    public static String substring(String s, String startIndex, String endIndex) {
        if (s == null) {
            return "";
        }
        try {
            return s.substring(Integer.parseInt(startIndex), Integer.parseInt(endIndex));
        }
        catch (IndexOutOfBoundsException | NumberFormatException exception) {
            exception.printStackTrace();
            return s;
        }
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.lowerCase((String)s);
    }

    public static String toUpperCase(String s) {
        if (s == null) {
            return null;
        }
        return StringUtils.upperCase((String)s);
    }

    public static String trim(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        int y = x + 1;
        for (int i = len - 1; i > x; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            y = i + 1;
            break;
        }
        if (x == 0 && y == len) {
            return s;
        }
        return s.substring(x, y);
    }

    public static String trimLeading(String s) {
        int len;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int x = len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i;
            break;
        }
        if (x == len) {
            return "";
        }
        if (x == 0) {
            return s;
        }
        return s.substring(x);
    }

    public static String trimTrailing(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return s;
        }
        int len = s.length();
        int x = 0;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            x = i + 1;
            break;
        }
        if (x == 0) {
            return "";
        }
        if (x == len) {
            return s;
        }
        return s.substring(0, x);
    }

    public static String unquote(String s) {
        if (Validator.isNull(s)) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String upperCase(String s) {
        return StringUtil.toUpperCase(s);
    }

    public static String upperCaseFirstLetter(String s) {
        char[] chars = s.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }

    public static String valueOf(Object object) {
        return String.valueOf(object);
    }

    private static String[] _removeDuplicates(String[] stringArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : stringArray) {
            if (stringList.contains(string)) continue;
            stringList.add(string);
        }
        return stringList.toArray(new String[0]);
    }
}

