/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.source.formatter.checkstyle.checks.BaseAPICheck;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeprecatedAPICheck
extends BaseAPICheck {
    private static final String _MSG_DEPRECATED_CONSTRUCTOR_CALL = "constructor.call.deprecated";
    private static final String _MSG_DEPRECATED_FIELD_CALL = "field.call.deprecated";
    private static final String _MSG_DEPRECATED_METHOD_CALL = "method.call.deprecated";
    private static final String _MSG_DEPRECATED_TYPE_CALL = "type.call.deprecated";
    private JSONObject _javaClassesJSONObject;

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        try {
            JSONObject javaClassesJSONObject = this._getJavaClassesJSONObject();
            List<String> deprecatedImportNames = this._getDeprecatedImportNames(detailAST, javaClassesJSONObject);
            this._checkDeprecatedConstructors(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedMethods(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedTypes(detailAST, deprecatedImportNames, javaClassesJSONObject);
            this._checkDeprecatedVariables(detailAST, deprecatedImportNames, javaClassesJSONObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _checkDeprecatedConstructors(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.ConstructorCall> constructorCalls = this.getConstructorCalls(detailAST, deprecatedImportNames, true);
        block0: for (BaseAPICheck.ConstructorCall constructorCall : constructorCalls) {
            List<JSONObject> constructorJSONObjects = this.getConstructorJSONObjects(constructorCall, javaClassesJSONObject);
            if (constructorJSONObjects.isEmpty()) continue;
            for (JSONObject constructorJSONObject : constructorJSONObjects) {
                if (constructorJSONObject.has("deprecated")) continue;
                continue block0;
            }
            this.log(constructorCall.getLineNumber(), _MSG_DEPRECATED_CONSTRUCTOR_CALL, new Object[]{constructorCall.getTypeName()});
        }
    }

    private void _checkDeprecatedMethods(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.MethodCall> methodCalls = this.getMethodCalls(detailAST, deprecatedImportNames, true);
        block0: for (BaseAPICheck.MethodCall methodCall : methodCalls) {
            List<JSONObject> methodJSONObjects = this.getMethodJSONObjects(methodCall, javaClassesJSONObject);
            if (methodJSONObjects.isEmpty()) continue;
            for (JSONObject methodJSONObject : methodJSONObjects) {
                if (methodJSONObject.has("deprecated")) continue;
                continue block0;
            }
            this.log(methodCall.getLineNumber(), _MSG_DEPRECATED_METHOD_CALL, new Object[]{methodCall.getName()});
        }
    }

    private void _checkDeprecatedTypes(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        Map<String, Set<Integer>> typeNamesMap = this.getTypeNamesMap(detailAST, deprecatedImportNames, true);
        for (Map.Entry<String, Set<Integer>> entry : typeNamesMap.entrySet()) {
            String typeName = entry.getKey();
            JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(typeName);
            if (classJSONObject == null || !classJSONObject.has("deprecated")) continue;
            Set<Integer> lineNumbers = entry.getValue();
            for (int lineNumber : lineNumbers) {
                this.log(lineNumber, _MSG_DEPRECATED_TYPE_CALL, new Object[]{typeName});
            }
        }
    }

    private void _checkDeprecatedVariables(DetailAST detailAST, List<String> deprecatedImportNames, JSONObject javaClassesJSONObject) {
        List<BaseAPICheck.VariableCall> variableCalls = this.getVariableCalls(detailAST, deprecatedImportNames, true);
        for (BaseAPICheck.VariableCall variableCall : variableCalls) {
            JSONObject variableJSONObject = this.getVariableJSONObject(variableCall, javaClassesJSONObject);
            if (variableJSONObject == null || !variableJSONObject.has("deprecated")) continue;
            this.log(variableCall.getLineNumber(), _MSG_DEPRECATED_FIELD_CALL, new Object[]{variableCall.getName()});
        }
    }

    private List<String> _getDeprecatedImportNames(DetailAST detailAST, JSONObject javaClassesJSONObject) {
        ArrayList<String> deprecatedImportNames = new ArrayList<String>();
        List<String> importNames = this.getImportNames(detailAST);
        for (String importName : importNames) {
            JSONObject classJSONObject = javaClassesJSONObject.getJSONObject(importName);
            if (classJSONObject == null || !classJSONObject.has("deprecated")) continue;
            this.log(detailAST, _MSG_DEPRECATED_TYPE_CALL, new Object[]{importName});
            deprecatedImportNames.add(importName);
        }
        return deprecatedImportNames;
    }

    private synchronized JSONObject _getJavaClassesJSONObject() throws Exception {
        if (this._javaClassesJSONObject != null) {
            return this._javaClassesJSONObject;
        }
        JSONObject portalJSONObject = SourceFormatterUtil.getPortalJSONObject(this.getBaseDirName());
        this._javaClassesJSONObject = portalJSONObject.getJSONObject("javaClasses");
        return this._javaClassesJSONObject;
    }
}

