/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UpgradeRemovedAPICheck
extends BaseCheck {
    private static final String _MSG_CLASS_NOT_FOUND = "class.not.found";
    private static final String _MSG_METHOD_NOT_FOUND = "method.not.found";
    private static final String _MSG_VARIABLE_NOT_FOUND = "variable.not.found";
    private final Map<String, JSONObject> _javaClassesJSONObjectMap = new HashMap<String, JSONObject>();

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String upgradeFromVersion = this.getAttributeValue("upgrade.from.version");
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version");
        try {
            JSONObject upgradeFromJavaClassesJSONObject = this._getJavaClassesJSONObject(upgradeFromVersion);
            JSONObject upgradeToJavaClassesJSONObject = this._getJavaClassesJSONObject(upgradeToVersion);
            List<String> removedImportNames = this._getRemovedImportNames(detailAST, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedMethods(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedTypes(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedVariables(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, Set<Integer>> _addTypeName(Map<String, Set<Integer>> typeNamesMap, String typeName, int lineNumber) {
        Set<Integer> lineNumbers = typeNamesMap.get(typeName);
        if (lineNumbers == null) {
            lineNumbers = new HashSet<Integer>();
        }
        lineNumbers.add(lineNumber);
        typeNamesMap.put(typeName, lineNumbers);
        return typeNamesMap;
    }

    private void _checkRemovedMethods(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<String> parameterTypes;
            String methodName;
            MethodStatus upgradeFromMethodStatus;
            String variableTypeName;
            DetailAST dotDetailAST = methodCallDetailAST.getFirstChild();
            if (dotDetailAST.getType() != 59) continue;
            DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
            DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
            if (firstChildDetailAST.getType() != 58 || lastChildDetailAST.getType() != 58 || !(variableTypeName = this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, false, true)).startsWith("com.liferay.") || removedImportNames.contains(variableTypeName) || !(upgradeFromMethodStatus = this._getMethodStatus(upgradeFromJavaClassesJSONObject, variableTypeName, methodName = lastChildDetailAST.getText(), parameterTypes = this._getParameterTypes(methodCallDetailAST))).equals((Object)MethodStatus.METHOD_FOUND)) continue;
            MethodStatus upgradeToMethodStatus = this._getMethodStatus(upgradeToJavaClassesJSONObject, variableTypeName, methodName, parameterTypes);
            if (upgradeToMethodStatus.equals((Object)MethodStatus.NO_CLASS_FOUND)) {
                this.log(methodCallDetailAST, _MSG_CLASS_NOT_FOUND, new Object[]{variableTypeName, upgradeToVersion});
                continue;
            }
            if (!upgradeToMethodStatus.equals((Object)MethodStatus.NO_METHOD_FOUND)) continue;
            this.log(methodCallDetailAST, _MSG_METHOD_NOT_FOUND, new Object[]{methodName, variableTypeName, upgradeToVersion});
        }
    }

    private void _checkRemovedTypes(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        Map<String, Set<Integer>> typeNamesMap = this._getTypeNamesMap(detailAST);
        for (Map.Entry<String, Set<Integer>> entry : typeNamesMap.entrySet()) {
            String typeName = entry.getKey();
            if (!typeName.startsWith("com.liferay.") || removedImportNames.contains(typeName)) continue;
            JSONObject upgradeFromClassJSONObject = upgradeFromJavaClassesJSONObject.getJSONObject(typeName);
            JSONObject upgradeToClassJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(typeName);
            if (upgradeFromClassJSONObject == null || upgradeToClassJSONObject != null) continue;
            Set<Integer> lineNumbers = entry.getValue();
            for (int lineNumber : lineNumbers) {
                this.log(lineNumber, _MSG_CLASS_NOT_FOUND, new Object[]{typeName, upgradeToVersion});
            }
        }
    }

    private void _checkRemovedVariables(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<DetailAST> dotDetailASTList = this.getAllChildTokens(detailAST, true, 59);
        for (DetailAST dotDetailAST : dotDetailASTList) {
            String variableName;
            VariableStatus upgradeFromVariableStatus;
            String variableTypeName;
            DetailAST firstChildDetailAST = dotDetailAST.getFirstChild();
            DetailAST lastChildDetailAST = dotDetailAST.getLastChild();
            if (firstChildDetailAST.getType() != 58 || lastChildDetailAST.getType() != 58 || !(variableTypeName = this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, false, true)).startsWith("com.liferay.") || removedImportNames.contains(variableTypeName) || !(upgradeFromVariableStatus = this._getVariableStatus(upgradeFromJavaClassesJSONObject, variableTypeName, variableName = lastChildDetailAST.getText())).equals((Object)VariableStatus.VARIABLE_FOUND)) continue;
            VariableStatus upgradeToVariableStatus = this._getVariableStatus(upgradeToJavaClassesJSONObject, variableTypeName, variableName);
            if (upgradeToVariableStatus.equals((Object)VariableStatus.NO_CLASS_FOUND)) {
                this.log(lastChildDetailAST, _MSG_CLASS_NOT_FOUND, new Object[]{variableTypeName, upgradeToVersion});
                continue;
            }
            if (!upgradeToVariableStatus.equals((Object)VariableStatus.NO_VARIABLE_FOUND)) continue;
            this.log(lastChildDetailAST, _MSG_VARIABLE_NOT_FOUND, new Object[]{variableName, variableTypeName, upgradeToVersion});
        }
    }

    private synchronized JSONObject _getJavaClassesJSONObject(String version) throws Exception {
        JSONObject javaClassesJSONObject = this._javaClassesJSONObjectMap.get(version);
        if (javaClassesJSONObject != null) {
            return javaClassesJSONObject;
        }
        JSONObject portalJSONObject = SourceFormatterUtil.getPortalJSONObjectByVersion(version);
        javaClassesJSONObject = portalJSONObject.has("javaClasses") ? portalJSONObject.getJSONObject("javaClasses") : new JSONObjectImpl();
        this._javaClassesJSONObjectMap.put(version, javaClassesJSONObject);
        return javaClassesJSONObject;
    }

    private MethodStatus _getMethodStatus(JSONObject jsonObject, String fullyQualifiedClassName, String methodName, List<String> parameterTypes) {
        JSONArray extendedClassNamesJSONArray;
        JSONObject classJSONObject = jsonObject.getJSONObject(fullyQualifiedClassName);
        if (classJSONObject == null) {
            return MethodStatus.NO_CLASS_FOUND;
        }
        JSONArray methodsJSONArray = classJSONObject.getJSONArray("methods");
        if (methodsJSONArray != null) {
            block0: for (JSONObject methodJSONObject : methodsJSONArray) {
                if (!methodName.equals(methodJSONObject.getString("name"))) continue;
                JSONArray parametersJSONArray = methodJSONObject.getJSONArray("parameters");
                if (parametersJSONArray == null) {
                    if (!parameterTypes.isEmpty()) continue;
                    return MethodStatus.METHOD_FOUND;
                }
                if (parametersJSONArray.length() != parameterTypes.size()) continue;
                for (int i = 0; i < parameterTypes.size(); ++i) {
                    String methodType;
                    String actualType = parameterTypes.get(i);
                    if (!StringUtil.equalsIgnoreCase(actualType, methodType = parametersJSONArray.getString(i)) && !methodType.equals("Object")) continue block0;
                }
                return MethodStatus.METHOD_FOUND;
            }
        }
        if ((extendedClassNamesJSONArray = classJSONObject.getJSONArray("extendedClassNames")) != null) {
            for (String extendedClassName : extendedClassNamesJSONArray) {
                if (extendedClassName.startsWith("com.liferay.") || !Objects.equals((Object)this._getMethodStatus(jsonObject, extendedClassName, methodName, parameterTypes), (Object)MethodStatus.METHOD_FOUND)) continue;
                return MethodStatus.METHOD_FOUND;
            }
        }
        return MethodStatus.NO_METHOD_FOUND;
    }

    private String _getParameterType(DetailAST detailAST) {
        if (detailAST.getType() == 58) {
            return this.getVariableTypeName(detailAST, detailAST.getText(), true, true, true);
        }
        if (detailAST.getType() == 139) {
            return "java.lang.String";
        }
        if (detailAST.getType() == 138) {
            return "char";
        }
        if (detailAST.getType() == 134 || detailAST.getType() == 133 || detailAST.getType() == 132) {
            return "boolean";
        }
        if (detailAST.getType() == 125) {
            DetailAST stringLiteralDetailAST = detailAST.findFirstToken(139);
            if (stringLiteralDetailAST != null) {
                return "java.lang.String";
            }
            return null;
        }
        if (detailAST.getType() == 136) {
            String parameterType = null;
            DetailAST firstChildDetailAST = detailAST.getFirstChild();
            parameterType = firstChildDetailAST.getType() == 58 ? firstChildDetailAST.getText() : this._getParameterType(firstChildDetailAST);
            if (parameterType == null) {
                return parameterType;
            }
            DetailAST curDetailAST = firstChildDetailAST.getNextSibling();
            while (true) {
                if (curDetailAST.getType() != 17) {
                    return parameterType;
                }
                parameterType = parameterType + "[]";
                curDetailAST = curDetailAST.getFirstChild();
            }
        }
        if (detailAST.getType() == 24) {
            String parameterType = this._getParameterType(detailAST.getFirstChild());
            if (parameterType != null) {
                parameterType = StringUtil.replaceLast(parameterType, "[]", "");
            }
            return parameterType;
        }
        if (detailAST.getType() == 23) {
            return this.getTypeName(detailAST, true, true, true);
        }
        if (ArrayUtil.contains(UNARY_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return this._getParameterType(detailAST.getFirstChild());
        }
        if (detailAST.getType() == 78) {
            DetailAST parentDetailAST = this.getParentWithTokenType(detailAST, 14);
            if (parentDetailAST == null) {
                return null;
            }
            DetailAST identDetailAST = parentDetailAST.findFirstToken(58);
            return identDetailAST.getText();
        }
        if (ArrayUtil.contains(CONDITIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType()) || ArrayUtil.contains(RELATIONAL_OPERATOR_TOKEN_TYPES, detailAST.getType())) {
            return "boolean";
        }
        if (detailAST.getType() == 142) {
            return "double";
        }
        if (detailAST.getType() == 140) {
            return "float";
        }
        if (detailAST.getType() == 141) {
            return "long";
        }
        if (detailAST.getType() == 137) {
            return "int";
        }
        if (detailAST.getType() == 50 || detailAST.getType() == 51 || detailAST.getType() == 57 || detailAST.getType() == 55 || detailAST.getType() == 54 || detailAST.getType() == 56 || detailAST.getType() == 53) {
            return detailAST.getText();
        }
        if (detailAST.getType() == 109) {
            return this._getParameterType(detailAST.getLastChild());
        }
        return null;
    }

    private List<String> _getParameterTypes(DetailAST detailAST) {
        ArrayList<String> parameterTypes = new ArrayList<String>();
        DetailAST elistDetailAST = detailAST.findFirstToken(34);
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
        for (DetailAST exprDetailAST : exprDetailASTList) {
            parameterTypes.add(this._getParameterType(exprDetailAST.getFirstChild()));
        }
        return parameterTypes;
    }

    private List<String> _getRemovedImportNames(DetailAST detailAST, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        ArrayList<String> removedImportNames = new ArrayList<String>();
        List<String> importNames = this.getImportNames(detailAST);
        for (String importName : importNames) {
            JSONObject upgradeFromClassJSONObject = upgradeFromJavaClassesJSONObject.getJSONObject(importName);
            JSONObject upgradeToClassJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(importName);
            if (upgradeFromClassJSONObject == null || upgradeToClassJSONObject != null) continue;
            this.log(detailAST, _MSG_CLASS_NOT_FOUND, new Object[]{importName, upgradeToVersion});
            removedImportNames.add(importName);
        }
        return removedImportNames;
    }

    private Map<String, Set<Integer>> _getTypeNamesMap(DetailAST detailAST) {
        Map<String, Set<Integer>> typeNamesMap = new HashMap<String, Set<Integer>>();
        List<DetailAST> clauseDetailASTList = this.getAllChildTokens(detailAST, true, 18, 19);
        for (DetailAST clauseDetailAST : clauseDetailASTList) {
            List<DetailAST> childDetailASTList = this.getAllChildTokens(clauseDetailAST, false, 59, 58);
            for (DetailAST childDetailAST : childDetailASTList) {
                if (childDetailAST.getType() == 58) {
                    typeNamesMap = this._addTypeName(typeNamesMap, this.getVariableTypeName(childDetailAST, childDetailAST.getText(), false, false, true), childDetailAST.getLineNo());
                    continue;
                }
                DetailAST firstChildDetailAST = childDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 58) {
                    typeNamesMap = this._addTypeName(typeNamesMap, this.getVariableTypeName(firstChildDetailAST, firstChildDetailAST.getText(), false, false, true), firstChildDetailAST.getLineNo());
                    continue;
                }
                FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)childDetailAST);
                typeNamesMap = this._addTypeName(typeNamesMap, fullIdent.getText(), firstChildDetailAST.getLineNo());
            }
        }
        List<DetailAST> typeDetailASTList = this.getAllChildTokens(detailAST, true, 13);
        for (DetailAST typeDetailAST : typeDetailASTList) {
            typeNamesMap = this._addTypeName(typeNamesMap, this.getTypeName(typeDetailAST, false, false, true), typeDetailAST.getLineNo());
        }
        return typeNamesMap;
    }

    private VariableStatus _getVariableStatus(JSONObject jsonObject, String fullyQualifiedClassName, String variableName) {
        JSONObject classJSONObject = jsonObject.getJSONObject(fullyQualifiedClassName);
        if (classJSONObject == null) {
            return VariableStatus.NO_CLASS_FOUND;
        }
        JSONArray variablesJSONArray = classJSONObject.getJSONArray("variables");
        if (variablesJSONArray == null) {
            return VariableStatus.NO_VARIABLE_FOUND;
        }
        for (JSONObject variableJSONObject : variablesJSONArray) {
            if (!variableName.equals(variableJSONObject.getString("name"))) continue;
            return VariableStatus.VARIABLE_FOUND;
        }
        return VariableStatus.NO_VARIABLE_FOUND;
    }

    private static enum VariableStatus {
        NO_CLASS_FOUND,
        NO_VARIABLE_FOUND,
        VARIABLE_FOUND;

    }

    private static enum MethodStatus {
        METHOD_FOUND,
        NO_CLASS_FOUND,
        NO_METHOD_FOUND;

    }
}

