/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class ListUtil {
    public static void add(List<String> list, String item) {
        list.add(item);
    }

    public static <E> List<E> copy(List<? extends E> master) {
        if (master == null) {
            return null;
        }
        return new ArrayList<E>(master);
    }

    public static String get(List<String> list, int index) {
        return list.get(index);
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static List<String> newList() {
        return new ArrayList<String>();
    }

    public static List<String> newListFromString(String s) {
        return ListUtil.newListFromString(s, ",");
    }

    public static List<String> newListFromString(String s, String delimiter) {
        s = s.trim();
        if (delimiter.equals(",") && s.endsWith("]") && s.startsWith("[")) {
            try {
                JSONArray jsonArray = new JSONArray(s);
                ArrayList<String> list = new ArrayList<String>();
                if (jsonArray != null) {
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        list.add(jsonArray.getString(i));
                    }
                }
                return list;
            }
            catch (JSONException jsonArray) {
                // empty catch block
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String item : s.split(delimiter)) {
            list.add(item.trim());
        }
        return list;
    }

    public static void remove(List<String> list, String item) {
        list.remove(item);
    }

    public static <E> List<E> sort(List<E> list) {
        return ListUtil.sort(list, null);
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        list = ListUtil.copy(list);
        Collections.sort(list, comparator);
        return list;
    }

    public static String sort(String s) {
        return ListUtil.sort(s, ",");
    }

    public static String sort(String s, String delimiter) {
        List<String> list = Arrays.asList(s.split(delimiter));
        return ListUtil.toString(ListUtil.sort(list), delimiter);
    }

    public static String toString(List<?> list) {
        return ListUtil.toString(list, ",");
    }

    public static String toString(List<?> list, String delimiter) {
        if (ListUtil.isEmpty(list)) {
            return "";
        }
        StringBuilder sb = new StringBuilder(2 * list.size() - 1);
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (value != null) {
                sb.append(value);
            }
            if (i + 1 == list.size()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }
}

