/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.parser.BaseJavaTerm;
import com.liferay.source.formatter.parser.JavaClassType;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;

public class JavaClass
extends BaseJavaTerm {
    private final boolean _anonymous;
    private final List<JavaTerm> _childJavaTerms = new ArrayList<JavaTerm>();
    private final List<JavaClassType> _extendedClassTypes = new ArrayList<JavaClassType>();
    private final List<JavaClassType> _implementedClassTypes = new ArrayList<JavaClassType>();
    private List<String> _importNames = new ArrayList<String>();
    private final boolean _isInterface;
    private String _packageName;

    public JavaClass(String name, String content, String accessModifier, int lineNumber, boolean isAbstract, boolean isFinal, boolean isStatic, boolean isInterface, boolean anonymous) {
        super(name, content, accessModifier, lineNumber, isAbstract, isFinal, isStatic);
        this._isInterface = isInterface;
        this._anonymous = anonymous;
    }

    public void addChildJavaTerm(JavaTerm javaTerm) {
        javaTerm.setParentJavaClass(this);
        this._childJavaTerms.add(javaTerm);
    }

    public void addExtendedClassNames(String ... extendedClassNames) {
        for (String extendedClassName : extendedClassNames) {
            this._extendedClassTypes.add(new JavaClassType(StringUtil.trim(extendedClassName), this._packageName, this._importNames));
        }
    }

    public void addImplementedClassNames(String ... implementedClassNames) {
        for (String implementedClassName : implementedClassNames) {
            this._implementedClassTypes.add(new JavaClassType(StringUtil.trim(implementedClassName), this._packageName, this._importNames));
        }
    }

    public void addImportName(String importName) {
        this._importNames.add(importName);
    }

    public List<JavaTerm> getChildJavaTerms() {
        return this._childJavaTerms;
    }

    public List<String> getExtendedClassNames() {
        return this.getExtendedClassNames(false);
    }

    public List<String> getExtendedClassNames(boolean fullyQualifiedName) {
        ArrayList<String> extendedClassNames = new ArrayList<String>();
        for (JavaClassType extendedClassType : this._extendedClassTypes) {
            extendedClassNames.add(extendedClassType.toString(fullyQualifiedName));
        }
        return extendedClassNames;
    }

    public List<String> getImplementedClassNames() {
        return this.getImplementedClassNames(false);
    }

    public List<String> getImplementedClassNames(boolean fullyQualifiedName) {
        ArrayList<String> implementedClassNames = new ArrayList<String>();
        for (JavaClassType implementedClassType : this._implementedClassTypes) {
            implementedClassNames.add(implementedClassType.toString(fullyQualifiedName));
        }
        return implementedClassNames;
    }

    public List<JavaClassType> getImplementedClassTypes() {
        return this._implementedClassTypes;
    }

    @Override
    public List<String> getImportNames() {
        return this._importNames;
    }

    public String getName(boolean fullyQualifiedClassName) {
        if (!fullyQualifiedClassName) {
            return this.getName();
        }
        return this._packageName + "." + this.getName();
    }

    @Override
    public String getPackageName() {
        return this._packageName;
    }

    public boolean isAnonymous() {
        return this._anonymous;
    }

    public boolean isInterface() {
        return this._isInterface;
    }

    public void setImportNames(List<String> importNames) {
        this._importNames = importNames;
    }

    public void setPackageName(String packageName) {
        this._packageName = packageName;
    }
}

