/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaParser;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class SourceUtil {
    private static final String[] _ARTICLES = new String[]{"a", "an", "the"};
    private static final String[] _CONJUNCTIONS = new String[]{"and", "but", "for", "nor", "or", "yet"};
    private static final String[] _PREPOSITIONS = new String[]{"a", "abaft", "aboard", "about", "above", "absent", "across", "afore", "after", "against", "along", "alongside", "amid", "amidst", "among", "amongst", "an", "apropos", "apud", "around", "as", "aside", "astride", "at", "athwart", "atop", "barring", "before", "behind", "below", "beneath", "beside", "besides", "between", "beyond", "but", "by", "circa", "concerning", "despite", "down", "during", "except", "excluding", "failing", "for", "from", "given", "in", "including", "inside", "into", "lest", "mid", "midst", "modulo", "near", "next", "notwithstanding", "of", "off", "on", "onto", "opposite", "out", "outside", "over", "pace", "past", "per", "plus", "pro", "qua", "regarding", "sans", "since", "through", "throughout", "thru", "thruout", "till", "to", "toward", "towards", "under", "underneath", "unlike", "until", "unto", "up", "upon", "v", "versus", "via", "vice", "vs", "with", "within", "without", "worth"};
    private static final Log _log = LogFactoryUtil.getLog(SourceUtil.class);

    public static boolean containsUnquoted(String s, String text) {
        int x = -1;
        do {
            if ((x = s.indexOf(text, x + 1)) != -1) continue;
            return false;
        } while (ToolsUtil.isInsideQuotes(s, x));
        return true;
    }

    public static String getAbsolutePath(File file) {
        return SourceUtil.getAbsolutePath(file.toPath());
    }

    public static String getAbsolutePath(Path filePath) {
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    public static String getAbsolutePath(String fileName) {
        return SourceUtil.getAbsolutePath(Paths.get(fileName, new String[0]));
    }

    public static String getIndent(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    public static String getLine(String content, int lineNumber) {
        int nextLineStartPos = SourceUtil.getLineStartPos(content, lineNumber);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    public static int getLineNumber(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    public static int getLineStartPos(String content, int lineNumber) {
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return 0;
        }
        int x = -1;
        for (int i = 1; i < lineNumber; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    public static int[] getMultiLinePositions(String content, Pattern multiLinePattern) {
        ArrayList<Integer> multiLinePositions = new ArrayList<Integer>();
        Matcher matcher = multiLinePattern.matcher(content);
        while (matcher.find()) {
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.start()));
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.end() - 1));
        }
        return ArrayUtil.toIntArray(multiLinePositions);
    }

    public static JSONObject getPortalJSONObject(String dirName, SourceFormatterExcludes sourceFormatterExcludes, final int maxLineLength) throws IOException {
        JSONObjectImpl portalJSONObject = new JSONObjectImpl();
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        ArrayList<Future<Tuple>> futures = new ArrayList<Future<Tuple>>();
        List<String> fileNames = SourceFormatterUtil.scanForFiles(dirName, new String[0], new String[]{"**/*.java"}, sourceFormatterExcludes, true);
        for (final String string : fileNames) {
            if (!string.contains("/com/liferay/")) continue;
            Future<Tuple> future = executorService.submit(new Callable<Tuple>(){

                @Override
                public Tuple call() throws Exception {
                    return SourceUtil._getClassTuple(string, maxLineLength);
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                Tuple tuple = (Tuple)future.get(1L, TimeUnit.MINUTES);
                if (tuple == null) continue;
                portalJSONObject.put((String)tuple.getObject(0), (JSONObject)tuple.getObject(1));
            }
            catch (Exception exception) {
                future.cancel(true);
            }
        }
        executorService.shutdown();
        return portalJSONObject;
    }

    public static String getRootDirName(String absolutePath) {
        int x;
        File file;
        do {
            if ((x = absolutePath.lastIndexOf(47)) != -1) continue;
            return "";
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        return absolutePath;
    }

    public static String getTitleCase(String s, boolean allowDash, String ... exceptions) {
        Object[] words;
        if (!allowDash) {
            s = StringUtil.replace(s, '-', ' ');
        }
        if (ArrayUtil.isEmpty(words = s.split("\\s+"))) {
            return s;
        }
        StringBundler sb = new StringBundler(words.length * 2);
        block0: for (int i = 0; i < words.length; ++i) {
            String lowerCaseWord;
            Object word = words[i];
            if (Validator.isNull((String)word)) continue;
            for (String exception : exceptions) {
                if (!StringUtil.equalsIgnoreCase(exception, (String)word)) continue;
                sb.append(exception);
                sb.append(' ');
                continue block0;
            }
            if (i != 0 && i != words.length && (ArrayUtil.contains(_ARTICLES, lowerCaseWord = StringUtil.toLowerCase((String)word)) || ArrayUtil.contains(_CONJUNCTIONS, lowerCaseWord) || ArrayUtil.contains(_PREPOSITIONS, lowerCaseWord))) {
                sb.append(lowerCaseWord);
                sb.append(' ');
                continue;
            }
            if (Character.isUpperCase(((String)word).charAt(0))) {
                sb.append((String)word);
            } else {
                sb.append(StringUtil.upperCaseFirstLetter((String)word));
            }
            sb.append(' ');
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public static boolean hasTypo(String s1, String s2) {
        if (Validator.isNull(s1) || Validator.isNull(s2) || s1.equals(s2) || s1.charAt(0) != s2.charAt(0) || s1.charAt(s1.length() - 1) != s2.charAt(s2.length() - 1)) {
            return false;
        }
        int min = Math.min(s1.length(), s2.length());
        int diff = Math.abs(s1.length() - s2.length());
        if (min < 5 || diff > 1) {
            return false;
        }
        int i = StringUtil.startsWithWeight(s1, s2);
        if ((s1 = s1.substring(i)).startsWith("_")) {
            return false;
        }
        if ((s2 = s2.substring(i)).startsWith("_")) {
            return false;
        }
        int j = 1;
        while (j <= s1.length() && j <= s2.length()) {
            if (s1.charAt(s1.length() - j) != s2.charAt(s2.length() - j)) {
                char[] chars1 = s1.toCharArray();
                char[] chars2 = s2.toCharArray();
                Arrays.sort(chars1);
                Arrays.sort(chars2);
                return Arrays.equals(chars1, chars2);
            }
            ++j;
        }
        return true;
    }

    public static boolean isInsideMultiLines(int lineNumber, int[] multiLinePositions) {
        for (int i = 0; i < multiLinePositions.length - 1; i += 2) {
            if (lineNumber < multiLinePositions[i]) {
                return false;
            }
            if (lineNumber > multiLinePositions[i + 1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isXML(String content) {
        try {
            SourceUtil.readXML(content);
            return true;
        }
        catch (DocumentException documentException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)documentException, documentException);
            }
            return false;
        }
    }

    public static Document readXML(File file) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read(file);
    }

    public static Document readXML(String content) throws DocumentException {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        return saxReader.read((Reader)new UnsyncStringReader(content));
    }

    private static Tuple _getClassTuple(String fileName, int maxLineLength) throws Exception {
        JSONArray methodsJSONArray;
        JSONArray extendedClassesJSONArray;
        String content = JavaParser.parse(new File(fileName), maxLineLength, false);
        JavaClass javaClass = null;
        try {
            javaClass = JavaClassParser.parseJavaClass(fileName, content);
        }
        catch (Exception exception) {
            return null;
        }
        String className = javaClass.getName(true);
        if (!className.startsWith("com.liferay.")) {
            return null;
        }
        JSONObjectImpl classJSONObject = new JSONObjectImpl();
        if (javaClass.hasAnnotation("Deprecated")) {
            classJSONObject.put("deprecated", true);
        }
        if ((extendedClassesJSONArray = SourceUtil._getExtendedClassesJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("extendedClassNames", extendedClassesJSONArray);
        }
        classJSONObject.put("fileName", fileName);
        JSONArray implementedClassesJSONArray = SourceUtil._getImplementedClassesJSONArray(javaClass);
        if (implementedClassesJSONArray.length() > 0) {
            classJSONObject.put("implementedClassNames", implementedClassesJSONArray);
        }
        if ((methodsJSONArray = SourceUtil._getMethodsJSONArray(javaClass)).length() > 0) {
            classJSONObject.put("methods", methodsJSONArray);
        }
        return new Tuple(javaClass.getName(true), classJSONObject);
    }

    private static JSONArray _getExtendedClassesJSONArray(JavaClass javaClass) {
        JSONArrayImpl extendedClassesJSONArray = new JSONArrayImpl();
        for (String extendedClassName : javaClass.getExtendedClassNames(true)) {
            extendedClassesJSONArray.put(extendedClassName);
        }
        return extendedClassesJSONArray;
    }

    private static JSONArray _getImplementedClassesJSONArray(JavaClass javaClass) {
        JSONArrayImpl implementedClassesJSONArray = new JSONArrayImpl();
        for (String implementedClassName : javaClass.getImplementedClassNames(true)) {
            implementedClassesJSONArray.put(implementedClassName);
        }
        return implementedClassesJSONArray;
    }

    private static JSONArray _getMethodsJSONArray(JavaClass javaClass) {
        JSONArrayImpl methodsJSONArray = new JSONArrayImpl();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod() || childJavaTerm.isPrivate()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            JSONObjectImpl methodJSONObject = new JSONObjectImpl();
            methodJSONObject.put("accessModifier", javaMethod.getAccessModifier());
            if (javaMethod.hasAnnotation("Deprecated")) {
                methodJSONObject.put("deprecated", true);
            }
            methodJSONObject.put("name", javaMethod.getName());
            if (javaMethod.hasAnnotation("Override")) {
                methodJSONObject.put("override", true);
            }
            JavaSignature javaSignature = null;
            try {
                javaSignature = javaMethod.getSignature();
            }
            catch (Exception exception) {
                continue;
            }
            List<JavaParameter> parameters = javaSignature.getParameters();
            if (!parameters.isEmpty()) {
                JSONArrayImpl parametersJSONArray = new JSONArrayImpl();
                for (JavaParameter javaParameter : parameters) {
                    parametersJSONArray.put(javaParameter.getParameterType(true));
                }
                methodJSONObject.put("parameters", parametersJSONArray);
            }
            methodJSONObject.put("returnType", javaSignature.getReturnType(true));
            methodsJSONArray.put(methodJSONObject);
        }
        return methodsJSONArray;
    }
}

