/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;

public class PythonWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            boolean insideMultiLines = false;
            String line = null;
            String previousLine = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                while (line.matches("^\t*    .*") && !previousLine.endsWith("\\") && !insideMultiLines) {
                    line = StringUtil.replaceFirst(line, "    ", "\t");
                }
                if (line.contains("'''") || line.contains("\"\"\"")) {
                    insideMultiLines ^= true;
                }
                sb.append(line);
                sb.append("\n");
                previousLine = line;
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }
}

