/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;

public class PropertiesDependenciesFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/dependencies.properties")) {
            return this._formatDependenciesProperties(content);
        }
        return content;
    }

    private String _formatDependenciesProperties(String content) {
        List<String> lines = ListUtil.fromString(content);
        lines = ListUtil.sort(lines);
        StringBundler sb = new StringBundler(content.length() * 2);
        for (String line : lines) {
            if (!Validator.isNotNull(line = StringUtil.removeChar(line, ' ')) || line.charAt(0) == '#') continue;
            sb.append(line);
            sb.append('\n');
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

