/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiCommandsOrderCheck
extends BaseFileCheck {
    private static final Pattern _commandPattern = Pattern.compile("(?<=\n)([\t ]+@[\\s\\S]+?)*\n+[\t ]+(function|macro|test)([\t ]+).+\n(.*\n)*?\t\\}\n(?=\\s*(@|function|macro|test|\\s*\\}$))");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int commandStartLineNumber = 0;
        Matcher matcher = _commandPattern.matcher(content);
        ArrayList<String> commands = new ArrayList<String>();
        while (matcher.find()) {
            if (commandStartLineNumber == 0) {
                commandStartLineNumber = this.getLineNumber(content, matcher.start());
            }
            commands.add(matcher.group());
        }
        if (commands.size() < 2) {
            return content;
        }
        ArrayList oldCommands = new ArrayList(commands);
        Collections.sort(commands, new CommandComparator());
        if (oldCommands.equals(commands)) {
            return content;
        }
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineNumber = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null && ++lineNumber != commandStartLineNumber) {
                sb.append(line);
                sb.append("\n");
            }
            sb.append(ListUtil.toString(commands, "", "\n"));
            sb.append("}");
        }
        return sb.toString();
    }

    private class CommandComparator
    extends NaturalOrderStringComparator {
        private final Pattern _commandNamePattern = Pattern.compile("^[\t ]*(function|macro|test)([\t ]+).+(\n|\\Z)", 8);

        private CommandComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return super.compare(this._getCommandName(s1), this._getCommandName(s2));
        }

        private String _getCommandName(String s) {
            Matcher matcher = this._commandNamePattern.matcher(s);
            if (matcher.find()) {
                return matcher.group();
            }
            return "";
        }
    }
}

