/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.liferay.source.formatter.checkstyle.util.JSPCheckstyleUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.jsp", "**/*.jspf", "**/*.jspx", "**/*.tag", "**/*.tpl", "**/*.vm"};
    private Configuration _checkstyleConfiguration;
    private CheckstyleLogger _checkstyleLogger;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final List<String[]> _ungeneratedFileContents = new ArrayList<String[]>();

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**", "**/*.xml.tpl"};
        List<String> fileNames = this.getFileNames(excludes, this.getIncludes());
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        if (fileNames.isEmpty() || sourceFormatterArgs.getCommitCount() == 0 && !sourceFormatterArgs.isFormatCurrentBranch() && !sourceFormatterArgs.isFormatLatestAuthor() && !sourceFormatterArgs.isFormatLocalChanges()) {
            return fileNames;
        }
        List<String> allJSPFileNames = this.getFileNames(excludes, this.getIncludes(), true);
        Map<String, String> contentsMap = JSPSourceUtil.getContentsMap(allJSPFileNames);
        Map<String, String> deletedContentsMap = this._getDeletedContentsMap(excludes);
        if (deletedContentsMap.isEmpty()) {
            return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), contentsMap, ".*");
        }
        contentsMap.putAll(deletedContentsMap);
        fileNames.addAll(deletedContentsMap.keySet());
        fileNames = JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), contentsMap, ".*");
        fileNames.removeAll(deletedContentsMap.keySet());
        return fileNames;
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        List<String> fileNames;
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        if ((sourceFormatterArgs.getCommitCount() > 0 || sourceFormatterArgs.isFormatCurrentBranch() || sourceFormatterArgs.isFormatLatestAuthor() || sourceFormatterArgs.isFormatLocalChanges()) && (fileNames = SourceFormatterUtil.filterFileNames(Arrays.asList(fileName), new String[0], new String[]{"*.*"}, this.getSourceFormatterExcludes(), false)).isEmpty()) {
            return file;
        }
        file = super.format(file, fileName, absolutePath, content);
        this._processCheckstyle(absolutePath, FileUtil.read(file));
        return file;
    }

    @Override
    protected void postFormat() throws CheckstyleException, IOException {
        this._processCheckstyle();
        for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
            String fileName = sourceFormatterMessage.getFileName();
            this.processMessage(fileName, sourceFormatterMessage);
            this.printError(fileName, sourceFormatterMessage.toString());
        }
    }

    @Override
    protected void preFormat() throws CheckstyleException {
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        this._checkstyleLogger = new CheckstyleLogger(sourceFormatterArgs.getBaseDirName());
        this._checkstyleConfiguration = CheckstyleUtil.getConfiguration("checkstyle-jsp.xml", this.getPropertiesMap(), sourceFormatterArgs);
    }

    private Map<String, String> _getDeletedContentsMap(String[] excludes) throws Exception {
        List<Object> fileNames = Collections.emptyList();
        SourceFormatterArgs sourceFormatterArgs = this.getSourceFormatterArgs();
        if (sourceFormatterArgs.getCommitCount() > 0) {
            fileNames = GitUtil.getModifiedFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getCommitCount(), true);
        } else if (sourceFormatterArgs.isFormatCurrentBranch()) {
            fileNames = GitUtil.getCurrentBranchFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName(), true);
        } else if (sourceFormatterArgs.isFormatLatestAuthor()) {
            fileNames = GitUtil.getLatestAuthorFileNames(sourceFormatterArgs.getBaseDirName(), true);
        } else if (sourceFormatterArgs.isFormatLocalChanges()) {
            fileNames = GitUtil.getLocalChangesFileNames(sourceFormatterArgs.getBaseDirName(), true);
        }
        if (fileNames.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<String> deletedFileNames = new ArrayList<String>();
        for (String string : fileNames) {
            File file = new File(SourceUtil.getAbsolutePath(string));
            if (Files.exists(file.toPath(), new LinkOption[0])) continue;
            deletedFileNames.add(string);
        }
        if (deletedFileNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> contentsMap = new HashMap<String, String>();
        List<String> list = SourceFormatterUtil.filterFileNames(deletedFileNames, excludes, this.getIncludes(), this.getSourceFormatterExcludes(), true);
        for (String filteredFileName : list) {
            String content = GitUtil.getFileContent(filteredFileName);
            String fileName = StringUtil.replace(sourceFormatterArgs.getBaseDirName() + filteredFileName, '\\', '/');
            contentsMap.put(fileName, content);
        }
        return contentsMap;
    }

    private void _processCheckstyle() throws CheckstyleException, IOException {
        if (this._ungeneratedFileContents.isEmpty()) {
            return;
        }
        this._sourceFormatterMessages.addAll(this.processCheckstyle(this._checkstyleConfiguration, this._checkstyleLogger, this._ungeneratedFileContents));
        this._ungeneratedFileContents.clear();
    }

    private synchronized void _processCheckstyle(String absolutePath, String content) throws CheckstyleException, IOException {
        String javaContent = JSPCheckstyleUtil.getJavaContent(absolutePath, content);
        if (javaContent != null) {
            this._ungeneratedFileContents.add(new String[]{absolutePath, javaContent});
            if (this._ungeneratedFileContents.size() == 1000) {
                this._processCheckstyle();
            }
        }
    }
}

