/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChainingCheck
extends BaseCheck {
    private static final String _ALLOW_CONCAT_CHAIN_KEY = "allowConcatChain";
    private static final String _ALLOWED_CLASS_NAMES_KEY = "allowedClassNames";
    private static final String _ALLOWED_METHOD_NAMES_KEY = "allowedMethodNames";
    private static final String _ALLOWED_MOCKITO_METHOD_NAMES_KEY = "allowedMockitoMethodNames";
    private static final String _ALLOWED_VARIABLE_TYPE_NAMES_KEY = "allowedVariableTypeNames";
    private static final String _APPLY_TO_TYPE_CAST_KEY = "applyToTypeCast";
    private static final String _MSG_ALLOWED_CHAINING = "chaining.allowed";
    private static final String _MSG_AVOID_METHOD_CHAINING = "chaining.avoid.method";
    private static final String _MSG_AVOID_NEW_INSTANCE_CHAINING = "chaining.avoid.new.instance";
    private static final String _MSG_AVOID_PARENTHESES_CHAINING = "chaining.avoid.parentheses";
    private static final String _MSG_AVOID_TOO_MANY_CONCAT = "concat.avoid.too.many";
    private static final String _MSG_AVOID_TYPE_CAST_CHAINING = "chaining.avoid.type.cast";
    private static final String _MSG_REQUIRED_CHAINING = "chaining.required";
    private static final String _MSG_UNSORTED_RESPONSE = "response.unsorted";
    private static final String _REQUIRED_CHAINING_CLASS_FILE_NAMES_KEY = "requiredChainingClassFileNames";
    private static final Log _log = LogFactoryUtil.getLog(ChainingCheck.class);
    private Map<String, List<String>> _requiredChainingMethodNamesMap;

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15, 136, 77};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST;
        if (detailAST.getType() == 136) {
            this._checkChainingOnNewInstance(detailAST);
            return;
        }
        if (detailAST.getType() == 77) {
            this._checkChainingOnParentheses(detailAST);
        }
        if ((parentDetailAST = detailAST.getParent()) != null) {
            return;
        }
        this._checkChainingOnMethodCalls(detailAST);
    }

    private void _checkAllowedChaining(DetailAST methodCallDetailAST) {
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        while (parentDetailAST.getType() == 59 || parentDetailAST.getType() == 27) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() != 28) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 80) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 10) {
            return;
        }
        String classOrVariableName = this.getClassOrVariableName(methodCallDetailAST);
        if (!(Objects.equals(classOrVariableName, "Optional") || Objects.equals(classOrVariableName, "Stream") || Objects.equals(classOrVariableName, "Try"))) {
            return;
        }
        DetailAST variableNameDetailAST = parentDetailAST.findFirstToken(58);
        String variableName = variableNameDetailAST.getText();
        String variableTypeName = this.getVariableTypeName(methodCallDetailAST, variableName, false);
        if (!classOrVariableName.equals(variableTypeName)) {
            return;
        }
        List<DetailAST> identDetailASTList = this._getIdentDetailASTList(parentDetailAST.getParent(), variableName);
        if (identDetailASTList.size() == 2 && Objects.equals(this._findFirstParent(identDetailASTList.get(0), 34, 83), this._findFirstParent(identDetailASTList.get(1), 34, 83))) {
            this.log(methodCallDetailAST, _MSG_ALLOWED_CHAINING, new Object[]{StringBundler.concat(classOrVariableName, ".", this.getMethodName(methodCallDetailAST))});
        }
    }

    private void _checkChainingOnMethodCalls(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<DetailAST> childMethodCallDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST != null && !(childMethodCallDetailASTList = this.getAllChildTokens(dotDetailAST, false, 27)).isEmpty()) continue;
            this._checkAllowedChaining(methodCallDetailAST);
            BaseCheck.ChainInformation chainInformation = this.getChainInformation(methodCallDetailAST);
            List<String> chainedMethodNames = chainInformation.getMethodNames();
            this._checkRequiredChaining(methodCallDetailAST, chainedMethodNames);
            int chainSize = chainedMethodNames.size();
            if (chainSize == 1) continue;
            if (chainSize == 2) {
                DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
                if (elistDetailAST.getChildCount() == 0 && dotDetailAST == null) continue;
                this._checkMethodName(chainedMethodNames, "getClass", methodCallDetailAST);
                if ((this.isAttributeValue(_ALLOW_CONCAT_CHAIN_KEY) || this.isExcludedPath("run.outside.portal.excludes")) && Objects.equals(chainedMethodNames.get(0), "concat") && Objects.equals(chainedMethodNames.get(1), "concat")) continue;
            }
            if (chainSize > 3) {
                this._checkChainOrder(methodCallDetailAST, chainedMethodNames);
            }
            if (this._isAllowedChainingMethodCall(methodCallDetailAST, chainInformation, detailAST)) continue;
            int concatsCount = Collections.frequency(chainedMethodNames, "concat");
            if (chainSize == 3 && concatsCount == 2 && this.isAttributeValue(_ALLOW_CONCAT_CHAIN_KEY)) continue;
            if (concatsCount > 1 && !this.isExcludedPath("run.outside.portal.excludes")) {
                this.log(methodCallDetailAST, _MSG_AVOID_TOO_MANY_CONCAT, new Object[0]);
                continue;
            }
            this.log(methodCallDetailAST, _MSG_AVOID_METHOD_CHAINING, new Object[]{this.getMethodName(methodCallDetailAST)});
        }
    }

    private void _checkChainingOnNewInstance(DetailAST detailAST) {
        DetailAST dotDetailAST = detailAST.getParent();
        if (dotDetailAST.getType() != 59) {
            return;
        }
        DetailAST methodCallDetailAST = dotDetailAST.getParent();
        if (methodCallDetailAST.getType() != 27 || detailAST.findFirstToken(17) != null || detailAST.findFirstToken(6) != null || this._isAllowedChainingMethodCall(methodCallDetailAST, this.getChainInformation(methodCallDetailAST), detailAST)) {
            return;
        }
        this.log(methodCallDetailAST, _MSG_AVOID_NEW_INSTANCE_CHAINING, new Object[0]);
    }

    private void _checkChainingOnParentheses(DetailAST detailAST) {
        if (this._isInsideConstructorThisCall(detailAST) || this.hasParentWithTokenType(detailAST, 42)) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return;
        }
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST.getType() != 23) {
            this.log(detailAST, _MSG_AVOID_PARENTHESES_CHAINING, new Object[0]);
        } else if (this.isAttributeValue(_APPLY_TO_TYPE_CAST_KEY)) {
            this.log(detailAST, _MSG_AVOID_TYPE_CAST_CHAINING, new Object[0]);
        }
    }

    private void _checkChainOrder(DetailAST methodCallDetailAST, List<String> chainedMethodNames) {
        if (!(Objects.equals(chainedMethodNames.get(0), "status") && Objects.equals(chainedMethodNames.get(chainedMethodNames.size() - 1), "build") && Objects.equals(this.getClassOrVariableName(methodCallDetailAST), "Response"))) {
            return;
        }
        List<String> middleMethodNames = chainedMethodNames.subList(1, chainedMethodNames.size() - 1);
        String unsortedNames = middleMethodNames.toString();
        Collections.sort(middleMethodNames);
        if (!unsortedNames.equals(middleMethodNames.toString())) {
            this.log(methodCallDetailAST, _MSG_UNSORTED_RESPONSE, new Object[0]);
        }
    }

    private void _checkMethodName(List<String> chainedMethodNames, String methodName, DetailAST methodCallDetailAST) {
        String firstMethodName = chainedMethodNames.get(0);
        if (firstMethodName.equals(methodName) && !this._isInsideConstructorThisCall(methodCallDetailAST) && !this.hasParentWithTokenType(methodCallDetailAST, 42)) {
            this.log(methodCallDetailAST, _MSG_AVOID_METHOD_CHAINING, new Object[]{methodName});
        }
    }

    private void _checkRequiredChaining(DetailAST methodCallDetailAST, List<String> chainedMethodNames) {
        DetailAST firstChildDetailAST;
        DetailAST parentDetailAST;
        List<String> requiredChainingMethodNames;
        String variableTypeName;
        String classOrVariableName = this.getClassOrVariableName(methodCallDetailAST);
        if (classOrVariableName == null) {
            return;
        }
        String fullyQualifiedClassName = variableTypeName = this.getVariableTypeName(methodCallDetailAST, classOrVariableName, false);
        for (String importName : this.getImportNames(methodCallDetailAST)) {
            if (!importName.endsWith("." + variableTypeName)) continue;
            fullyQualifiedClassName = importName;
            break;
        }
        if ((requiredChainingMethodNames = this._getRequiredChainingMethodNames(fullyQualifiedClassName)) == null) {
            return;
        }
        String methodName = chainedMethodNames.get(chainedMethodNames.size() - 1);
        if (!requiredChainingMethodNames.contains(methodName)) {
            return;
        }
        DetailAST topLevelMethodCallDetailAST = methodCallDetailAST;
        while ((parentDetailAST = topLevelMethodCallDetailAST.getParent()).getType() == 59 && (parentDetailAST = parentDetailAST.getParent()).getType() == 27) {
            topLevelMethodCallDetailAST = parentDetailAST;
        }
        parentDetailAST = topLevelMethodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || nextSiblingDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextMethodCallDetailAST = nextSiblingDetailAST.getFirstChild();
        if (nextMethodCallDetailAST.getType() != 27) {
            return;
        }
        while ((firstChildDetailAST = nextMethodCallDetailAST.getFirstChild()).getType() == 59 && (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 27) {
            nextMethodCallDetailAST = firstChildDetailAST;
        }
        if (classOrVariableName.equals(this.getClassOrVariableName(nextMethodCallDetailAST)) && !Objects.equals(this.getMethodName(nextMethodCallDetailAST), "remove")) {
            this.log(methodCallDetailAST, _MSG_REQUIRED_CHAINING, new Object[]{classOrVariableName + "." + methodName});
        }
    }

    private DetailAST _findFirstParent(DetailAST detailAST, int ... types) {
        DetailAST parentDetailAST = detailAST.getParent();
        while (parentDetailAST != null) {
            if (ArrayUtil.contains(types, parentDetailAST.getType())) {
                return parentDetailAST;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return null;
    }

    private DetailAST _getGlobalVariableDefinitonDetailAST(DetailAST methodCallDetailAST) {
        DetailAST parentDetailAST = methodCallDetailAST.getParent();
        while (parentDetailAST != null && parentDetailAST.getType() != 8 && parentDetailAST.getType() != 9) {
            if (parentDetailAST.getType() == 10) {
                DetailAST grandParentDetailAST = parentDetailAST.getParent();
                if (grandParentDetailAST.getType() == 6) {
                    return parentDetailAST;
                }
                return null;
            }
            parentDetailAST = parentDetailAST.getParent();
        }
        return null;
    }

    private List<DetailAST> _getIdentDetailASTList(DetailAST detailAST, String name) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        for (DetailAST identDetailAST : this.getAllChildTokens(detailAST, true, 58)) {
            if (!name.equals(identDetailAST.getText())) continue;
            identDetailASTList.add(identDetailAST);
        }
        return identDetailASTList;
    }

    private JavaClass _getJavaClass(String requiredChainingClassFileName) {
        File file = SourceFormatterUtil.getFile(this.getBaseDirName(), requiredChainingClassFileName, this.getMaxDirLevel());
        try {
            if (file != null) {
                return JavaClassParser.parseJavaClass(requiredChainingClassFileName, FileUtil.read(file));
            }
            String portalBranchName = this.getAttributeValue("git.liferay.portal.branch");
            if (Validator.isNull(portalBranchName)) {
                return null;
            }
            URL url = new URL(StringBundler.concat("https://raw.githubusercontent.com/liferay/liferay-portal/", portalBranchName, "/", requiredChainingClassFileName));
            return JavaClassParser.parseJavaClass(requiredChainingClassFileName, StringUtil.read(url.openStream()));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception, exception);
            }
            return null;
        }
    }

    private List<String> _getRequiredChainingMethodNames(String fullyQualifiedClassName) {
        if (this._requiredChainingMethodNamesMap != null) {
            return this._requiredChainingMethodNamesMap.get(fullyQualifiedClassName);
        }
        this._requiredChainingMethodNamesMap = new HashMap<String, List<String>>();
        List<String> requiredChainingClassFileNames = this.getAttributeValues(_REQUIRED_CHAINING_CLASS_FILE_NAMES_KEY);
        for (String requiredChainingClassFileName : requiredChainingClassFileNames) {
            JavaClass javaClass = this._getJavaClass(requiredChainingClassFileName);
            if (javaClass == null) continue;
            ArrayList<String> requiredChainingMethodNames = new ArrayList<String>();
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                JavaMethod javaMethod;
                if (!(javaTerm instanceof JavaMethod) || !(javaMethod = (JavaMethod)javaTerm).isPublic()) continue;
                JavaSignature javaSignature = javaMethod.getSignature();
                if (!Objects.equals(javaClass.getName(), javaSignature.getReturnType())) continue;
                requiredChainingMethodNames.add(javaMethod.getName());
            }
            this._requiredChainingMethodNamesMap.put(javaClass.getPackageName() + "." + javaClass.getName(), requiredChainingMethodNames);
        }
        return this._requiredChainingMethodNamesMap.get(fullyQualifiedClassName);
    }

    private String _getReturnType(String methodName, DetailAST classDefinitionDetailAST) {
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(classDefinitionDetailAST, true, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST nameDetailAST = methodDefinitionDetailAST.findFirstToken(58);
            if (!methodName.equals(nameDetailAST.getText())) continue;
            return this.getTypeName(methodDefinitionDetailAST, false);
        }
        return null;
    }

    private boolean _isAllowedChainingMethodCall(DetailAST methodCallDetailAST, BaseCheck.ChainInformation chainInformation, DetailAST detailAST) {
        List<String> allowedClassNames;
        DetailAST dotDetailAST;
        String absolutePath;
        DetailAST globalVariableDefinitonDetailAST = this._getGlobalVariableDefinitonDetailAST(methodCallDetailAST);
        if (globalVariableDefinitonDetailAST != null && (detailAST.getType() != 14 || this._isInsideInnerClass(globalVariableDefinitonDetailAST, detailAST))) {
            return true;
        }
        if (this._isInsideConstructorThisCall(methodCallDetailAST) || this.hasParentWithTokenType(methodCallDetailAST, 42)) {
            return true;
        }
        List<String> chainedMethodNames = chainInformation.getMethodNames();
        List<String> allowedMethodNames = this.getAttributeValues(_ALLOWED_METHOD_NAMES_KEY);
        for (String allowedMethodName : allowedMethodNames) {
            if (!chainedMethodNames.contains(allowedMethodName)) continue;
            return true;
        }
        String returnType = chainInformation.getReturnType();
        if (returnType != null) {
            List<String> allowedVariableTypeNames = this.getAttributeValues(_ALLOWED_VARIABLE_TYPE_NAMES_KEY);
            for (String string : allowedVariableTypeNames) {
                if (!returnType.matches(string)) continue;
                return true;
            }
        }
        if ((absolutePath = this.getAbsolutePath()).contains("/test/") || absolutePath.contains("/testIntegration/")) {
            List<String> allowedMockitoMethodNames = this.getAttributeValues(_ALLOWED_MOCKITO_METHOD_NAMES_KEY);
            for (String allowedMockitoMethodName : allowedMockitoMethodNames) {
                if (!chainedMethodNames.contains(allowedMockitoMethodName)) continue;
                return true;
            }
        }
        if ((dotDetailAST = methodCallDetailAST.findFirstToken(59)) == null) {
            String string = JavaSourceUtil.getClassName(absolutePath);
            allowedClassNames = this.getAttributeValues(_ALLOWED_CLASS_NAMES_KEY);
            for (String string2 : allowedClassNames) {
                if (!string.matches(string2)) continue;
                return true;
            }
            returnType = this._getReturnType(chainedMethodNames.get(0), detailAST);
            if (returnType != null) {
                List<String> allowedVariableTypeNames = this.getAttributeValues(_ALLOWED_VARIABLE_TYPE_NAMES_KEY);
                for (String allowedVariableTypeName : allowedVariableTypeNames) {
                    if (!returnType.matches(allowedVariableTypeName)) continue;
                    return true;
                }
            }
            return false;
        }
        String string = this.getClassOrVariableName(methodCallDetailAST);
        if (string != null) {
            if (this._isLambdaVariable(methodCallDetailAST, string)) {
                return true;
            }
            allowedClassNames = this.getAttributeValues(_ALLOWED_CLASS_NAMES_KEY);
            for (String s : StringUtil.split(string, '.')) {
                for (String allowedClassName : allowedClassNames) {
                    if (!s.matches("(?i)" + allowedClassName)) continue;
                    return true;
                }
            }
            String variableTypeName = this.getVariableTypeName(methodCallDetailAST, string, false);
            if (Validator.isNotNull(variableTypeName)) {
                List<String> list = this.getAttributeValues(_ALLOWED_VARIABLE_TYPE_NAMES_KEY);
                for (String allowedVariableTypeName : list) {
                    if (!variableTypeName.matches(allowedVariableTypeName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean _isInsideConstructorThisCall(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            String parentDetailASTText = parentDetailAST.getText();
            if (parentDetailAST.getType() != 43 || !parentDetailASTText.equals("this")) continue;
            return true;
        }
        return false;
    }

    private boolean _isInsideInnerClass(DetailAST globalVariableDefinitonDetailAST, DetailAST outerClassDefinitionDetailAST) {
        DetailAST detailAST = this.getParentWithTokenType(globalVariableDefinitonDetailAST, 14, 154, 15, 136);
        return !detailAST.equals(outerClassDefinitionDetailAST);
    }

    private boolean _isLambdaVariable(DetailAST methodCallDetailAST, String variableName) {
        for (DetailAST parentDetailAST = methodCallDetailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() != 181) {
                continue;
            }
            DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
            return nameDetailAST != null && variableName.equals(nameDetailAST.getText());
        }
        return false;
    }
}

