/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.BaseImportsFormatter;
import com.liferay.portal.tools.ImportPackage;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleImportsFormatter
extends BaseImportsFormatter {
    private static final Pattern _gradleImportPattern = Pattern.compile("import (.*)");
    private static final Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*\n+)+", 8);

    @Override
    protected ImportPackage createImportPackage(String line) {
        Matcher matcher = _gradleImportPattern.matcher(line);
        if (matcher.find()) {
            return new ImportPackage(matcher.group(1), false, line);
        }
        return null;
    }

    @Override
    protected String doFormat(String content, Pattern importPattern, String packageDir, String className) throws IOException {
        String imports = this._getImports(content);
        if (Validator.isNull(imports)) {
            return content;
        }
        String newImports = this.sortAndGroupImports(imports);
        if (!imports.equals(newImports)) {
            content = StringUtil.replaceFirst(content, imports, newImports);
        }
        if (!content.startsWith(newImports)) {
            content = StringUtil.removeSubstring(content, newImports);
            content = newImports + "\n" + content;
        }
        return content;
    }

    private String _getImports(String content) {
        Matcher matcher = _importsPattern.matcher(content);
        if (matcher.find()) {
            String imports = matcher.group();
            if (imports.endsWith("\n\n")) {
                imports = imports.substring(0, imports.length() - 1);
            }
            return imports;
        }
        return null;
    }
}

