/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;

public class SlantedQuotesCheck
extends BaseFileCheck {
    private static final char[] _SLANTED_DOUBLE_QUOTE_CHARS = new char[]{'\u201c', '\u201d', '\u201e', '\u201f'};
    private static final char[] _SLANTED_SINGLE_QUOTE_CHARS = new char[]{'\u2018', '\u2019', '\u201a', '\u201b'};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._fixSlantedQuotes(content, _SLANTED_DOUBLE_QUOTE_CHARS, "\"");
        content = this._fixSlantedQuotes(content, _SLANTED_SINGLE_QUOTE_CHARS, "'");
        return content;
    }

    private String _fixSlantedQuotes(String content, char[] chars, String replacement) {
        int x = content.length() + 1;
        while (true) {
            int y = -1;
            for (char c : chars) {
                y = Math.max(y, content.lastIndexOf(c, x - 1));
            }
            if (y == -1) {
                return content;
            }
            if (!ToolsUtil.isInsideQuotes(content, y)) {
                content = StringBundler.concat(content.substring(0, y), replacement, content.substring(y + 1));
            }
            x = y;
        }
    }
}

