/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnparameterizedClassCheck
extends BaseFileCheck {
    private static final Pattern _unparameterizedClassTypePattern1 = Pattern.compile("\\Wnew Class[^<\\w]");
    private static final Pattern _unparameterizedClassTypePattern2 = Pattern.compile("\\WClass[\\[\\]]* \\w+ =");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._fixUnparameterizedClassType(content);
    }

    private String _fixUnparameterizedClassType(String content) {
        Matcher matcher = _unparameterizedClassTypePattern1.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "Class", "Class<?>", matcher.start());
        }
        matcher = _unparameterizedClassTypePattern2.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "Class", "Class<?>", matcher.start());
        }
        return content;
    }
}

