/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPExceptionOrderCheck
extends BaseFileCheck {
    private static final Pattern _exceptionsPattern = Pattern.compile("(^[\t]*<liferay-ui:error exception=\"<%=.*\n)+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortExceptions(content);
    }

    private String _sortExceptions(String content) {
        Matcher matcher = _exceptionsPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String[] lines = StringUtil.splitLines(match);
            String previousException = null;
            String previousLine = null;
            for (String line : lines) {
                int x;
                int y = (line = StringUtil.trim(line)).indexOf(".class %>", x = line.indexOf("<liferay-ui:error exception=\"<%="));
                if (y == -1) {
                    previousException = null;
                    continue;
                }
                String currentException = line.substring(x, y);
                if (Validator.isNotNull(previousException) && previousException.compareToIgnoreCase(currentException) > 0) {
                    String replacement = StringUtil.replaceFirst(match, previousLine, line);
                    replacement = StringUtil.replaceLast(replacement, line, previousLine);
                    return StringUtil.replaceFirst(content, match, replacement, matcher.start());
                }
                previousException = currentException;
                previousLine = line;
            }
        }
        return content;
    }
}

