/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStringBundlerConcatCheck
extends BaseJavaTermCheck {
    private static final Pattern _stringBundlerConcatPattern = Pattern.compile("StringBundler\\.concat\\(");
    private static final Pattern _stringValueOfPattern = Pattern.compile("String\\.valueOf\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        List<String> imports = javaClass.getImports();
        boolean hasPetraStringStringBundler = imports.contains("com.liferay.petra.string.StringBundler");
        String content = javaTerm.getContent();
        Matcher matcher1 = _stringBundlerConcatPattern.matcher(content);
        while (matcher1.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher1.start() + 1)) continue;
            String stringBundlerConcatMethodCall = this._getMethodCall(content, matcher1.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(stringBundlerConcatMethodCall);
            if (parameterList.size() < 3) {
                this.addMessage(fileName, "Do not use 'StringBundler.concat' when concatenating less than 3 elements", javaTerm.getLineNumber(matcher1.start()));
            }
            if (!hasPetraStringStringBundler) continue;
            Matcher matcher2 = _stringValueOfPattern.matcher(stringBundlerConcatMethodCall);
            while (matcher2.find()) {
                String stringValueOfMethodCall;
                int level = this.getLevel(stringBundlerConcatMethodCall.substring(0, matcher2.start()));
                if (level != 1 || (parameterList = JavaSourceUtil.getParameterList(stringValueOfMethodCall = this._getMethodCall(stringBundlerConcatMethodCall, matcher2.start()))).size() != 1) continue;
                String newStringBundlerConcatMethodCall = StringUtil.replaceFirst(stringBundlerConcatMethodCall, stringValueOfMethodCall, parameterList.get(0));
                return StringUtil.replace(content, stringBundlerConcatMethodCall, newStringBundlerConcatMethodCall);
            }
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _getMethodCall(String s, int start) {
        String methodCall;
        int x = start;
        while (ToolsUtil.isInsideQuotes(s, (x = s.indexOf(")", x + 1)) + 1) || this.getLevel(methodCall = s.substring(start, x + 1)) != 0) {
        }
        return methodCall;
    }
}

