/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ArrayUtil {
    public static boolean[] append(boolean[] ... arrays) {
        int length = 0;
        for (boolean[] array : arrays) {
            length += array.length;
        }
        boolean[] newArray = new boolean[length];
        int previousLength = 0;
        for (boolean[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static boolean[] append(boolean[] array, boolean value) {
        boolean[] newArray = new boolean[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static byte[] append(byte[] ... arrays) {
        int length = 0;
        for (byte[] array : arrays) {
            length += array.length;
        }
        byte[] newArray = new byte[length];
        int previousLength = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static byte[] append(byte[] array, byte value) {
        byte[] newArray = new byte[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static char[] append(char[] ... arrays) {
        int length = 0;
        for (char[] array : arrays) {
            length += array.length;
        }
        char[] newArray = new char[length];
        int previousLength = 0;
        for (char[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static char[] append(char[] array, char value) {
        char[] newArray = new char[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static double[] append(double[] ... arrays) {
        int length = 0;
        for (double[] array : arrays) {
            length += array.length;
        }
        double[] newArray = new double[length];
        int previousLength = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static double[] append(double[] array, double value) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static float[] append(float[] ... arrays) {
        int length = 0;
        for (float[] array : arrays) {
            length += array.length;
        }
        float[] newArray = new float[length];
        int previousLength = 0;
        for (float[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static float[] append(float[] array, float value) {
        float[] newArray = new float[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static int[] append(int[] ... arrays) {
        int length = 0;
        for (int[] array : arrays) {
            length += array.length;
        }
        int[] newArray = new int[length];
        int previousLength = 0;
        for (int[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static int[] append(int[] array, int value) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static long[] append(long[] ... arrays) {
        int length = 0;
        for (long[] array : arrays) {
            length += array.length;
        }
        long[] newArray = new long[length];
        int previousLength = 0;
        for (long[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static long[] append(long[] array, long value) {
        long[] newArray = new long[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static short[] append(short[] ... arrays) {
        int length = 0;
        for (short[] array : arrays) {
            length += array.length;
        }
        short[] newArray = new short[length];
        int previousLength = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static short[] append(short[] array, short value) {
        short[] newArray = new short[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = value;
        return newArray;
    }

    public static <T> T[] append(T[] ... arrays) {
        int length = 0;
        for (T[] array : arrays) {
            length += array.length;
        }
        Class<?> arraysClass = arrays[0].getClass();
        Object[] newArray = (Object[])Array.newInstance(arraysClass.getComponentType(), length);
        int previousLength = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, newArray, previousLength, array.length);
            previousLength += array.length;
        }
        return newArray;
    }

    public static <T> T[] append(T[] array, T value) {
        Class<?> arrayClass = array.getClass();
        Object[] newArray = (Object[])Array.newInstance(arrayClass.getComponentType(), array.length + 1);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = value;
        return newArray;
    }

    public static <T> T[] append(T[] array1, T[] array2) {
        Class<?> array1Class = array1.getClass();
        Object[] newArray = (Object[])Array.newInstance(array1Class.getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static <T> T[][] append(T[][] array1, T[] value) {
        Class<?> array1Class = array1.getClass();
        Object[][] newArray = (Object[][])Array.newInstance(array1Class.getComponentType(), array1.length + 1);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        newArray[array1.length] = value;
        return newArray;
    }

    public static <T> T[][] append(T[][] array1, T[][] array2) {
        Class<?> array1Class = array1.getClass();
        Object[][] newArray = (Object[][])Array.newInstance(array1Class.getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static boolean[] clone(boolean[] array) {
        boolean[] newArray = new boolean[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static boolean[] clone(boolean[] array, int from, int to) {
        boolean[] newArray = new boolean[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static byte[] clone(byte[] array) {
        byte[] newArray = new byte[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static byte[] clone(byte[] array, int from, int to) {
        byte[] newArray = new byte[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static char[] clone(char[] array) {
        char[] newArray = new char[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static char[] clone(char[] array, int from, int to) {
        char[] newArray = new char[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static double[] clone(double[] array) {
        double[] newArray = new double[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static double[] clone(double[] array, int from, int to) {
        double[] newArray = new double[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static float[] clone(float[] array) {
        float[] newArray = new float[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static float[] clone(float[] array, int from, int to) {
        float[] newArray = new float[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static int[] clone(int[] array) {
        int[] newArray = new int[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static int[] clone(int[] array, int from, int to) {
        int[] newArray = new int[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static long[] clone(long[] array) {
        long[] newArray = new long[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static long[] clone(long[] array, int from, int to) {
        long[] newArray = new long[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static short[] clone(short[] array) {
        short[] newArray = new short[array.length];
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static short[] clone(short[] array, int from, int to) {
        short[] newArray = new short[to - from];
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static <T> T[] clone(T[] array) {
        Class<?> arrayClass = array.getClass();
        Object[] newArray = (Object[])Array.newInstance(arrayClass.getComponentType(), array.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static <T> T[] clone(T[] array, int from, int to) {
        Class<?> arrayClass = array.getClass();
        Object[] newArray = (Object[])Array.newInstance(arrayClass.getComponentType(), to - from);
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static <T> T[][] clone(T[][] array) {
        Class<?> arrayClass = array.getClass();
        Object[][] newArray = (Object[][])Array.newInstance(arrayClass.getComponentType(), array.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        return newArray;
    }

    public static <T> T[][] clone(T[][] array, int from, int to) {
        Class<?> arrayClass = array.getClass();
        Object[][] newArray = (Object[][])Array.newInstance(arrayClass.getComponentType(), to - from);
        System.arraycopy(array, from, newArray, 0, Math.min(array.length - from, newArray.length));
        return newArray;
    }

    public static void combine(Object[] array1, Object[] array2, Object[] combinedArray) {
        System.arraycopy(array1, 0, combinedArray, 0, array1.length);
        System.arraycopy(array2, 0, combinedArray, array1.length, array2.length);
    }

    public static boolean contains(boolean[] array, boolean value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (boolean b : array) {
            if (value != b) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] array, byte value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (byte b : array) {
            if (value != b) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(char[] array, char value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (char c : array) {
            if (value != c) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] array, double value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (double d : array) {
            if (value != d) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(float[] array, float value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (float f : array) {
            if (value != f) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] array, int value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (int i : array) {
            if (value != i) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] array, long value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (long l : array) {
            if (value != l) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Object[] array, Object value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (Object object : array) {
            if (!Objects.equals(value, object)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(short[] array, short value) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (short s : array) {
            if (value != s) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String[] array, String value, boolean ignoreCase) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (String s : array) {
            if (!(ignoreCase ? StringUtil.equalsIgnoreCase(s, value) : Objects.equals(s, value))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(boolean[] array1, boolean[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (boolean b : array2) {
            if (ArrayUtil.contains(array1, b)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(byte[] array1, byte[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (byte b : array2) {
            if (ArrayUtil.contains(array1, b)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(char[] array1, char[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (char c : array2) {
            if (ArrayUtil.contains(array1, c)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(double[] array1, double[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (double d : array2) {
            if (ArrayUtil.contains(array1, d)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(float[] array1, float[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (float f : array2) {
            if (ArrayUtil.contains(array1, f)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(int[] array1, int[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (int i : array2) {
            if (ArrayUtil.contains(array1, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(long[] array1, long[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (long l : array2) {
            if (ArrayUtil.contains(array1, l)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Object[] array1, Object[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (Object object : array2) {
            if (ArrayUtil.contains(array1, object)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(short[] array1, short[] array2) {
        if (ArrayUtil.isEmpty(array1) || ArrayUtil.isEmpty(array2)) {
            return false;
        }
        for (short s : array2) {
            if (ArrayUtil.contains(array1, s)) continue;
            return false;
        }
        return true;
    }

    public static <T> int count(T[] array, Predicate<T> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return 0;
        }
        int count = 0;
        for (T t : array) {
            if (!predicate.test(t)) continue;
            ++count;
        }
        return count;
    }

    public static String[] distinct(String[] array) {
        return ArrayUtil.distinct(array, null);
    }

    public static String[] distinct(String[] array, Comparator<String> comparator) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        TreeSet<Object> set = null;
        set = comparator == null ? new TreeSet() : new TreeSet<String>(comparator);
        for (String s : array) {
            set.add(s);
        }
        return set.toArray(new String[0]);
    }

    public static <T> boolean exists(T[] array, Predicate<T> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (T t : array) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean[] filter(boolean[] array, Predicate<Boolean> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Boolean> filteredList = new ArrayList<Boolean>();
        for (boolean b : array) {
            if (!predicate.test(b)) continue;
            filteredList.add(b);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Boolean[0]));
    }

    public static byte[] filter(byte[] array, Predicate<Byte> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Byte> filteredList = new ArrayList<Byte>();
        for (byte b : array) {
            if (!predicate.test(b)) continue;
            filteredList.add(b);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Byte[0]));
    }

    public static char[] filter(char[] array, Predicate<Character> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Character> filteredList = new ArrayList<Character>();
        for (char c : array) {
            if (!predicate.test(Character.valueOf(c))) continue;
            filteredList.add(Character.valueOf(c));
        }
        return ArrayUtil.toArray(filteredList.toArray(new Character[0]));
    }

    public static double[] filter(double[] array, Predicate<Double> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Double> filteredList = new ArrayList<Double>();
        for (double d : array) {
            if (!predicate.test(d)) continue;
            filteredList.add(d);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Double[0]));
    }

    public static float[] filter(float[] array, Predicate<Float> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Float> filteredList = new ArrayList<Float>();
        for (float f : array) {
            if (!predicate.test(Float.valueOf(f))) continue;
            filteredList.add(Float.valueOf(f));
        }
        return ArrayUtil.toArray(filteredList.toArray(new Float[0]));
    }

    public static int[] filter(int[] array, Predicate<Integer> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Integer> filteredList = new ArrayList<Integer>();
        for (int i : array) {
            if (!predicate.test(i)) continue;
            filteredList.add(i);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Integer[0]));
    }

    public static long[] filter(long[] array, Predicate<Long> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Long> filteredList = new ArrayList<Long>();
        for (long l : array) {
            if (!predicate.test(l)) continue;
            filteredList.add(l);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Long[0]));
    }

    public static short[] filter(short[] array, Predicate<Short> predicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Short> filteredList = new ArrayList<Short>();
        for (short s : array) {
            if (!predicate.test(s)) continue;
            filteredList.add(s);
        }
        return ArrayUtil.toArray(filteredList.toArray(new Short[0]));
    }

    public static <T> T[] filter(T[] array, Predicate<T> filterPredicate) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<T> filteredList = new ArrayList<T>();
        for (T t : array) {
            if (!filterPredicate.test(t)) continue;
            filteredList.add(t);
        }
        Class<?> arrayClass = array.getClass();
        return filteredList.toArray((Object[])Array.newInstance(arrayClass.getComponentType(), 0));
    }

    public static int getLength(Object[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static Object getValue(Object[] array, int pos) {
        if (array == null || array.length <= pos) {
            return null;
        }
        return array[pos];
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayUtil.isEmpty(array);
    }

    public static <T> void isNotEmptyForEach(T[] array, Consumer<T> consumer) {
        if (ArrayUtil.isNotEmpty(array)) {
            for (T t : array) {
                consumer.accept(t);
            }
        }
    }

    public static boolean[] remove(boolean[] array, boolean value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (boolean b : array) {
            if (value == b) continue;
            list.add(b);
        }
        return ArrayUtil.toArray(list.toArray(new Boolean[0]));
    }

    public static byte[] remove(byte[] array, byte value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (byte b : array) {
            if (value == b) continue;
            list.add(b);
        }
        return ArrayUtil.toArray(list.toArray(new Byte[0]));
    }

    public static char[] remove(char[] array, char value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Character> list = new ArrayList<Character>();
        for (char c : array) {
            if (value == c) continue;
            list.add(Character.valueOf(c));
        }
        return ArrayUtil.toArray(list.toArray(new Character[0]));
    }

    public static double[] remove(double[] array, double value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (double d : array) {
            if (value == d) continue;
            list.add(d);
        }
        return ArrayUtil.toArray(list.toArray(new Double[0]));
    }

    public static float[] remove(float[] array, float value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Float> list = new ArrayList<Float>();
        for (float f : array) {
            if (value == f) continue;
            list.add(Float.valueOf(f));
        }
        return ArrayUtil.toArray(list.toArray(new Float[0]));
    }

    public static int[] remove(int[] array, int value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i : array) {
            if (value == i) continue;
            list.add(i);
        }
        return ArrayUtil.toArray(list.toArray(new Integer[0]));
    }

    public static long[] remove(long[] array, long value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (long l : array) {
            if (value == l) continue;
            list.add(l);
        }
        return ArrayUtil.toArray(list.toArray(new Long[0]));
    }

    public static short[] remove(short[] array, short value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<Short> list = new ArrayList<Short>();
        for (short s : array) {
            if (value == s) continue;
            list.add(s);
        }
        return ArrayUtil.toArray(list.toArray(new Short[0]));
    }

    public static String[] remove(String[] array, String value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            if (s.equals(value)) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public static <T> T[] remove(T[] array, T value) {
        if (ArrayUtil.isEmpty(array)) {
            return array;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T object : array) {
            if (value == object) continue;
            list.add(object);
        }
        if (array.length == list.size()) {
            return array;
        }
        Class<?> arrayClass = array.getClass();
        return list.toArray((Object[])Array.newInstance(arrayClass.getComponentType(), 0));
    }

    public static String[] removeByPrefix(String[] array, String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            if (s.startsWith(prefix)) continue;
            list.add(s);
        }
        return list.toArray(new String[0]);
    }

    public static void replace(String[] values, String oldValue, String newValue) {
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(oldValue)) continue;
            values[i] = newValue;
        }
    }

    public static void reverse(boolean[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            boolean value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static void reverse(char[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            char value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static void reverse(double[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            double value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static void reverse(int[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            int value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static void reverse(long[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            long value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static void reverse(short[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            short value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static <T> void reverse(T[] array) {
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            T value = array[left];
            array[left] = array[right];
            array[right] = value;
        }
    }

    public static byte[] sortedUnique(byte[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static double[] sortedUnique(double[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static float[] sortedUnique(float[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static int[] sortedUnique(int[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static long[] sortedUnique(long[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static short[] sortedUnique(short[] array) {
        Arrays.sort(array);
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[index] == array[i] || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static String[] sortedUnique(String[] array) {
        Arrays.sort(array, Comparator.nullsLast(Comparator.naturalOrder()));
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (Objects.equals(array[index], array[i]) || ++index == i) continue;
            array[index] = array[i];
        }
        if (++index != array.length) {
            return Arrays.copyOf(array, index);
        }
        return array;
    }

    public static Object split(Object array, int splitSize) {
        int length = Array.getLength(array);
        int pageCount = length / splitSize;
        if (length % splitSize > 0) {
            // empty if block
        }
        Class<?> clazz = array.getClass();
        Class<?> componentType = clazz.getComponentType();
        Object newArray = Array.newInstance(componentType, ++pageCount, splitSize);
        if (pageCount == 1) {
            Array.set(newArray, 0, array);
            return newArray;
        }
        for (int i = 0; i < pageCount; ++i) {
            int end = Math.min(length, splitSize * (i + 1));
            int start = splitSize * i;
            int elementLength = end - start;
            Object element = Array.newInstance(componentType, elementLength);
            System.arraycopy(array, start, element, 0, elementLength);
            Array.set(newArray, i, element);
        }
        return newArray;
    }

    public static boolean[] subset(boolean[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        boolean[] newArray = new boolean[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static byte[] subset(byte[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        byte[] newArray = new byte[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static char[] subset(char[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        char[] newArray = new char[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static double[] subset(double[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        double[] newArray = new double[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static float[] subset(float[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        float[] newArray = new float[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static int[] subset(int[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        int[] newArray = new int[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static long[] subset(long[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        long[] newArray = new long[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static short[] subset(short[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        short[] newArray = new short[end - start];
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static <T> T[] subset(T[] array, int start, int end) {
        if (start < 0 || end < 0 || end - start < 0) {
            return array;
        }
        Class<?> arrayClass = array.getClass();
        Object[] newArray = (Object[])Array.newInstance(arrayClass.getComponentType(), end - start);
        System.arraycopy(array, start, newArray, 0, end - start);
        return newArray;
    }

    public static Boolean[] toArray(boolean[] array) {
        Boolean[] newArray = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static boolean[] toArray(Boolean[] array) {
        boolean[] newArray = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Byte[] toArray(byte[] array) {
        Byte[] newArray = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static byte[] toArray(Byte[] array) {
        byte[] newArray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Character[] toArray(char[] array) {
        Character[] newArray = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Character.valueOf(array[i]);
        }
        return newArray;
    }

    public static char[] toArray(Character[] array) {
        char[] newArray = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i].charValue();
        }
        return newArray;
    }

    public static Double[] toArray(double[] array) {
        Double[] newArray = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static double[] toArray(Double[] array) {
        double[] newArray = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Float[] toArray(float[] array) {
        Float[] newArray = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Float.valueOf(array[i]);
        }
        return newArray;
    }

    public static float[] toArray(Float[] array) {
        float[] newArray = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i].floatValue();
        }
        return newArray;
    }

    public static Integer[] toArray(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static int[] toArray(Integer[] array) {
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Long[] toArray(long[] array) {
        Long[] newArray = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static long[] toArray(Long[] array) {
        long[] newArray = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Short[] toArray(short[] array) {
        Short[] newArray = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static short[] toArray(Short[] array) {
        short[] newArray = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    @Deprecated
    public static String[] toArray(String[] array) {
        return (String[])array.clone();
    }

    public static <T, A> A[] toArray(T[] list, Accessor<T, A> accessor) {
        Object[] aArray = (Object[])Array.newInstance(accessor.getAttributeClass(), list.length);
        for (int i = 0; i < list.length; ++i) {
            aArray[i] = accessor.get(list[i]);
        }
        return aArray;
    }

    public static double[] toDoubleArray(Collection<? extends Number> collection) {
        double[] newArray = new double[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                newArray[i] = number.doubleValue();
            }
        } else {
            int i = 0;
            for (Number number : collection) {
                newArray[i++] = number.doubleValue();
            }
        }
        return newArray;
    }

    public static float[] toFloatArray(Collection<? extends Number> collection) {
        float[] newArray = new float[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                newArray[i] = number.floatValue();
            }
        } else {
            int i = 0;
            for (Number number : collection) {
                newArray[i++] = number.floatValue();
            }
        }
        return newArray;
    }

    public static int[] toIntArray(Collection<? extends Number> collection) {
        int[] newArray = new int[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                newArray[i] = number.intValue();
            }
        } else {
            int i = 0;
            for (Number number : collection) {
                newArray[i++] = number.intValue();
            }
        }
        return newArray;
    }

    public static long[] toLongArray(Collection<? extends Number> collection) {
        long[] newArray = new long[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                Number number = (Number)list.get(i);
                newArray[i] = number.longValue();
            }
        } else {
            int i = 0;
            for (Number number : collection) {
                newArray[i++] = number.longValue();
            }
        }
        return newArray;
    }

    public static Long[] toLongArray(int[] array) {
        Long[] newArray = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Long[] toLongArray(long[] array) {
        Long[] newArray = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static Long[] toLongArray(Object[] array) {
        Long[] newArray = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = (Long)array[i];
        }
        return newArray;
    }

    public static short[] toShortArray(Collection<Short> collection) {
        short[] newArray = new short[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                Short value = (Short)list.get(i);
                newArray[i] = value;
            }
        } else {
            int i = 0;
            for (Short value : collection) {
                newArray[i++] = value;
            }
        }
        return newArray;
    }

    public static String toString(Object[] array, String param) {
        return ArrayUtil.toString(array, param, ",");
    }

    public static String toString(Object[] array, String param, String delimiter) {
        return ArrayUtil.toString(array, param, delimiter, null);
    }

    public static String toString(Object[] array, String param, String delimiter, Locale locale) {
        if (ArrayUtil.isEmpty(array)) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * array.length - 1);
        for (int i = 0; i < array.length; ++i) {
            Object bean = array[i];
            Object value = null;
            value = Validator.isNull(param) ? String.valueOf(bean) : BeanPropertiesUtil.getObject(bean, param);
            if (value != null) {
                if (locale != null) {
                    sb.append(LanguageUtil.get(locale, value.toString()));
                } else {
                    sb.append(value);
                }
            }
            if (i + 1 == array.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static <T, A> String toString(T[] list, Accessor<T, A> accessor) {
        return ArrayUtil.toString(list, accessor, ",");
    }

    public static <T, A> String toString(T[] list, Accessor<T, A> accessor, String delimiter) {
        return ArrayUtil.toString(list, accessor, delimiter, null);
    }

    public static <T, A> String toString(T[] list, Accessor<T, A> accessor, String delimiter, Locale locale) {
        if (ArrayUtil.isEmpty(list)) {
            return "";
        }
        StringBundler sb = new StringBundler(2 * list.length - 1);
        for (int i = 0; i < list.length; ++i) {
            T bean = list[i];
            A attribute = accessor.get(bean);
            if (attribute != null) {
                if (locale != null) {
                    sb.append(LanguageUtil.get(locale, attribute.toString()));
                } else {
                    sb.append(attribute);
                }
            }
            if (i + 1 == list.length) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String[] toStringArray(boolean[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(byte[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(char[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(Collection<String> collection) {
        String[] newArray = new String[collection.size()];
        if (collection instanceof List) {
            List list = (List)collection;
            for (int i = 0; i < list.size(); ++i) {
                String value = (String)list.get(i);
                newArray[i] = String.valueOf(value);
            }
        } else {
            int i = 0;
            for (String value : collection) {
                newArray[i++] = String.valueOf(value);
            }
        }
        return newArray;
    }

    public static String[] toStringArray(Date[] array, DateFormat dateFormat) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = dateFormat.format(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(double[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(float[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(int[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(JSONArray jsonArray) {
        String[] newArray = new String[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            newArray[i] = jsonArray.getString(i);
        }
        return newArray;
    }

    public static String[] toStringArray(long[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(Object[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static String[] toStringArray(short[] array) {
        String[] newArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = String.valueOf(array[i]);
        }
        return newArray;
    }

    public static byte[] unique(byte[] array) {
        LinkedHashSet<Byte> set = new LinkedHashSet<Byte>();
        for (byte b : array) {
            set.add(b);
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Byte[0]));
    }

    public static double[] unique(double[] array) {
        LinkedHashSet<Double> set = new LinkedHashSet<Double>();
        for (double d : array) {
            set.add(d);
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Double[0]));
    }

    public static float[] unique(float[] array) {
        LinkedHashSet<Float> set = new LinkedHashSet<Float>();
        for (float f : array) {
            set.add(Float.valueOf(f));
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Float[0]));
    }

    public static int[] unique(int[] array) {
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        for (int i : array) {
            set.add(i);
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Integer[0]));
    }

    public static long[] unique(long[] array) {
        LinkedHashSet<Long> set = new LinkedHashSet<Long>();
        for (long l : array) {
            set.add(l);
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Long[0]));
    }

    public static short[] unique(short[] array) {
        LinkedHashSet<Short> set = new LinkedHashSet<Short>();
        for (short s : array) {
            set.add(s);
        }
        if (array.length == set.size()) {
            return array;
        }
        return ArrayUtil.toArray(set.toArray(new Short[0]));
    }

    public static String[] unique(String[] array) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String s : array) {
            set.add(s);
        }
        if (array.length == set.size()) {
            return array;
        }
        return set.toArray(new String[0]);
    }
}

