/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodNamingCheck
extends BaseCheck {
    private static final String _ENFORCE_TYPE_NAMES_KEY = "enforceTypeNames";
    private static final String[][] _METHOD_NAME_PREFIXS = new String[][]{{"do", ""}, {"get", "is"}};
    private static final String _MSG_INCORRECT_ENDING_METHOD = "method.incorrect.ending";
    private static final String _MSG_RENAME_METHOD = "method.rename";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return;
        }
        String methodName = this._getMethodName(detailAST);
        this._checkMethodNamePrefix(detailAST, methodName);
        this._checkTypeName(detailAST, methodName);
    }

    private void _checkMethodNamePrefix(DetailAST detailAST, String methodName) {
        String typeName = this.getTypeName(detailAST.findFirstToken(13), false);
        Matcher matcher = null;
        for (String[] array : _METHOD_NAME_PREFIXS) {
            Pattern pattern;
            if (array[0].equals("get") && !typeName.equals("boolean") || !(matcher = (pattern = Pattern.compile("^_" + array[0] + "([A-Z])(.*)$")).matcher(methodName)).find()) continue;
            String newMethodName = "_" + array[1];
            newMethodName = array[0].equals("get") ? newMethodName + matcher.group(1) : newMethodName + StringUtil.toLowerCase(matcher.group(1));
            newMethodName = newMethodName + matcher.group(2);
            String noUnderscoreMethodName = "";
            noUnderscoreMethodName = array[1].equals("") ? methodName.substring(1) : newMethodName.substring(1);
            DetailAST parentDetailAST = detailAST.getParent();
            List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(parentDetailAST, false, 9);
            for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
                String curMethodName = this._getMethodName(methodDefinitionDetailAST);
                if (!curMethodName.equals(noUnderscoreMethodName) && (!curMethodName.equals(newMethodName) || !Objects.equals(this.getSignature(detailAST), this.getSignature(methodDefinitionDetailAST)))) continue;
                return;
            }
            this.log(detailAST, _MSG_RENAME_METHOD, new Object[]{methodName, newMethodName});
        }
    }

    private void _checkTypeName(DetailAST detailAST, String methodName) {
        String absolutePath = this.getAbsolutePath();
        if (!(methodName.matches("get[A-Z].*") && absolutePath.contains("/internal/") || methodName.matches("_get[A-Z].*"))) {
            return;
        }
        String returnTypeName = this.getTypeName(detailAST, true);
        if (returnTypeName.contains("[]") || methodName.matches(".*" + returnTypeName + "[0-9]*") || methodName.matches("_?get" + returnTypeName + ".*")) {
            return;
        }
        List<String> enforceTypeNames = this.getAttributeValues(_ENFORCE_TYPE_NAMES_KEY);
        for (String enforceTypeName : enforceTypeNames) {
            if (!returnTypeName.matches(enforceTypeName)) continue;
            this.log(detailAST, _MSG_INCORRECT_ENDING_METHOD, new Object[]{returnTypeName});
            return;
        }
    }

    private String _getMethodName(DetailAST detailAST) {
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        return nameDetailAST.getText();
    }
}

