/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.IOException;

public class PropertiesWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("\t")) {
                    line = StringUtil.replace(line, '\t', "    ");
                }
                if (line.contains(" \t")) {
                    line = StringUtil.replace(line, " \t", "     ");
                }
                if (previousLine.matches("\\s*[^\\s#].*[,=]\\\\")) {
                    String leadingSpaces = this._getLeadingSpaces(line);
                    String expectedLeadingSpaces = this._getLeadingSpaces(previousLine);
                    if (previousLine.endsWith("=\\")) {
                        expectedLeadingSpaces = expectedLeadingSpaces + "    ";
                    }
                    if (!leadingSpaces.equals(expectedLeadingSpaces)) {
                        line = StringUtil.replaceFirst(line, leadingSpaces, expectedLeadingSpaces);
                    }
                    if (line.matches("    ]")) {
                        line = line.trim();
                    }
                }
                sb.append(line);
                sb.append("\n");
                previousLine = line;
            }
        }
        return super.doProcess(fileName, absolutePath, sb.toString());
    }

    @Override
    protected boolean isAllowTrailingSpaces(String line) {
        String trimmedLine = StringUtil.removeChar(line, ' ');
        return trimmedLine.endsWith("=");
    }

    private String _getLeadingSpaces(String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) == ' ') continue;
            return line.substring(0, i);
        }
        return line;
    }
}

