/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiAnnotationsOrderCheck
extends BaseFileCheck {
    private static final Pattern _annotationsPattern = Pattern.compile("(^\t*)(@.+?=.+?\n)(\\1(@.+?=.+?\n))+", 8);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        Matcher matcher = _annotationsPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            Object[] annotations = match.split("\n");
            Arrays.sort(annotations);
            StringBundler sb = new StringBundler(annotations.length * 2);
            for (Object annotation : annotations) {
                sb.append((String)annotation);
                sb.append("\n");
            }
            String sortedAnnotations = sb.toString();
            if (StringUtil.equals(match, sortedAnnotations)) continue;
            content = StringUtil.replaceFirst(content, match, sortedAnnotations, matcher.start());
        }
        return content;
    }
}

