/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class XMLServiceFinderNameCheck
extends BaseFileCheck {
    private static final Map<String, String> _comparatorNamesMap = HashMapBuilder.put("!=", "Not").put("<", "Lt").put("<=", "Lte").put("=", "").put(">", "Gt").put(">=", "Gte").put("is", "Is").put("LIKE", "Like").build();

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws DocumentException {
        if (!fileName.endsWith("/service.xml")) {
            return content;
        }
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        for (Element entityElement : rootElement.elements("entity")) {
            String entityName = entityElement.attributeValue("name");
            for (Element finderElement : entityElement.elements("finder")) {
                String finderName = finderElement.attributeValue("name");
                ArrayList<Map<String, String>> finderColumns = new ArrayList<Map<String, String>>();
                for (Element finderColumnElement : finderElement.elements("finder-column")) {
                    LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
                    String comparator = finderColumnElement.attributeValue("comparator");
                    if (Validator.isNotNull(comparator)) {
                        attributesMap.put("comparator", finderColumnElement.attributeValue("comparator"));
                    }
                    attributesMap.put("name", finderColumnElement.attributeValue("name"));
                    finderColumns.add(attributesMap);
                }
                this._checkFinderName(fileName, entityName, finderName, finderColumns);
            }
        }
        return content;
    }

    private void _checkFinderName(String fileName, String entityName, String finderName, List<Map<String, String>> finderColumns) {
        if (finderColumns.size() == 1) {
            Map<String, String> finderColumn = finderColumns.get(0);
            if (!finderColumn.containsKey("name")) {
                return;
            }
            String expectedFinderName = TextFormatter.format(finderColumn.get("name"), 6);
            if (finderColumn.containsKey("comparator")) {
                expectedFinderName = _comparatorNamesMap.get(finderColumn.get("comparator")) + expectedFinderName;
            }
            if (!expectedFinderName.equals(finderName)) {
                this.addMessage(fileName, StringBundler.concat("Finder name '", entityName, "#", finderName, "' should be combined by comparator prefix and finder ", "colume name"));
            }
            return;
        }
        List<String> splitFinderNames = ListUtil.fromString(finderName, "_");
        Collections.sort(splitFinderNames);
        block0: for (Map<String, String> finderColumn : finderColumns) {
            if (!finderColumn.containsKey("name")) continue;
            String finderColumnName = finderColumn.get("name");
            finderColumnName = StringUtil.upperCase(finderColumnName.substring(0, 1));
            String expectedFinderName = "";
            if (finderColumn.containsKey("comparator")) {
                expectedFinderName = expectedFinderName + _comparatorNamesMap.get(finderColumn.get("comparator"));
            }
            expectedFinderName = expectedFinderName + finderColumnName;
            for (String splitFinderName : splitFinderNames) {
                if (!splitFinderName.startsWith(expectedFinderName)) continue;
                splitFinderNames.remove(splitFinderName);
                continue block0;
            }
            this.addMessage(fileName, StringBundler.concat("Finder name '", entityName, "#", finderName, "' should be combined by finder colume names(", "at least the first character) following by each ", "comparator prefix with delimiter '_'"));
        }
    }
}

