/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseUnnecessaryStatementCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class UnnecessaryVariableDeclarationCheck
extends BaseUnnecessaryStatementCheck {
    private static final String _MSG_UNNECESSARY_LIST_DECLARATION_BEFORE_RETURN = "list.declaration.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_REASSIGN = "variable.declaration.unnecessary.before.reassign";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_RETURN = "variable.declaration.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_VARIABLE_DECLARATION_TO_STRING = "variable.declaration.unnecessary.to.string";

    public int[] getDefaultTokens() {
        return new int[]{10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST nameDetailAST = detailAST.findFirstToken(58);
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST.branchContains(159)) {
            return;
        }
        DetailAST semiDetailAST = detailAST.getNextSibling();
        if (semiDetailAST == null || semiDetailAST.getType() != 45) {
            return;
        }
        String variableName = nameDetailAST.getText();
        if (!this.isExcludedPath("run.outside.portal.excludes")) {
            this._checkUnnecessaryListVariableDeclarationBeforeReturn(detailAST, semiDetailAST, variableName);
        }
        this.checkUnnecessaryStatementBeforeReturn(detailAST, semiDetailAST, variableName, _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_RETURN);
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 7) {
            return;
        }
        this.checkUnnecessaryToString(detailAST.findFirstToken(80), _MSG_UNNECESSARY_VARIABLE_DECLARATION_TO_STRING);
        List<DetailAST> variableCallerDetailASTList = this.getVariableCallerDetailASTList(detailAST, variableName);
        if (variableCallerDetailASTList.isEmpty()) {
            return;
        }
        DetailAST firstVariableCallerDetailAST = variableCallerDetailASTList.get(0);
        DetailAST secondVariableCallerDetailAST = null;
        if (variableCallerDetailASTList.size() > 1) {
            secondVariableCallerDetailAST = variableCallerDetailASTList.get(1);
        }
        this.checkUnnecessaryStatementBeforeReassign(detailAST, firstVariableCallerDetailAST, secondVariableCallerDetailAST, parentDetailAST, variableName, _MSG_UNNECESSARY_VARIABLE_DECLARATION_BEFORE_REASSIGN);
    }

    private void _checkUnnecessaryListVariableDeclarationBeforeReturn(DetailAST detailAST, DetailAST semiDetailAST, String variableName) {
        String variableTypeName = this.getVariableTypeName(detailAST, variableName, false);
        if (!variableTypeName.equals("List") || !this.isAssignNewArrayList(detailAST)) {
            return;
        }
        DetailAST nextSiblingDetailAST = semiDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null) {
            return;
        }
        while (nextSiblingDetailAST.getType() == 28) {
            DetailAST firstChildDetailAST = nextSiblingDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 27) {
                return;
            }
            if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 59) {
                return;
            }
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            String fullyQualifiedName = fullIdent.getText();
            if (!fullyQualifiedName.equals(variableName + ".add")) {
                return;
            }
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) != null && nextSiblingDetailAST.getType() != 45) {
                return;
            }
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
                return;
            }
            if (nextSiblingDetailAST.getType() == 28) continue;
            if (nextSiblingDetailAST.getType() == 88) {
                firstChildDetailAST = nextSiblingDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() != 28) {
                    return;
                }
                if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 58 && variableName.equals(firstChildDetailAST.getText())) {
                    this.log(detailAST, _MSG_UNNECESSARY_LIST_DECLARATION_BEFORE_RETURN, new Object[]{variableName});
                }
            }
            return;
        }
    }
}

