/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MethodCallsOrderCheck
extends BaseFileCheck {
    private static final Pattern _typeNamePattern = Pattern.compile("(\\A|\\W)(\\w+)\\.\\w+\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._sortMethodCalls(fileName, content);
    }

    private String _getMethodCall(String content, int start) {
        String methodCall;
        int end = start;
        do {
            if ((end = content.indexOf(");\n", end + 1)) != -1) continue;
            return null;
        } while (this.getLevel(methodCall = content.substring(start, end + 3)) != 0);
        return methodCall;
    }

    private String _getSortedCodeBlock(String codeBlock, String methodCall) {
        String previousParameterName = null;
        String previousParameters = null;
        ParameterNameComparator parameterNameComparator = new ParameterNameComparator();
        int x = 0;
        String s;
        while ((s = StringUtil.trim(codeBlock.substring(x))).startsWith(methodCall)) {
            int compare;
            String parameters = null;
            int y = x = codeBlock.indexOf(40, x + 1);
            do {
                if ((y = codeBlock.indexOf(41, y + 1)) != -1) continue;
                return codeBlock;
            } while (ToolsUtil.getLevel(s = codeBlock.substring(x, y + 1), "(", ")") != 0 || ToolsUtil.getLevel(s, "{", "}") != 0);
            if (codeBlock.charAt(y + 1) != ';') {
                return codeBlock;
            }
            parameters = codeBlock.substring(x + 1, y);
            x = y + 2;
            List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
            String parameterName = parametersList.get(0);
            if (previousParameterName != null && (compare = parameterNameComparator.compare(previousParameterName, parameterName)) > 0) {
                String sortedCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                return StringUtil.replaceLast(sortedCodeBlock, parameters, previousParameters);
            }
            previousParameterName = parameterName;
            previousParameters = parameters;
        }
        return codeBlock;
    }

    private String _getTypeName(String content, int lineNumber) {
        int level = 0;
        while (lineNumber != 0) {
            String trimmedLine = StringUtil.trim(this.getLine(content, lineNumber));
            if (trimmedLine.endsWith("(") && level == 0) {
                if (trimmedLine.startsWith(").")) {
                    level -= this.getLevel(trimmedLine);
                    --lineNumber;
                    continue;
                }
                Matcher matcher = _typeNamePattern.matcher(trimmedLine);
                if (matcher.find()) {
                    return matcher.group(2);
                }
                return null;
            }
            level -= this.getLevel(trimmedLine);
            --lineNumber;
        }
        return null;
    }

    private boolean _isAllowedVariableType(String content, String variableName, String[] variableTypeNames) {
        if (variableName == null) {
            return false;
        }
        if (variableTypeNames.length == 0) {
            return true;
        }
        for (String variableTypeName : variableTypeNames) {
            if (variableName.matches(variableTypeName)) {
                return true;
            }
            StringBundler sb = new StringBundler(5);
            sb.append("\\W");
            sb.append(variableTypeName);
            sb.append("(<.*>|\\(\\))?\\s+");
            sb.append(variableName);
            sb.append("\\W");
            Pattern pattern = Pattern.compile(sb.toString());
            Matcher matcher = pattern.matcher(content);
            if (matcher.find()) {
                return true;
            }
            sb = new StringBundler(5);
            sb.append("\\W");
            sb.append(variableName);
            sb.append(" =\\s+new ");
            sb.append(variableTypeName);
            sb.append("(<.*>|\\(\\))");
            pattern = Pattern.compile(sb.toString());
            matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String _sortAnonymousClassMethodCalls(String content, String methodName, String ... variableTypeNames) {
        for (String variableTypeName : variableTypeNames) {
            Pattern pattern = Pattern.compile("\\Wnew " + variableTypeName + "[(<][^;]*?\\) \\{\n");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String sortedCodeBlock;
                String codeBlock;
                int x;
                int y;
                int lineNumber = this.getLineNumber(content, matcher.end() - 1);
                if (!Objects.equals(StringUtil.trim(this.getLine(content, lineNumber + 1)), "{") || (y = content.indexOf("\t}\n", x = this.getLineStartPos(content, lineNumber + 2))) == -1) continue;
                int z = content.indexOf("\n\n", x);
                if (z != -1 && z < y) {
                    y = z;
                }
                if ((codeBlock = content.substring(x, y)).equals(sortedCodeBlock = this._getSortedCodeBlock(codeBlock, methodName + "("))) continue;
                return StringUtil.replaceFirst(content, codeBlock, sortedCodeBlock, matcher.start());
            }
        }
        return content;
    }

    private String _sortChainedMethodCalls(String content, String methodName, int expectedParameterCount, String ... variableTypeNames) {
        if (!content.contains("." + methodName + "(")) {
            return content;
        }
        Pattern pattern = Pattern.compile(StringBundler.concat("(\\W(\\w+)\\.(<[\\w\\[\\]\\?<>, ]*>)?|[\n\t]\\)\\.)", methodName, "\\("));
        Matcher matcher = pattern.matcher(content);
        ParameterNameComparator parameterNameComparator = new ParameterNameComparator();
        block0: while (matcher.find()) {
            String typeName = matcher.group(2);
            if (typeName == null) {
                typeName = this._getTypeName(content, this.getLineNumber(content, matcher.start()));
            }
            if (!this._isAllowedVariableType(content, typeName, variableTypeNames)) continue;
            String previousParameterName = null;
            String previousParameters = null;
            int x = matcher.end() - 1;
            while (true) {
                int compare;
                String parameters = null;
                int y = x;
                do {
                    if ((y = content.indexOf(")", y + 1)) != -1) continue;
                    return content;
                } while (this.getLevel(content.substring(x, y + 1)) != 0);
                parameters = content.substring(x + 1, y);
                List<String> parametersList = JavaSourceUtil.splitParameters(parameters);
                if (parametersList.size() != expectedParameterCount) continue block0;
                String parameterName = parametersList.get(0);
                if (previousParameterName != null && (compare = parameterNameComparator.compare(previousParameterName, parameterName)) > 0) {
                    String codeBlock = content.substring(matcher.start(), y + 1);
                    String newCodeBlock = StringUtil.replaceFirst(codeBlock, previousParameters, parameters);
                    newCodeBlock = StringUtil.replaceLast(newCodeBlock, parameters, previousParameters);
                    return StringUtil.replaceFirst(content, codeBlock, newCodeBlock, matcher.start());
                }
                String s = StringUtil.trim(content.substring(y + 1));
                if (!s.startsWith("." + methodName + "(")) continue block0;
                previousParameterName = parameterName;
                previousParameters = parameters;
                x = content.indexOf("(", y + 1);
            }
        }
        return content;
    }

    private String _sortMethodCalls(String fileName, String content) {
        content = this._sortChainedMethodCalls(content, "put", 2, "ConcurrentHashMapBuilder", "HashMapBuilder", "JSONObject", "JSONUtil", "SoyContext", "TreeMapBuilder");
        content = this._sortChainedMethodCalls(content, "setParameter", 2, "PortletURLBuilder");
        content = this._sortMethodCallsByMethodName(content, "DropdownItem", "LabelItem", "NavigationItem", "SearchContext", "ServiceContext");
        content = this._sortMethodCallsByParameter(fileName, content, "add", "ConcurrentSkipListSet", "HashSet", "TreeSet");
        content = this._sortMethodCallsByParameter(fileName, content, "put", "ConcurrentHashMap", "HashMap", "JSONObject", "SortedMap", "TreeMap");
        content = this._sortMethodCallsByParameter(fileName, content, "setAttribute", new String[0]);
        return content;
    }

    private String _sortMethodCallsByMethodName(String content, String ... variableTypeNames) {
        MethodCallComparator methodCallComparator = new MethodCallComparator();
        for (String variableTypeName : variableTypeNames) {
            Pattern pattern = Pattern.compile("\n(\t+\\w*" + variableTypeName + "\\.)(\\w+)\\(", 2);
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String methodCall2;
                int x;
                String followingContent;
                String methodCall1 = this._getMethodCall(content, matcher.start(1));
                if (methodCall1 == null || !(followingContent = content.substring(x = matcher.start(1) + methodCall1.length())).startsWith(matcher.group(1)) || (methodCall2 = this._getMethodCall(content, x)) == null || methodCallComparator.compare(methodCall1, methodCall2) <= 0) continue;
                content = StringUtil.replaceFirst(content, methodCall2, methodCall1, matcher.start());
                return StringUtil.replaceFirst(content, methodCall1, methodCall2, matcher.start());
            }
        }
        return content;
    }

    private String _sortMethodCallsByParameter(String fileName, String content, String methodName, String ... variableTypeNames) {
        if (!(content = this._sortAnonymousClassMethodCalls(content, methodName, variableTypeNames)).contains("." + methodName + "(")) {
            return content;
        }
        Pattern pattern = Pattern.compile("[^;]\n\t+((\\w*)\\." + methodName + "\\()");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String sortedCodeBlock;
            String codeBlock;
            if (!this._isAllowedVariableType(content, matcher.group(2), variableTypeNames) || (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) && !JSPSourceUtil.isJavaSource(content, matcher.start())) continue;
            int x = content.indexOf("\n\n", matcher.end());
            if (x == -1) {
                x = content.length();
            }
            if ((codeBlock = content.substring(matcher.start() + 2, x)).equals(sortedCodeBlock = this._getSortedCodeBlock(codeBlock, matcher.group(1)))) continue;
            return StringUtil.replaceFirst(content, codeBlock, sortedCodeBlock, matcher.start());
        }
        return content;
    }

    private class ParameterNameComparator
    extends NaturalOrderStringComparator {
        private final Pattern _multipleLineConstantPattern = Pattern.compile("\\.\n\t+");
        private final Pattern _multipleLineParameterNamePattern = Pattern.compile("\" \\+\n\t+\"");

        private ParameterNameComparator() {
        }

        @Override
        public int compare(String parameterName1, String parameterName2) {
            Matcher matcher = this._multipleLineConstantPattern.matcher(parameterName1);
            parameterName1 = matcher.replaceAll(".");
            matcher = this._multipleLineConstantPattern.matcher(parameterName2);
            parameterName2 = matcher.replaceAll(".");
            String strippedParameterName1 = MethodCallsOrderCheck.this.stripQuotes(parameterName1);
            String strippedParameterName2 = MethodCallsOrderCheck.this.stripQuotes(parameterName2);
            if (strippedParameterName1.contains("(") || strippedParameterName2.contains("(")) {
                return 0;
            }
            matcher = this._multipleLineParameterNamePattern.matcher(parameterName1);
            if (matcher.find()) {
                parameterName1 = matcher.replaceAll("");
            }
            if ((matcher = this._multipleLineParameterNamePattern.matcher(parameterName2)).find()) {
                parameterName2 = matcher.replaceAll("");
            }
            if (parameterName1.matches("\".*\"") && parameterName2.matches("\".*\"")) {
                String strippedQuotes1 = parameterName1.substring(1, parameterName1.length() - 1);
                String strippedQuotes2 = parameterName2.substring(1, parameterName2.length() - 1);
                return super.compare(strippedQuotes1, strippedQuotes2);
            }
            int value = super.compare(parameterName1, parameterName2);
            if (parameterName1.startsWith("\"") ^ parameterName2.startsWith("\"")) {
                return -value;
            }
            return value;
        }
    }

    private class MethodCallComparator
    extends ParameterNameComparator {
        private MethodCallComparator() {
        }

        @Override
        public int compare(String methodCall1, String methodCall2) {
            String methodName2;
            String methodName1 = this._getMethodName(methodCall1);
            if (!methodName1.equals(methodName2 = this._getMethodName(methodCall2))) {
                return methodName1.compareTo(methodName2);
            }
            List<String> parameterList1 = JavaSourceUtil.getParameterList(methodCall1);
            List<String> parameterList2 = JavaSourceUtil.getParameterList(methodCall2);
            return super.compare(parameterList1.get(0), parameterList2.get(0));
        }

        private String _getMethodName(String methodCall) {
            int x = methodCall.indexOf(46);
            int y = methodCall.indexOf(40);
            return methodCall.substring(x + 1, y);
        }
    }
}

