/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseStringConcatenationCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.List;

public class PlusStatementCheck
extends BaseStringConcatenationCheck {
    public int[] getDefaultTokens() {
        return new int[]{125};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkPlusOperator(detailAST);
    }

    private void _checkLiteralStrings(DetailAST detailAST, DetailAST leftHandOperandDetailAST, DetailAST rightHandOperandDetailAST) {
        String trimmedLine2;
        String value1 = this.getStringValue(leftHandOperandDetailAST);
        String value2 = this.getStringValue(rightHandOperandDetailAST);
        if (rightHandOperandDetailAST.getLineNo() == leftHandOperandDetailAST.getLineNo()) {
            this.log(leftHandOperandDetailAST, "literal.string.combine", new Object[]{value1, value2});
            return;
        }
        if (this._isRegexPattern(detailAST)) {
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(value1, value2, detailAST.getLineNo());
        String line1 = this.getLine(rightHandOperandDetailAST.getLineNo() - 2);
        String line2 = this.getLine(rightHandOperandDetailAST.getLineNo() - 1);
        if (this._getLeadingTabCount(line1) == this._getLeadingTabCount(line2)) {
            return;
        }
        int lineLength1 = CommonUtil.lengthExpandedTabs((String)line1, (int)line1.length(), (int)this.getTabWidth());
        if (lineLength1 + (trimmedLine2 = StringUtil.trim(line2)).length() - 4 <= this.getMaxLineLength()) {
            this.log(rightHandOperandDetailAST, "literal.string.combine", new Object[]{value1, value2});
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() == 125 && lineLength1 + value2.length() <= this.getMaxLineLength()) {
            this.log(detailAST, "literal.string.combine", new Object[]{value1, value2});
            return;
        }
        int pos = this.getStringBreakPos(value1, value2, this.getMaxLineLength() - lineLength1);
        if (pos != -1) {
            this.log(rightHandOperandDetailAST, "literal.string.move", new Object[]{value2.substring(0, pos + 1), "previous"});
        }
        this.checkLiteralStringBreaks(rightHandOperandDetailAST, line1, line2, value1, value2);
    }

    private void _checkPlusOperator(DetailAST detailAST) {
        if (detailAST.getChildCount() != 2) {
            return;
        }
        DetailAST leftHandOperandDetailAST = this._getOperandDetailAST(detailAST.getFirstChild());
        DetailAST rightHandOperandDetailAST = this._getOperandDetailAST(detailAST.getLastChild());
        if (leftHandOperandDetailAST.getType() == 139 && rightHandOperandDetailAST.getType() == 139) {
            this._checkLiteralStrings(detailAST, leftHandOperandDetailAST, rightHandOperandDetailAST);
            return;
        }
        if (leftHandOperandDetailAST.getType() == 139) {
            this.checkCombineOperand(leftHandOperandDetailAST, rightHandOperandDetailAST);
        } else if (rightHandOperandDetailAST.getType() == 139) {
            this.checkCombineOperand(rightHandOperandDetailAST, leftHandOperandDetailAST);
        }
    }

    private int _getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private DetailAST _getOperandDetailAST(DetailAST detailAST) {
        if (detailAST.getType() == 125) {
            return detailAST.getLastChild();
        }
        return detailAST;
    }

    private boolean _isRegexPattern(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (parentDetailAST.getType() != 27) {
                continue;
            }
            DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 59) {
                return false;
            }
            List<DetailAST> nameDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 58);
            if (nameDetailASTList.size() != 2) {
                return false;
            }
            DetailAST classNameDetailAST = nameDetailASTList.get(0);
            DetailAST methodNameDetailAST = nameDetailASTList.get(1);
            String methodCallClassName = classNameDetailAST.getText();
            String methodCallMethodName = methodNameDetailAST.getText();
            return methodCallMethodName.equals("matches") || methodCallClassName.equals("Pattern") && methodCallMethodName.equals("compile");
        }
        return false;
    }
}

