/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiStylingCheck
extends BaseFileCheck {
    private static final Pattern _multiLineCommentsPattern = Pattern.compile("[ \t]/\\*.*?\\*/", 32);
    private static final Pattern _multiLineStringPattern = Pattern.compile("'''.*?'''", 32);
    private static final Pattern _propertyPattern = Pattern.compile("(?<=\n)(\t+property .+;\n+)+");
    private static final Pattern _singleLineCommentPattern = Pattern.compile("^([ \t]*)// *(\t*.*)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        this._checkLineBreak(fileName, content);
        content = this._formatComments(content);
        return this._formatProperties(content);
    }

    private void _checkLineBreak(String fileName, String content) {
        int x = -1;
        int[] multiLineCommentsPositions = SourceUtil.getMultiLinePositions(content, _multiLineCommentsPattern);
        int[] multiLineStringPositions = SourceUtil.getMultiLinePositions(content, _multiLineStringPattern);
        while ((x = content.indexOf(59, x + 1)) != -1) {
            int lineNumber = this.getLineNumber(content, x);
            String line = this.getLine(content, lineNumber);
            if (content.charAt(x + 1) == '\n' || ToolsUtil.isInsideQuotes(content, x) || SourceUtil.isInsideMultiLines(lineNumber, multiLineCommentsPositions) || SourceUtil.isInsideMultiLines(lineNumber, multiLineStringPositions) || StringUtil.startsWith(line.trim(), "//")) continue;
            this.addMessage(fileName, "There should be a line break after ';'", this.getLineNumber(content, x));
        }
        return;
    }

    private String _formatComments(String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String newComment = "";
            String previousComment = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                Matcher matcher = _singleLineCommentPattern.matcher(line);
                if (!matcher.find()) {
                    previousComment = "";
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String comment = matcher.group(2);
                if (Validator.isNull(comment)) {
                    previousComment = "";
                    continue;
                }
                String indent = matcher.group(1);
                if (comment.startsWith("Ignore") || comment.startsWith("Ignoring") || comment.startsWith("Quarantine") || comment.startsWith("TODO") || comment.startsWith("Workaround") || !comment.endsWith(",") && !comment.endsWith("{") && !comment.endsWith("(") && !comment.endsWith(";") && !comment.equals("}") || comment.endsWith(",") && !comment.contains(" = ")) {
                    String trimmedComment = comment.trim();
                    if (!previousComment.startsWith("// ")) {
                        String upperCaseFirstChar = StringUtil.toUpperCase(trimmedComment.substring(0, 1));
                        trimmedComment = upperCaseFirstChar + trimmedComment.substring(1);
                    }
                    if (previousComment.matches("//[^ ].+")) {
                        sb.append("\n");
                    }
                    newComment = "// " + trimmedComment;
                } else {
                    if (previousComment.startsWith("// ")) {
                        sb.append("\n");
                    }
                    newComment = "//" + comment;
                }
                sb.append(indent);
                sb.append(newComment);
                sb.append("\n");
                previousComment = newComment;
            }
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private String _formatProperties(String content) {
        Matcher matcher = _propertyPattern.matcher(content);
        while (matcher.find()) {
            String properties = matcher.group();
            List<String> propertiesList = ListUtil.fromArray(properties.split("\n"));
            Collections.sort(propertiesList);
            StringBundler sb = new StringBundler(propertiesList.size() * 2 + 1);
            for (String property : propertiesList) {
                sb.append(property);
                sb.append("\n");
            }
            sb.append("\n");
            String newProperties = sb.toString();
            if (properties.equals(newProperties)) continue;
            return StringUtil.replaceFirst(content, properties, newProperties, matcher.start());
        }
        return content;
    }
}

