/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.BaseMapWrapper;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HashMapBuilder<K, V>
extends BaseMapBuilder {
    public static <K, V> HashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
        HashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>> hashMapWrapper = new HashMapWrapper<Collection<? extends K>, BaseMapBuilder.UnsafeFunction<K, V, Exception>>();
        return hashMapWrapper.put(inputCollection, unsafeFunction);
    }

    public static <K, V> HashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        HashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> hashMapWrapper = new HashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return hashMapWrapper.put(key, valueUnsafeSupplier);
    }

    public static <K, V> HashMapWrapper<K, V> put(K key, V value) {
        HashMapWrapper<K, V> hashMapWrapper = new HashMapWrapper<K, V>();
        return hashMapWrapper.put(key, value);
    }

    public static <K, V> HashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
        HashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>> hashMapWrapper = new HashMapWrapper<K, BaseMapBuilder.UnsafeSupplier<V, Exception>>();
        return hashMapWrapper.put(keyUnsafeSupplier, valueUnsafeSupplier);
    }

    public static <K, V> HashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
        HashMapWrapper<K, V> hashMapWrapper = new HashMapWrapper<K, V>();
        return hashMapWrapper.put(keyUnsafeSupplier, value);
    }

    public static <K, V> HashMapWrapper<K, V> putAll(Dictionary<? extends K, ? extends V> dictionary) {
        HashMapWrapper<? extends K, ? extends V> hashMapWrapper = new HashMapWrapper<K, V>();
        return hashMapWrapper.putAll(dictionary);
    }

    public static <K, V> HashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
        HashMapWrapper<? extends K, ? extends V> hashMapWrapper = new HashMapWrapper<K, V>();
        return hashMapWrapper.putAll(inputMap);
    }

    public static final class HashMapWrapper<K, V>
    extends BaseMapWrapper<K, V> {
        private final HashMap<K, V> _hashMap = new HashMap();

        public HashMap<K, V> build() {
            return this._hashMap;
        }

        public HashMapWrapper<K, V> put(Collection<? extends K> inputCollection, BaseMapBuilder.UnsafeFunction<K, V, Exception> unsafeFunction) {
            this.doPut(inputCollection, unsafeFunction);
            return this;
        }

        public HashMapWrapper<K, V> put(K key, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(key, valueUnsafeSupplier);
            return this;
        }

        public HashMapWrapper<K, V> put(K key, V value) {
            this._hashMap.put(key, value);
            return this;
        }

        public HashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, BaseMapBuilder.UnsafeSupplier<V, Exception> valueUnsafeSupplier) {
            this.doPut(keyUnsafeSupplier, valueUnsafeSupplier);
            return this;
        }

        public HashMapWrapper<K, V> put(BaseMapBuilder.UnsafeSupplier<K, Exception> keyUnsafeSupplier, V value) {
            this.doPut(keyUnsafeSupplier, value);
            return this;
        }

        public HashMapWrapper<K, V> putAll(Dictionary<? extends K, ? extends V> dictionary) {
            if (dictionary == null) {
                return this;
            }
            Enumeration<K> enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                K key = enumeration.nextElement();
                this._hashMap.put(key, dictionary.get(key));
            }
            return this;
        }

        public HashMapWrapper<K, V> putAll(Map<? extends K, ? extends V> inputMap) {
            this.doPutAll(inputMap);
            return this;
        }

        @Override
        protected HashMap<K, V> getMap() {
            return this._hashMap;
        }
    }
}

