/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SubstringCheck
extends BaseFileCheck {
    private static final Pattern _substringPattern = Pattern.compile("\\W([a-z][\\w]*)\\.substring\\(");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        Matcher matcher = _substringPattern.matcher(content);
        while (matcher.find()) {
            String variableName;
            String secondParameter;
            String match;
            List<String> parameterList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start(1)) || (parameterList = JavaSourceUtil.getParameterList(match = content.substring(matcher.start(1)))).size() != 2 || !(secondParameter = StringUtil.trim(parameterList.get(1))).equals((variableName = matcher.group(1)) + ".length()")) continue;
            String replacement = match.replaceFirst(",\\s*" + variableName + "\\.length\\(\\)", "");
            return StringUtil.replaceLast(content, match, replacement);
        }
        return content;
    }
}

