/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import java.util.Objects;

public abstract class BaseAsUsedCheck
extends BaseCheck {
    private static final String _MSG_INLINE_VARIABLE = "variable.inline";
    private static final String _MSG_MOVE_VARIABLE_AFTER_BRANCHING_STATEMENT = "variable.move.after.branching.statement";
    private static final String _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT = "variable.move.inside.if.statement";

    protected void checkInline(DetailAST assignDetailAST, String variableName, DetailAST assignMethodCallDetailAST, DetailAST identDetailAST, List<DetailAST> dependentIdentDetailASTList) {
        if (assignMethodCallDetailAST == null || !variableName.equals(identDetailAST.getText()) || this._isInsideMockitoMethodCall(identDetailAST)) {
            return;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() == 132) {
            parentDetailAST = parentDetailAST.getParent();
        }
        if (parentDetailAST.getType() != 28) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(assignDetailAST);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            if (!variableName.equals(dependentIdentDetailAST.getText()) || this.equals(dependentIdentDetailAST, identDetailAST) || dependentIdentDetailAST.getLineNo() <= endLineNumber) continue;
            return;
        }
        if (this._hasChainStyle(assignMethodCallDetailAST, "build", "create.*", "map", "put")) {
            if (this._isInsideStatementClause(identDetailAST)) {
                return;
            }
        } else {
            if (this.getStartLineNumber(assignMethodCallDetailAST) != this.getEndLineNumber(assignMethodCallDetailAST) || this._isInsideStatementClause(identDetailAST) && this.hasParentWithTokenType(identDetailAST, RELATIONAL_OPERATOR_TOKEN_TYPES)) {
                return;
            }
            if (!this._matchesGetOrSetCall(assignMethodCallDetailAST, identDetailAST, variableName)) {
                return;
            }
        }
        if ((parentDetailAST = this.getParentWithTokenType(identDetailAST, 181, 85, 91, 136, 67, 95, 84)) != null && parentDetailAST.getLineNo() >= assignDetailAST.getLineNo()) {
            return;
        }
        int emptyLineCount = 0;
        for (int i = endLineNumber; i <= identDetailAST.getLineNo(); ++i) {
            if (!Validator.isNull(this.getLine(i - 1)) || ++emptyLineCount <= 1) continue;
            return;
        }
        this.log(assignDetailAST, _MSG_INLINE_VARIABLE, new Object[]{variableName, identDetailAST.getLineNo()});
    }

    protected void checkMoveAfterBranchingStatement(DetailAST detailAST, DetailAST assignDetailAST, String variableName, DetailAST firstDependentIdentDetailAST) {
        int endLineNumber = this.getEndLineNumber(assignDetailAST);
        DetailAST lastBranchingStatementDetailAST = this._getLastBranchingStatementDetailAST(detailAST, endLineNumber, this._getClosestParentLineNumber(firstDependentIdentDetailAST, endLineNumber));
        if (lastBranchingStatementDetailAST != null) {
            this.log(assignDetailAST, _MSG_MOVE_VARIABLE_AFTER_BRANCHING_STATEMENT, new Object[]{variableName, lastBranchingStatementDetailAST.getText(), lastBranchingStatementDetailAST.getLineNo()});
        }
    }

    protected void checkMoveInsideIfStatement(DetailAST assignDetailAST, DetailAST nameDetailAST, String variableName, DetailAST firstDependentIdentDetailAST, DetailAST lastDependentIdentDetailAST) {
        DetailAST elseOrIfStatementDetailAST = this._getElseOrIfStatementDetailAST(firstDependentIdentDetailAST, this.getEndLineNumber(assignDetailAST));
        if (elseOrIfStatementDetailAST == null) {
            return;
        }
        DetailAST parentDetailAST = this.getParentWithTokenType(elseOrIfStatementDetailAST, 181, 85, 91, 136, 67, 95, 84);
        if (parentDetailAST != null && parentDetailAST.getLineNo() >= assignDetailAST.getLineNo()) {
            return;
        }
        DetailAST slistDetailAST = elseOrIfStatementDetailAST.findFirstToken(7);
        if (this.getEndLineNumber(slistDetailAST) <= lastDependentIdentDetailAST.getLineNo()) {
            return;
        }
        if (elseOrIfStatementDetailAST.getType() == 92) {
            this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "else", elseOrIfStatementDetailAST.getLineNo()});
        } else {
            parentDetailAST = elseOrIfStatementDetailAST.getParent();
            if (parentDetailAST.getType() == 92) {
                this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "else if", elseOrIfStatementDetailAST.getLineNo()});
            } else {
                this.log(nameDetailAST, _MSG_MOVE_VARIABLE_INSIDE_IF_STATEMENT, new Object[]{variableName, "if", elseOrIfStatementDetailAST.getLineNo()});
            }
        }
    }

    protected boolean checkMoveStatement(DetailAST detailAST, int lineNumber) {
        String actionNameRegex = StringBundler.concat("_?(add|channel|close|copy|create|delete|execute|import|", "increment|manage|next|open|post|put|read|register|", "resolve|run|send|test|transform|unzip|update|upsert|zip)", "([A-Z].*)?");
        if (this._containsMethodName(detailAST, actionNameRegex, "currentTimeMillis", "nextVersion", "toString") || this._containsVariableType(detailAST, "ActionQueue", "File")) {
            return false;
        }
        if (detailAST.getType() != 10) {
            return true;
        }
        List<DetailAST> dependentIdentDetailASTList = this.getDependentIdentDetailASTList(detailAST, detailAST.getLineNo(), true);
        for (DetailAST dependentIdentDetailAST : dependentIdentDetailASTList) {
            String methodName;
            DetailAST parentDetailAST;
            if (dependentIdentDetailAST.getLineNo() > lineNumber) {
                return true;
            }
            DetailAST elistDetailAST = this.getParentWithTokenType(dependentIdentDetailAST, 34);
            if (elistDetailAST == null || (parentDetailAST = elistDetailAST.getParent()).getType() != 27 || !(methodName = this.getMethodName(parentDetailAST)).matches(actionNameRegex)) continue;
            return false;
        }
        return true;
    }

    private boolean _containsMethodName(DetailAST variableDefinitionDetailAST, String ... methodNameRegexArray) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String methodName = this.getMethodName(methodCallDetailAST);
            for (String methodNameRegex : methodNameRegexArray) {
                if (!methodName.matches(methodNameRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean _containsVariableType(DetailAST variableDefinitionDetailAST, String ... variableTypeNames) {
        List<DetailAST> identDetailASTList = this.getAllChildTokens(variableDefinitionDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!ArrayUtil.contains(variableTypeNames, this.getVariableTypeName(identDetailAST, identDetailAST.getText(), false))) continue;
            return true;
        }
        return false;
    }

    private int _getClosestParentLineNumber(DetailAST firstNameDetailAST, int lineNumber) {
        int closestLineNumber = firstNameDetailAST.getLineNo();
        DetailAST parentDetailAST = firstNameDetailAST.getParent();
        while (parentDetailAST.getLineNo() > lineNumber) {
            closestLineNumber = parentDetailAST.getLineNo();
            parentDetailAST = parentDetailAST.getParent();
        }
        return closestLineNumber;
    }

    private DetailAST _getElseOrIfStatementDetailAST(DetailAST detailAST, int lineNumber) {
        DetailAST elseOrIfStatementDetailAST = null;
        DetailAST slistDetailAST = this.getParentWithTokenType(detailAST, 7);
        while (slistDetailAST != null && slistDetailAST.getLineNo() >= lineNumber) {
            DetailAST parentDetailAST = slistDetailAST.getParent();
            if (parentDetailAST.getType() == 92 || parentDetailAST.getType() == 83) {
                elseOrIfStatementDetailAST = parentDetailAST;
            }
            slistDetailAST = this.getParentWithTokenType(slistDetailAST, 7);
        }
        return elseOrIfStatementDetailAST;
    }

    private DetailAST _getLastBranchingStatementDetailAST(DetailAST detailAST, int start, int end) {
        DetailAST lastBranchingStatementDetailAST = null;
        List<DetailAST> branchingStatementDetailASTList = this.getAllChildTokens(detailAST, true, 86, 87, 88);
        for (DetailAST branchingStatementDetailAST : branchingStatementDetailASTList) {
            int lineNumber = this.getEndLineNumber(branchingStatementDetailAST);
            if (start >= lineNumber || end <= lineNumber) continue;
            DetailAST branchedStatementDetailAST = null;
            branchedStatementDetailAST = branchingStatementDetailAST.getType() == 86 || branchingStatementDetailAST.getType() == 87 ? this.getParentWithTokenType(branchingStatementDetailAST, 85, 91, 84) : this.getParentWithTokenType(branchingStatementDetailAST, 8, 181, 9);
            if (branchedStatementDetailAST == null || branchedStatementDetailAST.getLineNo() >= start || lastBranchingStatementDetailAST != null && branchingStatementDetailAST.getLineNo() <= lastBranchingStatementDetailAST.getLineNo()) continue;
            lastBranchingStatementDetailAST = branchingStatementDetailAST;
        }
        return lastBranchingStatementDetailAST;
    }

    private boolean _hasChainStyle(DetailAST methodCallDetailAST, String ... methodNameRegexArray) {
        int startLineNumber = this.getStartLineNumber(methodCallDetailAST);
        String line = this.getLine(startLineNumber - 1);
        if (!line.endsWith("(") || ToolsUtil.getLevel(line) != 1) {
            return false;
        }
        for (String methodNameRegex : methodNameRegexArray) {
            if (!line.matches(".*[\\.>]" + methodNameRegex + "\\(")) continue;
            int level = 1;
            for (int i = startLineNumber + 1; i <= this.getEndLineNumber(methodCallDetailAST); ++i) {
                line = StringUtil.trim(this.getLine(i - 1));
                if (line.startsWith(").") && level == 1) {
                    return true;
                }
                level += ToolsUtil.getLevel(line);
            }
        }
        return false;
    }

    private boolean _isInsideMockitoMethodCall(DetailAST detailAST) {
        DetailAST methodCallDetailAST = this.getParentWithTokenType(detailAST, 27);
        if (methodCallDetailAST == null) {
            return false;
        }
        List<DetailAST> identDetailASTList = this.getAllChildTokens(methodCallDetailAST, true, 58);
        for (DetailAST identDetailAST : identDetailASTList) {
            if (!Objects.equals(identDetailAST.getText(), "Mockito")) continue;
            return true;
        }
        return false;
    }

    private boolean _isInsideStatementClause(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        DetailAST grandParentDetailAST;
        while ((grandParentDetailAST = parentDetailAST.getParent()) != null) {
            if (grandParentDetailAST.getType() == 91) {
                return parentDetailAST.getType() == 36 || parentDetailAST.getType() == 156 || parentDetailAST.getType() == 35 || parentDetailAST.getType() == 37;
            }
            if (grandParentDetailAST.getType() == 95) {
                return parentDetailAST.getType() == 176;
            }
            if (grandParentDetailAST.getType() == 84) {
                return parentDetailAST.getType() == 28;
            }
            parentDetailAST = grandParentDetailAST;
        }
        return false;
    }

    private boolean _matchesGetOrSetCall(DetailAST assignMethodCallDetailAST, DetailAST identDetailAST, String variableName) {
        String methodName = this.getMethodName(assignMethodCallDetailAST);
        if (methodName.matches("(?i)_?get" + variableName)) {
            return true;
        }
        DetailAST parentDetailAST = identDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 34 || parentDetailAST.getChildCount() != 1) {
            return false;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 27) {
            return false;
        }
        methodName = this.getMethodName(parentDetailAST);
        return methodName.matches("(?i)_?set" + variableName);
    }
}

