/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JIRAUtil {
    private static final Log _log = LogFactoryUtil.getLog(JIRAUtil.class);
    private static final Pattern _jiraTicketIdPattern = Pattern.compile("^[A-Z0-9]+-[0-9]+");

    public static void validateJIRAProjectNames(List<String> commitMessages, List<String> projectNames) throws Exception {
        if (projectNames.isEmpty()) {
            return;
        }
        block0: for (String commitMessage : commitMessages) {
            if (commitMessage.startsWith("Revert ") || commitMessage.startsWith("artifact:ignore") || commitMessage.startsWith("build.gradle auto SF") || commitMessage.endsWith("/ci-merge.")) continue;
            for (String projectName : projectNames) {
                if (!commitMessage.startsWith(projectName)) continue;
                continue block0;
            }
            throw new Exception(StringBundler.concat("At least one commit message is missing a reference to a ", "required JIRA project: ", StringUtil.merge(projectNames, ", "), ". Please verify that the JIRA project keys are specified", "in ci.properties in the liferay-portal repository."));
        }
    }

    public static void validateJIRASecurityKeywords(List<String> commitMessages, List<String> keywords, int maxNumberOfTickets) {
        HashMap<String, Integer> responseCodeMap = new HashMap<String, Integer>();
        TreeSet<String> violatingCommitMessages = new TreeSet<String>();
        TreeSet<String> violatingWords = new TreeSet<String>();
        for (String commitMessage : commitMessages) {
            if (responseCodeMap.size() == maxNumberOfTickets) {
                return;
            }
            String jiraTicketId = JIRAUtil._getJIRATicketId(commitMessage);
            if (jiraTicketId == null) continue;
            Integer jiraTicketResponseCode = (Integer)responseCodeMap.get(jiraTicketId);
            if (jiraTicketResponseCode == null) {
                try {
                    jiraTicketResponseCode = JIRAUtil._getJIRATicketResponseCode(jiraTicketId);
                    responseCodeMap.put(jiraTicketId, jiraTicketResponseCode);
                }
                catch (IOException ioException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(ioException, ioException);
                    }
                    return;
                }
            }
            if (jiraTicketResponseCode != 401) continue;
            for (String keyword : keywords) {
                Pattern pattern = Pattern.compile("\\W(" + keyword + "\\w*)(\\W|\\Z)", 2);
                Matcher matcher = pattern.matcher(commitMessage);
                while (matcher.find()) {
                    violatingCommitMessages.add(commitMessage);
                    violatingWords.add(matcher.group(1));
                }
            }
        }
        JIRAUtil._printWarnings(ListUtil.fromCollection(violatingCommitMessages), ListUtil.fromCollection(violatingWords), 80);
    }

    public static void validateJIRATicketIds(List<String> commitMessages, int maxNumberOfTickets) throws Exception {
        HashSet<String> validatedTicketIds = new HashSet<String>();
        for (String commitMessage : commitMessages) {
            if (validatedTicketIds.size() == maxNumberOfTickets) {
                return;
            }
            String jiraTicketId = JIRAUtil._getJIRATicketId(commitMessage);
            if (jiraTicketId == null || !validatedTicketIds.add(jiraTicketId)) continue;
            try {
                if (JIRAUtil._getJIRATicketResponseCode(jiraTicketId) != 404) continue;
                throw new Exception(StringBundler.concat("Commit message is pointing to non-existing JIRA ", "issue: ", jiraTicketId));
            }
            catch (IOException ioException) {
                if (_log.isDebugEnabled()) {
                    _log.debug(ioException, ioException);
                }
                return;
            }
        }
    }

    private static String _getJIRATicketId(String commitMessage) {
        Matcher matcher = _jiraTicketIdPattern.matcher(commitMessage);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static int _getJIRATicketResponseCode(String jiraTicketId) throws IOException {
        URL url = new URL("https://issues.liferay.com/rest/api/2/issue/" + jiraTicketId);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(10000);
        httpURLConnection.setReadTimeout(10000);
        return httpURLConnection.getResponseCode();
    }

    private static void _printBorder(String delimeter, int lineLength) {
        System.out.print(delimeter);
        for (int i = 0; i < lineLength - 2; ++i) {
            System.out.print("_");
        }
        System.out.println(delimeter);
    }

    private static void _printWarningLine(String line, int lineLength) {
        String newLine = StringBundler.concat("|  ", line, "  |");
        while (newLine.length() < lineLength) {
            newLine = StringUtil.replaceLast(newLine, '|', " |");
        }
        System.out.println(newLine);
    }

    private static void _printWarningLine(String line, int lineLength, boolean wrapLine) {
        if (wrapLine) {
            if (line.length() <= lineLength - 6) {
                JIRAUtil._printWarningLine(line, lineLength);
                return;
            }
            int x = line.lastIndexOf(32, lineLength - 9);
            JIRAUtil._printWarningLine(line.substring(0, x) + "...", lineLength);
            return;
        }
        while (true) {
            if (line.length() <= lineLength - 6) {
                JIRAUtil._printWarningLine(line, lineLength);
                return;
            }
            int x = line.lastIndexOf(32, lineLength - 6);
            JIRAUtil._printWarningLine(line.substring(0, x), lineLength);
            line = StringUtil.trim(line.substring(x));
        }
    }

    private static void _printWarnings(List<String> violatingCommitMessages, List<String> violatingWords, int lineLength) {
        if (violatingCommitMessages.isEmpty()) {
            return;
        }
        JIRAUtil._printBorder(" ", lineLength);
        JIRAUtil._printWarningLine("", lineLength);
        StringBundler sb = new StringBundler();
        sb.append("The following ");
        if (violatingCommitMessages.size() == 1) {
            sb.append("commit contains ");
        } else {
            sb.append("commits contain ");
        }
        if (violatingWords.size() == 1) {
            sb.append("the word ");
        } else {
            sb.append("the words ");
        }
        for (int i = 0; i < violatingWords.size(); ++i) {
            sb.append("'");
            sb.append(violatingWords.get(i));
            sb.append("'");
            if (i < violatingWords.size() - 2) {
                sb.append(", ");
                continue;
            }
            if (i >= violatingWords.size() - 1) continue;
            sb.append(" and ");
        }
        sb.append(", which could reveal potential security vulnerablities:");
        JIRAUtil._printWarningLine(sb.toString(), lineLength, false);
        JIRAUtil._printWarningLine("", lineLength);
        for (String violatingCommitMessage : violatingCommitMessages) {
            JIRAUtil._printWarningLine("* " + violatingCommitMessage, lineLength, true);
        }
        JIRAUtil._printBorder("|", lineLength);
        System.out.println();
    }
}

